/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyIterator;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIterator<E>
implements Iterator<E> {
    private final LinkedList<Iterator<? extends E>> iterators = new LinkedList();
    private final HashSet<E> visitedNeighbors = new HashSet();
    private final Transformer<? super E, ? extends Iterator<? extends E>> transformer;
    private Iterator<? extends E> currentIterator;
    private E nextNeighbor;
    private boolean done;

    public GraphIterator(Iterator<? extends E> roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        if (roots == null || transformer == null) {
            throw new NullPointerException();
        }
        this.currentIterator = roots;
        this.transformer = transformer;
        this.loadNextNeighbor();
    }

    private void loadNextNeighbor() {
        if (this.currentIterator == EmptyIterator.instance()) {
            this.done = true;
        } else if (this.currentIterator.hasNext()) {
            E nextPossibleNeighbor = this.currentIterator.next();
            if (this.visitedNeighbors.contains(nextPossibleNeighbor)) {
                this.loadNextNeighbor();
            } else {
                this.nextNeighbor = nextPossibleNeighbor;
                this.visitedNeighbors.add(nextPossibleNeighbor);
                this.iterators.add(this.transformer.transform(nextPossibleNeighbor));
            }
        } else {
            Iterator stream = this.iterators.iterator();
            while (!this.currentIterator.hasNext() && stream.hasNext()) {
                this.currentIterator = (Iterator)stream.next();
                stream.remove();
            }
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = EmptyIterator.instance();
            }
            this.loadNextNeighbor();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E next = this.nextNeighbor;
        this.loadNextNeighbor();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.currentIterator);
    }
}

