/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetCommand;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetCommandAdapter;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetRowTransformer;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionTools {
    public static final ResultSetCommand CONSOLE_DUMP_COMMAND = new ConsoleDumpCommand();

    public static List<Map<String, Object>> execute(Connection connection, String sql) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute(sql);
            List<Map<String, Object>> list = ResultSetTools.convertToMaps(statement.getResultSet());
            return list;
        }
        finally {
            statement.close();
        }
    }

    public static void execute(Connection connection, String sql, ResultSetCommand command) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute(sql);
            command.execute(statement.getResultSet());
        }
        finally {
            statement.close();
        }
    }

    public static <E> List<E> execute(Connection connection, String sql, ResultSetRowTransformer<? extends E> transformer) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute(sql);
            List<? extends E> list = ResultSetTools.convertToList(statement.getResultSet(), transformer);
            return list;
        }
        finally {
            statement.close();
        }
    }

    public static void dump(Connection connection, String sql) throws SQLException {
        ConnectionTools.execute(connection, sql, CONSOLE_DUMP_COMMAND);
    }

    public static void dumpOn(Connection connection, String sql, PrintWriter pw) throws SQLException {
        ConnectionTools.execute(connection, sql, new DumpCommand(pw));
    }

    public static class ConsoleDumpCommand
    extends ResultSetCommandAdapter {
        public void execute(ResultSet resultSet) throws SQLException {
            ResultSetTools.dump(resultSet);
        }
    }

    public static class DumpCommand
    extends ResultSetCommandAdapter {
        private final PrintWriter printWriter;

        public DumpCommand(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        public void execute(ResultSet resultSet) throws SQLException {
            ResultSetTools.dumpOn(resultSet, this.printWriter);
        }
    }
}

