/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.RelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaMappedByRelationship;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.jpa2.context.OverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedMappingRelationshipStrategy2_0;
import org.eclipse.jpt.jpa.core.resource.java.OwnableRelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationArgumentMessages;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaMappedByRelationshipStrategy
extends AbstractJavaContextModel<JavaMappedByRelationship>
implements SpecifiedMappingRelationshipStrategy2_0,
SpecifiedMappedByRelationshipStrategy {
    protected String mappedByAttribute = this.buildMappedByAttribute();

    public GenericJavaMappedByRelationshipStrategy(JavaMappedByRelationship parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setMappedByAttribute_(this.buildMappedByAttribute());
    }

    @Override
    public String getMappedByAttribute() {
        return this.mappedByAttribute;
    }

    @Override
    public void setMappedByAttribute(String mappedByAttribute) {
        if (ObjectTools.notEquals((Object)mappedByAttribute, (Object)this.mappedByAttribute)) {
            this.getMappingAnnotationForUpdate().setMappedBy(mappedByAttribute);
            this.setMappedByAttribute_(mappedByAttribute);
        }
    }

    protected void setMappedByAttribute_(String mappedByAttribute) {
        String old = this.mappedByAttribute;
        this.mappedByAttribute = mappedByAttribute;
        this.firePropertyChanged("mappedByAttribute", old, mappedByAttribute);
    }

    protected String buildMappedByAttribute() {
        OwnableRelationshipMappingAnnotation annotation = this.getMappingAnnotation();
        return annotation == null ? null : annotation.getMappedBy();
    }

    protected OwnableRelationshipMappingAnnotation getMappingAnnotation() {
        return this.getRelationship().getMappingAnnotation();
    }

    protected OwnableRelationshipMappingAnnotation getMappingAnnotationForUpdate() {
        return this.getRelationship().getMappingAnnotationForUpdate();
    }

    @Override
    public JavaMappedByRelationship getRelationship() {
        return (JavaMappedByRelationship)this.parent;
    }

    @Override
    public String getTableName() {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? null : owner.getRelationship().getStrategy().getTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? null : owner.getRelationship().getStrategy().resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner != null && owner.getRelationship().getStrategy().tableNameIsInvalid(tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return this.getRelationshipOwner().getRelationship().getStrategy().getColumnTableNotValidDescription();
    }

    protected RelationshipMapping getRelationshipOwner() {
        return this.getRelationshipMapping().getRelationshipOwner();
    }

    @Override
    public boolean isOverridable() {
        return false;
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public boolean relationshipIsOwnedBy(RelationshipMapping otherMapping) {
        String otherEntityName;
        String thisEntityName = this.getEntityName();
        Entity otherEntity = otherMapping.getResolvedTargetEntity();
        String string = otherEntityName = otherEntity == null ? null : otherEntity.getName();
        return ObjectTools.equals((Object)thisEntityName, (Object)otherEntityName) && ObjectTools.equals((Object)this.mappedByAttribute, (Object)otherMapping.getName());
    }

    protected String getEntityName() {
        Entity entity = this.getRelationship().getEntity();
        return entity == null ? null : entity.getName();
    }

    @Override
    public RelationshipStrategy selectOverrideStrategy(OverrideRelationship2_0 overrideRelationship) {
        return null;
    }

    @Override
    public void addStrategy() {
        if (this.mappedByAttribute == null) {
            this.setMappedByAttribute("");
        }
    }

    @Override
    public void removeStrategy() {
        if (this.mappedByAttribute != null) {
            this.setMappedByAttribute(null);
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        OwnableRelationshipMappingAnnotation annotation = this.getMappingAnnotation();
        if (annotation != null && annotation.mappedByTouches(pos)) {
            result = this.getJavaCandidateMappedByAttributeNames();
        }
        return result;
    }

    @Override
    public Iterable<String> getCandidateMappedByAttributeNames() {
        return this.getRelationshipMapping().getTargetEntityNonTransientAttributeNames();
    }

    protected Iterable<String> getJavaCandidateMappedByAttributeNames() {
        return new TransformationIterable(this.getCandidateMappedByAttributeNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.mappedByAttribute == null) {
            return;
        }
        Entity targetEntity = this.getRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        AttributeMapping mappedByMapping = targetEntity.resolveAttributeMapping(this.mappedByAttribute);
        if (mappedByMapping == null) {
            messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPPING_UNRESOLVED_MAPPED_BY, new String[]{this.mappedByAttribute}));
            return;
        }
        if (!this.getRelationship().mayBeMappedBy(mappedByMapping)) {
            messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPPING_INVALID_MAPPED_BY, new String[]{this.mappedByAttribute}));
            return;
        }
        if (!((RelationshipMapping)mappedByMapping).isRelationshipOwner()) {
            messages.add(this.buildMessage(JptJpaCoreValidationMessages.MAPPING_MAPPED_BY_ON_BOTH_SIDES, new String[]{this.mappedByAttribute}));
        }
    }

    protected IMessage buildMessage(ValidationMessage msg, Object[] args) {
        SpecifiedPersistentAttribute attribute = this.getRelationshipMapping().getPersistentAttribute();
        String attributeDescription = attribute.isVirtual() ? JptJpaCoreValidationArgumentMessages.VIRTUAL_ATTRIBUTE_DESC : JptJpaCoreValidationArgumentMessages.ATTRIBUTE_DESC;
        TextRange textRange = attribute.isVirtual() ? attribute.getValidationTextRange() : this.getValidationTextRange();
        attributeDescription = NLS.bind((String)attributeDescription, (Object)attribute.getName());
        args = ArrayTools.add((Object[])args, (int)0, (Object)attributeDescription);
        return this.buildValidationMessage(textRange, msg, args);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationMappedByTextRange();
        return textRange != null ? textRange : this.getRelationship().getValidationTextRange();
    }

    protected TextRange getAnnotationMappedByTextRange() {
        OwnableRelationshipMappingAnnotation annotation = this.getMappingAnnotation();
        return annotation == null ? null : annotation.getMappedByTextRange();
    }
}

