/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.resource.xml.EFactoryTools;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCoreMessages;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.DeleteTypeRefactoringParticipant;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.TypeRefactoringParticipant;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmManagedType;
import org.eclipse.jpt.jpa.core.context.orm.OrmManagedTypeDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.jpa2_1.context.ConverterType2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.EntityMappings2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.OrmConverterType2_1;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.OrmPackage;
import org.eclipse.jpt.jpa.core.resource.orm.XmlConverter;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManagedType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityMappings
extends AbstractOrmXmlContextModel<OrmXml>
implements EntityMappings2_1 {
    protected final XmlEntityMappings xmlEntityMappings;
    protected String description;
    protected String package_;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected final OrmPersistenceUnitMetadata persistenceUnitMetadata;
    protected final Vector<OrmManagedType> managedTypes = new Vector();
    protected final ManagedTypeContainerAdapter managedTypeContainerAdapter = new ManagedTypeContainerAdapter();
    protected final AbstractJpaContextModel.ContextListContainer<OrmSequenceGenerator, XmlSequenceGenerator> sequenceGeneratorContainer;
    protected final AbstractJpaContextModel.ContextListContainer<OrmTableGenerator, XmlTableGenerator> tableGeneratorContainer;
    protected final OrmQueryContainer queryContainer;
    protected static Map<String, String> PRIMITIVE_CLASSES = null;
    protected final Vector<OrmPersistentType> structureChildren = new Vector();
    protected static final Predicate<OrmManagedType> TYPE_IS_PERSISTENT_TYPE = new TypeIsPersistentType();
    protected static final TypeLookupAdapter PERSISTENT_TYPE_LOOKUP_ADAPTER = new TypeLookupAdapter(){

        public Object resolveType(EntityMappings entityMappings, String className) {
            return entityMappings.getPersistenceUnit().getPersistentType(className);
        }
    };
    protected static final TypeLookupAdapter RESOURCE_TYPE_LOOKUP_ADAPTER = new TypeLookupAdapter(){

        public Object resolveType(EntityMappings entityMappings, String className) {
            return entityMappings.getJpaProject().getJavaResourceType(className);
        }
    };
    protected static final TypeLookupAdapter JDT_TYPE_LOOKUP_ADAPTER = new TypeLookupAdapter(){

        public Object resolveType(EntityMappings entityMappings, String className) {
            IJavaProject javaProject = entityMappings.getJpaProject().getJavaProject();
            return JavaProjectTools.findType((IJavaProject)javaProject, (String)className);
        }
    };
    protected static final Comparator<OrmManagedType> MAPPING_COMPARATOR = new Comparator<OrmManagedType>(){

        @Override
        public int compare(OrmManagedType o1, OrmManagedType o2) {
            int o2Sequence;
            int o1Sequence = o1.getXmlSequence();
            if (o1Sequence < (o2Sequence = o2.getXmlSequence())) {
                return -1;
            }
            if (o1Sequence == o2Sequence) {
                return 0;
            }
            return 1;
        }
    };
    protected static final XmlManagedType[] EMPTY_XML_MANAGED_TYPE_ARRAY = new XmlManagedType[0];
    protected static final Predicate<OrmManagedType> TYPE_IS_CONVERTER_TYPE = new TypeIsConverterType();

    protected AbstractEntityMappings(OrmXml parent, XmlEntityMappings xmlEntityMappings) {
        super(parent);
        this.xmlEntityMappings = xmlEntityMappings;
        this.description = this.xmlEntityMappings.getDescription();
        this.package_ = this.xmlEntityMappings.getPackage();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.specifiedCatalog = this.xmlEntityMappings.getCatalog();
        this.specifiedSchema = this.xmlEntityMappings.getSchema();
        this.persistenceUnitMetadata = this.buildPersistenceUnitMetadata();
        this.initializeManagedTypes();
        this.sequenceGeneratorContainer = this.buildSequenceGeneratorContainer();
        this.tableGeneratorContainer = this.buildTableGeneratorContainer();
        this.queryContainer = this.buildQueryContainer();
        this.initializeStructureChildren();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDescription_(this.xmlEntityMappings.getDescription());
        this.setPackage_(this.xmlEntityMappings.getPackage());
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.setSpecifiedCatalog_(this.xmlEntityMappings.getCatalog());
        this.setSpecifiedSchema_(this.xmlEntityMappings.getSchema());
        this.persistenceUnitMetadata.synchronizeWithResourceModel();
        this.syncManagedTypes();
        this.syncSequenceGenerators();
        this.syncTableGenerators();
        this.queryContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.persistenceUnitMetadata.update();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getManagedTypes());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSequenceGenerators());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getTableGenerators());
        this.queryContainer.update();
        this.updateStructureChildren();
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        if (this.getResource().equals((Object)jpaFile.getFile())) {
            rootStructureNodes.add(this);
        } else {
            for (PersistentType persistentType : this.getPersistentTypes()) {
                persistentType.addRootStructureNodesTo(jpaFile, rootStructureNodes);
            }
        }
    }

    @Override
    public OrmXml getOrmXml() {
        return (OrmXml)this.parent;
    }

    @Override
    public EntityMappings getMappingFileRoot() {
        return this;
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    @Override
    public Class<EntityMappings> getStructureType() {
        return EntityMappings.class;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlEntityMappings.getSelectionTextRange();
    }

    protected void initializeStructureChildren() {
        CollectionTools.addAll(this.structureChildren, this.getPersistentTypes());
    }

    protected void updateStructureChildren() {
        this.synchronizeCollection(this.getPersistentTypes(), this.structureChildren, "structureChildren");
    }

    public Iterable<OrmPersistentType> getStructureChildren() {
        return IterableTools.cloneLive(this.structureChildren);
    }

    @Override
    public int getStructureChildrenSize() {
        return this.structureChildren.size();
    }

    @Override
    public TextRange getFullTextRange() {
        return this.xmlEntityMappings.getFullTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlEntityMappings.containsOffset(textOffset);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (JpaStructureNode jpaStructureNode : this.getStructureChildren()) {
            if (!jpaStructureNode.containsOffset(textOffset)) continue;
            return jpaStructureNode.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public void dispose() {
        for (OrmPersistentType persistentType : this.getPersistentTypes()) {
            persistentType.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.isXmlMappingMetadataComplete() ? this.specifiedAccess : null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getAccess();
    }

    @Override
    public String getDefaultPersistentTypePackage() {
        return this.package_;
    }

    protected boolean isXmlMappingMetadataComplete() {
        return this.getPersistenceUnit().isXmlMappingMetadataComplete();
    }

    @Override
    public OrmPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    protected OrmPersistenceUnitMetadata buildPersistenceUnitMetadata() {
        return this.getContextModelFactory().buildOrmPersistenceUnitMetadata(this);
    }

    @Override
    public XmlEntityMappings getXmlEntityMappings() {
        return this.xmlEntityMappings;
    }

    @Override
    public String getVersion() {
        return this.xmlEntityMappings.getDocumentVersion();
    }

    @Override
    public void changeMapping(OrmPersistentType ormPersistentType, OrmTypeMapping oldMapping, OrmTypeMapping newMapping) {
        AccessType savedAccess = ormPersistentType.getSpecifiedAccess();
        int sourceIndex = this.managedTypes.indexOf(ormPersistentType);
        this.managedTypes.remove(sourceIndex);
        oldMapping.removeXmlTypeMappingFrom(this.xmlEntityMappings);
        int targetIndex = this.calculateInsertionIndex(ormPersistentType);
        this.managedTypes.add(targetIndex, ormPersistentType);
        newMapping.addXmlTypeMappingTo(this.xmlEntityMappings);
        newMapping.initializeFrom(oldMapping);
        ormPersistentType.setSpecifiedAccess(savedAccess);
        this.fireItemMoved("managedTypes", targetIndex, sourceIndex);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlEntityMappings.getValidationTextRange();
        return textRange != null ? textRange : this.getOrmXml().getValidationTextRange();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription_(description);
        this.xmlEntityMappings.setDescription(description);
    }

    protected void setDescription_(String description) {
        String old = this.description;
        this.description = description;
        this.firePropertyChanged("description", old, description);
    }

    @Override
    public String getPackage() {
        return this.package_;
    }

    @Override
    public void setPackage(String package_) {
        this.setPackage_(package_);
        this.xmlEntityMappings.setPackage(package_);
    }

    protected void setPackage_(String package_) {
        String old = this.package_;
        this.package_ = package_;
        this.firePropertyChanged("package", old, package_);
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        this.setSpecifiedAccess_(access);
        this.xmlEntityMappings.setAccess(AccessType.toOrmResourceModel(access));
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", old, access);
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromOrmResourceModel(this.xmlEntityMappings.getAccess(), this.getJpaPlatform(), this.getResourceType());
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    protected AccessType buildDefaultAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        this.setSpecifiedCatalog_(catalog);
        this.xmlEntityMappings.setCatalog(catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog() {
        return this.getPersistenceUnit().getDefaultCatalog();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        this.setSpecifiedSchema_(schema);
        this.xmlEntityMappings.setSchema(schema);
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema() {
        return this.getPersistenceUnit().getDefaultSchema();
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public ListIterable<OrmManagedType> getManagedTypes() {
        return IterableTools.cloneLive(this.managedTypes);
    }

    @Override
    public int getManagedTypesSize() {
        return this.managedTypes.size();
    }

    @Override
    public OrmManagedType getManagedType(String typeName) {
        for (OrmManagedType ormManagedType : this.getManagedTypes()) {
            if (!ormManagedType.isFor(typeName)) continue;
            return ormManagedType;
        }
        return null;
    }

    @Override
    public boolean containsManagedType(String typeName) {
        return this.getManagedType(typeName) != null;
    }

    @Override
    public Iterable<OrmPersistentType> getPersistentTypes() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getManagedTypes(), TYPE_IS_PERSISTENT_TYPE));
    }

    @Override
    public OrmPersistentType getPersistentType(String typeName) {
        OrmManagedType mt = this.getManagedType(typeName);
        if (mt != null && mt.getManagedTypeType() == PersistentType.class) {
            return (OrmPersistentType)mt;
        }
        return null;
    }

    public boolean containsPersistentType(String className) {
        return this.getPersistentType(className) != null;
    }

    @Override
    public PersistentType resolvePersistentType(String className) {
        return (PersistentType)this.resolveType(PERSISTENT_TYPE_LOOKUP_ADAPTER, className);
    }

    @Override
    public JavaResourceAbstractType resolveJavaResourceType(String className) {
        return (JavaResourceAbstractType)this.resolveType(RESOURCE_TYPE_LOOKUP_ADAPTER, className);
    }

    @Override
    public JavaResourceAbstractType resolveJavaResourceType(String className, JavaResourceAnnotatedElement.AstNodeType astNodeType) {
        JavaResourceAbstractType resourceType = this.resolveJavaResourceType(className);
        if (resourceType == null || resourceType.getAstNodeType() != astNodeType) {
            return null;
        }
        return resourceType;
    }

    @Override
    public IType resolveJdtType(String className) {
        return (IType)this.resolveType(JDT_TYPE_LOOKUP_ADAPTER, className);
    }

    @Override
    public String qualify(String className) {
        if (StringTools.isBlank((String)className)) {
            return null;
        }
        String primitiveClassName = AbstractEntityMappings.getPrimitiveClassName(className);
        if (primitiveClassName != null) {
            return primitiveClassName;
        }
        if (this.package_ != null && className.indexOf(46) == -1) {
            className = this.prependGlobalPackage(className);
        }
        className = className.replace('$', '.');
        return className;
    }

    protected Object resolveType(TypeLookupAdapter adapter, String className) {
        return className == null ? null : adapter.resolveType(this, this.qualify(className));
    }

    protected String prependGlobalPackage(String unqualifiedClassName) {
        return String.valueOf(this.package_) + '.' + unqualifiedClassName;
    }

    protected static String getPrimitiveClassName(String className) {
        if (PRIMITIVE_CLASSES == null) {
            PRIMITIVE_CLASSES = new HashMap<String, String>();
            PRIMITIVE_CLASSES.put("Boolean", Boolean.class.getName());
            PRIMITIVE_CLASSES.put("Byte", Byte.class.getName());
            PRIMITIVE_CLASSES.put("Character", Character.class.getName());
            PRIMITIVE_CLASSES.put("Double", Double.class.getName());
            PRIMITIVE_CLASSES.put("Float", Float.class.getName());
            PRIMITIVE_CLASSES.put("Integer", Integer.class.getName());
            PRIMITIVE_CLASSES.put("Long", Long.class.getName());
            PRIMITIVE_CLASSES.put("Number", Number.class.getName());
            PRIMITIVE_CLASSES.put("Short", Short.class.getName());
            PRIMITIVE_CLASSES.put("String", String.class.getName());
            PRIMITIVE_CLASSES.put("boolean", "boolean");
            PRIMITIVE_CLASSES.put("byte", "byte");
            PRIMITIVE_CLASSES.put("char", "char");
            PRIMITIVE_CLASSES.put("double", "double");
            PRIMITIVE_CLASSES.put("float", "float");
            PRIMITIVE_CLASSES.put("int", "int");
            PRIMITIVE_CLASSES.put("long", "long");
            PRIMITIVE_CLASSES.put("short", "short");
            PRIMITIVE_CLASSES.put("byte[]", "byte[]");
            PRIMITIVE_CLASSES.put("char[]", "char[]");
            PRIMITIVE_CLASSES.put("boolean[]", "boolean[]");
            PRIMITIVE_CLASSES.put("double[]", "double[]");
            PRIMITIVE_CLASSES.put("float[]", "float[]");
            PRIMITIVE_CLASSES.put("int[]", "int[]");
            PRIMITIVE_CLASSES.put("long[]", "long[]");
            PRIMITIVE_CLASSES.put("short[]", "short[]");
        }
        return className == null ? null : PRIMITIVE_CLASSES.get(className);
    }

    @Override
    public OrmPersistentType addPersistentType(String mappingKey, String className) {
        OrmTypeMappingDefinition md = this.getMappingFileDefinition().getTypeMappingDefinition(mappingKey);
        XmlTypeMapping xmlManagedType = md.buildResourceMapping(this.getResourceModelFactory());
        return (OrmPersistentType)this.addManagedType(xmlManagedType, className);
    }

    protected OrmManagedType addManagedType(XmlManagedType xmlManagedType, String className) {
        xmlManagedType.setClassName(this.normalizeClassName(className));
        OrmManagedType managedType = this.buildManagedType(xmlManagedType);
        int index = this.calculateInsertionIndex(managedType);
        this.addItemToList(index, managedType, this.managedTypes, "managedTypes");
        managedType.addXmlManagedTypeTo(this.xmlEntityMappings);
        return managedType;
    }

    @Override
    public void addPersistentTypes(PersistentType.Config[] typeConfigs, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)3);
        if (sm.isCanceled()) {
            return;
        }
        this.addMappedSuperclasses(typeConfigs, (IProgressMonitor)sm.newChild(1));
        if (sm.isCanceled()) {
            return;
        }
        this.addEntities(typeConfigs, (IProgressMonitor)sm.newChild(1));
        if (sm.isCanceled()) {
            return;
        }
        this.addEmbeddables(typeConfigs, (IProgressMonitor)sm.newChild(1));
    }

    protected void addMappedSuperclasses(PersistentType.Config[] typeConfigs, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)5);
        sm.setTaskName(JptJpaCoreMessages.MAKE_PERSISTENT_PROCESSING_MAPPED_SUPERCLASSES);
        List<OrmPersistentType> addedItems = this.addOrmPersistentTypes(typeConfigs, "mappedSuperclass", (IProgressMonitor)sm.newChild(4));
        if (addedItems.size() == 0 || sm.isCanceled()) {
            return;
        }
        ArrayList<XmlMappedSuperclass> mappedSuperclasses = new ArrayList<XmlMappedSuperclass>(addedItems.size());
        for (OrmPersistentType persistentType : addedItems) {
            mappedSuperclasses.add((XmlMappedSuperclass)persistentType.getXmlManagedType());
        }
        sm.subTask(JptJpaCoreMessages.MAKE_PERSISTENT_ADD_TO_XML_RESOURCE_MODEL);
        this.xmlEntityMappings.getMappedSuperclasses().addAll(mappedSuperclasses);
        sm.worked(1);
    }

    protected void addEntities(PersistentType.Config[] typeConfigs, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)5);
        sm.setTaskName(JptJpaCoreMessages.MAKE_PERSISTENT_PROCESSING_ENTITIES);
        List<OrmPersistentType> addedItems = this.addOrmPersistentTypes(typeConfigs, "entity", (IProgressMonitor)sm.newChild(4));
        if (addedItems.size() == 0 || sm.isCanceled()) {
            return;
        }
        ArrayList<XmlEntity> entities = new ArrayList<XmlEntity>(addedItems.size());
        for (OrmPersistentType persistentType : addedItems) {
            entities.add((XmlEntity)persistentType.getXmlManagedType());
        }
        sm.subTask(JptJpaCoreMessages.MAKE_PERSISTENT_ADD_TO_XML_RESOURCE_MODEL);
        this.xmlEntityMappings.getEntities().addAll(0, entities);
        sm.worked(1);
    }

    protected void addEmbeddables(PersistentType.Config[] typeConfigs, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)5);
        sm.setTaskName(JptJpaCoreMessages.MAKE_PERSISTENT_PROCESSING_EMBEDDABLES);
        List<OrmPersistentType> addedItems = this.addOrmPersistentTypes(typeConfigs, "embeddable", (IProgressMonitor)sm.newChild(4));
        if (addedItems.size() == 0 || sm.isCanceled()) {
            return;
        }
        ArrayList<XmlEmbeddable> embeddables = new ArrayList<XmlEmbeddable>(addedItems.size());
        for (OrmPersistentType persistentType : addedItems) {
            embeddables.add((XmlEmbeddable)persistentType.getXmlManagedType());
        }
        sm.subTask(JptJpaCoreMessages.MAKE_PERSISTENT_ADD_TO_XML_RESOURCE_MODEL);
        this.xmlEntityMappings.getEmbeddables().addAll(0, embeddables);
        sm.worked(1);
    }

    protected List<OrmPersistentType> addOrmPersistentTypes(PersistentType.Config[] typeConfigs, String mappingKey, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        ArrayList<OrmPersistentType> addedItems = new ArrayList<OrmPersistentType>();
        PersistentType.Config[] configArray = typeConfigs;
        int n = typeConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            PersistentType.Config typeConfig = configArray[n2];
            if (typeConfig.getMappingKey() == mappingKey) {
                String typeName = typeConfig.getName();
                sm.subTask(NLS.bind((String)JptJpaCoreMessages.MAKE_PERSISTENT_BUILDING_PERSISTENT_TYPE, (Object)typeName));
                OrmTypeMappingDefinition md = this.getMappingFileDefinition().getTypeMappingDefinition(typeConfig.getMappingKey());
                XmlTypeMapping xmlTypeMapping = md.buildResourceMapping(this.getResourceModelFactory());
                typeName = this.normalizeClassName(typeName);
                xmlTypeMapping.setClassName(typeName);
                addedItems.add((OrmPersistentType)this.buildManagedType(xmlTypeMapping));
            }
            ++n2;
        }
        if (addedItems.size() == 0 || sm.isCanceled()) {
            return addedItems;
        }
        sm.worked(1);
        int index = this.calculateInsertionIndex((OrmManagedType)addedItems.get(0));
        sm.subTask(JptJpaCoreMessages.MAKE_PERSISTENT_UPDATING_JPA_MODEL);
        this.addItemsToList(index, addedItems, this.managedTypes, "managedTypes");
        sm.worked(9);
        return addedItems;
    }

    protected String normalizeClassName(String className) {
        return this.package_ != null && className.startsWith(this.package_) && className.charAt(this.package_.length()) == '.' && className.indexOf(46, this.package_.length() + 1) == -1 ? className.substring(this.package_.length() + 1) : className;
    }

    protected OrmManagedType buildManagedType(XmlManagedType xmlManagedType) {
        OrmManagedTypeDefinition md = this.getMappingFileDefinition().getManagedTypeDefinition(xmlManagedType.getManagedTypeType());
        return md.buildContextManagedType(this, xmlManagedType, this.getContextModelFactory());
    }

    protected int calculateInsertionIndex(OrmManagedType ormManagedType) {
        return ListTools.insertionIndexOf(this.managedTypes, (Object)ormManagedType, MAPPING_COMPARATOR);
    }

    @Override
    public void removeManagedType(int index) {
        OrmManagedType managedType = this.removeManagedType_(index);
        managedType.removeXmlManagedTypeFrom(this.xmlEntityMappings);
    }

    protected OrmManagedType removeManagedType_(int index) {
        OrmManagedType managedType = this.removeItemFromList(index, this.managedTypes, "managedTypes");
        managedType.dispose();
        return managedType;
    }

    @Override
    public void removeManagedType(OrmManagedType managedType) {
        this.removeManagedType(this.managedTypes.indexOf(managedType));
    }

    protected void initializeManagedTypes() {
        for (XmlManagedType xmlManagedType : this.getXmlManagedTypes()) {
            this.managedTypes.add(this.buildManagedType(xmlManagedType));
        }
    }

    protected void syncManagedTypes() {
        ContextContainerTools.synchronizeWithResourceModel(this.managedTypeContainerAdapter);
    }

    protected Iterable<XmlManagedType> getXmlManagedTypes() {
        return IterableTools.cloneLive(this.getXmlManagedTypes_());
    }

    protected List<XmlManagedType> getXmlManagedTypes_() {
        ArrayList<XmlManagedType> types = new ArrayList<XmlManagedType>();
        CollectionTools.addAll(types, (Object[])((XmlManagedType[])this.xmlEntityMappings.getMappedSuperclasses().toArray((Object[])EMPTY_XML_MANAGED_TYPE_ARRAY)));
        CollectionTools.addAll(types, (Object[])((XmlManagedType[])this.xmlEntityMappings.getEntities().toArray((Object[])EMPTY_XML_MANAGED_TYPE_ARRAY)));
        CollectionTools.addAll(types, (Object[])((XmlManagedType[])this.xmlEntityMappings.getEmbeddables().toArray((Object[])EMPTY_XML_MANAGED_TYPE_ARRAY)));
        if (this.isJpa2_1Compatible()) {
            CollectionTools.addAll(types, (Object[])this.getXml2_1Converters().toArray(EMPTY_XML_MANAGED_TYPE_ARRAY));
        }
        return types;
    }

    protected List<XmlConverter> getXml2_1Converters() {
        return this.xmlEntityMappings.getConverters();
    }

    protected void moveManagedType_(int index, OrmManagedType managedType) {
        this.moveItemInList(index, managedType, this.managedTypes, "managedTypes");
    }

    protected void addManagedType_(int index, XmlManagedType xmlManagedType) {
        this.addItemToList(index, this.buildManagedType(xmlManagedType), this.managedTypes, "managedTypes");
    }

    protected void removeManagedType_(OrmManagedType managedType) {
        this.removeManagedType_(this.managedTypes.indexOf(managedType));
    }

    @Override
    public ListIterable<OrmSequenceGenerator> getSequenceGenerators() {
        return this.sequenceGeneratorContainer;
    }

    @Override
    public int getSequenceGeneratorsSize() {
        return this.sequenceGeneratorContainer.size();
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        return this.addSequenceGenerator(this.getSequenceGeneratorsSize());
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator(int index) {
        XmlSequenceGenerator xmlGenerator = this.buildXmlSequenceGenerator();
        OrmSequenceGenerator sequenceGenerator = (OrmSequenceGenerator)this.sequenceGeneratorContainer.addContextElement(index, xmlGenerator);
        this.xmlEntityMappings.getSequenceGenerators().add(index, (Object)xmlGenerator);
        return sequenceGenerator;
    }

    protected XmlSequenceGenerator buildXmlSequenceGenerator() {
        return OrmFactory.eINSTANCE.createXmlSequenceGenerator();
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator xmlSequenceGenerator) {
        return this.getContextModelFactory().buildOrmSequenceGenerator(this, xmlSequenceGenerator);
    }

    @Override
    public void removeSequenceGenerator(OrmSequenceGenerator sequenceGenerator) {
        this.removeSequenceGenerator(this.sequenceGeneratorContainer.indexOf(sequenceGenerator));
    }

    @Override
    public void removeSequenceGenerator(int index) {
        this.sequenceGeneratorContainer.remove(index);
        this.xmlEntityMappings.getSequenceGenerators().remove(index);
    }

    @Override
    public void moveSequenceGenerator(int targetIndex, int sourceIndex) {
        this.sequenceGeneratorContainer.move(targetIndex, sourceIndex);
        this.xmlEntityMappings.getSequenceGenerators().move(targetIndex, sourceIndex);
    }

    protected void syncSequenceGenerators() {
        this.sequenceGeneratorContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlSequenceGenerator> getXmlSequenceGenerators() {
        return IterableTools.cloneLive(this.xmlEntityMappings.getSequenceGenerators());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSequenceGenerator, XmlSequenceGenerator> buildSequenceGeneratorContainer() {
        return this.buildSpecifiedContextListContainer("sequenceGenerators", new SequenceGeneratorContainerAdapter());
    }

    @Override
    public ListIterable<OrmTableGenerator> getTableGenerators() {
        return this.tableGeneratorContainer;
    }

    @Override
    public int getTableGeneratorsSize() {
        return this.tableGeneratorContainer.size();
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        return this.addTableGenerator(this.getTableGeneratorsSize());
    }

    @Override
    public OrmTableGenerator addTableGenerator(int index) {
        XmlTableGenerator xmlTableGenerator = this.buildXmlTableGenerator();
        OrmTableGenerator tableGenerator = (OrmTableGenerator)this.tableGeneratorContainer.addContextElement(index, xmlTableGenerator);
        this.xmlEntityMappings.getTableGenerators().add(index, (Object)xmlTableGenerator);
        return tableGenerator;
    }

    protected XmlTableGenerator buildXmlTableGenerator() {
        return OrmFactory.eINSTANCE.createXmlTableGenerator();
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator xmlTableGenerator) {
        return this.getContextModelFactory().buildOrmTableGenerator(this, xmlTableGenerator);
    }

    @Override
    public void removeTableGenerator(OrmTableGenerator tableGenerator) {
        this.removeTableGenerator(this.tableGeneratorContainer.indexOf(tableGenerator));
    }

    @Override
    public void removeTableGenerator(int index) {
        this.tableGeneratorContainer.remove(index);
        this.xmlEntityMappings.getTableGenerators().remove(index);
    }

    @Override
    public void moveTableGenerator(int targetIndex, int sourceIndex) {
        this.tableGeneratorContainer.move(targetIndex, sourceIndex);
        this.xmlEntityMappings.getTableGenerators().move(targetIndex, sourceIndex);
    }

    protected void syncTableGenerators() {
        this.tableGeneratorContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlTableGenerator> getXmlTableGenerators() {
        return IterableTools.cloneLive(this.xmlEntityMappings.getTableGenerators());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmTableGenerator, XmlTableGenerator> buildTableGeneratorContainer() {
        return this.buildSpecifiedContextListContainer("tableGenerators", new TableGeneratorContainerAdapter());
    }

    @Override
    public Iterable<OrmConverterType2_1> getConverterTypes() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getManagedTypes(), TYPE_IS_CONVERTER_TYPE));
    }

    @Override
    public OrmConverterType2_1 getConverterType(String typeName) {
        OrmManagedType mt = this.getManagedType(typeName);
        if (mt != null && mt.getManagedTypeType() == ConverterType2_1.class) {
            return (OrmConverterType2_1)mt;
        }
        return null;
    }

    @Override
    public boolean containsConverterType(String typeName) {
        return this.getConverterType(typeName) != null;
    }

    @Override
    public OrmConverterType2_1 addConverterType(String className) {
        return (OrmConverterType2_1)this.addManagedType(this.buildXmlConverter(), className);
    }

    protected XmlConverter buildXmlConverter() {
        return (XmlConverter)EFactoryTools.create((EFactory)this.getResourceModelFactory(), (EClass)OrmPackage.eINSTANCE.getXmlConverter(), XmlConverter.class);
    }

    @Override
    public OrmQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    protected OrmQueryContainer buildQueryContainer() {
        return this.getContextModelFactory().buildOrmQueryContainer(this, this.xmlEntityMappings);
    }

    @Override
    public Iterable<Query> getMappingFileQueries() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.queryContainer.getQueries(), this.getTypeMappingQueries()});
    }

    protected Iterable<Query> getTypeMappingQueries() {
        return IterableTools.children(this.getTypeMappings(), TypeMapping.QUERIES_TRANSFORMER);
    }

    @Override
    public Iterable<Generator> getMappingFileGenerators() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getSequenceGenerators(), this.getTableGenerators(), this.getTypeMappingGenerators()});
    }

    protected Iterable<Generator> getTypeMappingGenerators() {
        return IterableTools.children(this.getTypeMappings(), TypeMapping.GENERATORS_TRANSFORMER);
    }

    protected Iterable<OrmTypeMapping> getTypeMappings() {
        return IterableTools.downCast((Iterable)IterableTools.transform(this.getPersistentTypes(), PersistentType.MAPPING_TRANSFORMER));
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateVersion(messages);
        this.queryContainer.validate(messages, reporter);
        for (OrmManagedType managedType : this.getManagedTypes()) {
            this.validateManagedType(managedType, messages, reporter);
        }
    }

    protected void validateVersion(List<IMessage> messages) {
        if (!this.getLatestDocumentVersion().equals(this.xmlEntityMappings.getDocumentVersion())) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.getResource(), (TextRange)this.xmlEntityMappings.getVersionTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.XML_VERSION_NOT_LATEST));
        }
    }

    protected String getLatestDocumentVersion() {
        return this.getJpaPlatform().getMostRecentSupportedResourceType(this.getContentType()).getVersion();
    }

    protected IContentType getContentType() {
        return XmlEntityMappings.CONTENT_TYPE;
    }

    protected void validateManagedType(OrmManagedType managedType, List<IMessage> messages, IReporter reporter) {
        try {
            managedType.validate(messages, reporter);
        }
        catch (Throwable exception) {
            JptJpaCorePlugin.instance().logError(exception);
        }
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return IterableTools.children(this.getManagedTypes(), (Transformer)new DeleteTypeRefactoringParticipant.DeleteTypeEditsTransformer(type));
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.children(this.getManagedTypes(), (Transformer)new TypeRefactoringParticipant.RenameTypeEditsTransformer(originalType, newName));
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.children(this.getManagedTypes(), (Transformer)new TypeRefactoringParticipant.MoveTypeEditsTransformer(originalType, newPackage));
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createManagedTypeRenamePackageEdits(originalPackage, newName), this.createRenamePackageEdit(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createManagedTypeRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.children(this.getManagedTypes(), (Transformer)new TypeRefactoringParticipant.RenamePackageEditsTransformer(originalPackage, newName));
    }

    protected Iterable<ReplaceEdit> createRenamePackageEdit(IPackageFragment originalPackage, String newName) {
        return ObjectTools.equals((Object)this.package_, (Object)originalPackage.getElementName()) ? new SingleElementIterable((Object)this.xmlEntityMappings.createRenamePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.queryContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmTableGenerator tableGenerator : this.getTableGenerators()) {
            result = tableGenerator.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        for (OrmSequenceGenerator seqGenerator : this.getSequenceGenerators()) {
            result = seqGenerator.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        result = this.persistenceUnitMetadata.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.packageTouches(pos)) {
            return this.getCandidatePackages();
        }
        for (OrmManagedType managedType : this.getManagedTypes()) {
            result = managedType.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.schemaTouches(pos)) {
            return this.getCandidateSchemata();
        }
        if (this.catalogTouches(pos)) {
            return this.getCandidateCatalogs();
        }
        return null;
    }

    protected boolean schemaTouches(int pos) {
        return this.getXmlEntityMappings().schemaTouches(pos);
    }

    protected Iterable<String> getCandidateSchemata() {
        SchemaContainer schemaContainer = this.getDbSchemaContainer();
        return schemaContainer != null ? schemaContainer.getSortedSchemaIdentifiers() : EmptyIterable.instance();
    }

    protected boolean catalogTouches(int pos) {
        return this.getXmlEntityMappings().catalogTouches(pos);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    private boolean packageTouches(int pos) {
        return this.getXmlEntityMappings().packageTouches(pos);
    }

    private Iterable<String> getCandidatePackages() {
        return this.getPersistenceUnit().getPackageNames();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ManagedTypeContainerAdapter
    implements ContextContainerTools.Adapter<OrmManagedType, XmlManagedType> {
        protected ManagedTypeContainerAdapter() {
        }

        @Override
        public Iterable<OrmManagedType> getContextElements() {
            return AbstractEntityMappings.this.getManagedTypes();
        }

        @Override
        public Iterable<XmlManagedType> getResourceElements() {
            return AbstractEntityMappings.this.getXmlManagedTypes();
        }

        @Override
        public XmlManagedType getResourceElement(OrmManagedType contextElement) {
            return contextElement.getXmlManagedType();
        }

        @Override
        public void moveContextElement(int index, OrmManagedType element) {
            AbstractEntityMappings.this.moveManagedType_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlManagedType resourceElement) {
            AbstractEntityMappings.this.addManagedType_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmManagedType element) {
            AbstractEntityMappings.this.removeManagedType_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SequenceGeneratorContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSequenceGenerator, XmlSequenceGenerator> {
        @Override
        public OrmSequenceGenerator buildContextElement(XmlSequenceGenerator resourceElement) {
            return AbstractEntityMappings.this.buildSequenceGenerator(resourceElement);
        }

        @Override
        public ListIterable<XmlSequenceGenerator> getResourceElements() {
            return AbstractEntityMappings.this.getXmlSequenceGenerators();
        }

        @Override
        public XmlSequenceGenerator extractResourceElement(OrmSequenceGenerator contextElement) {
            return contextElement.getXmlGenerator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TableGeneratorContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmTableGenerator, XmlTableGenerator> {
        @Override
        public OrmTableGenerator buildContextElement(XmlTableGenerator resourceElement) {
            return AbstractEntityMappings.this.buildTableGenerator(resourceElement);
        }

        @Override
        public ListIterable<XmlTableGenerator> getResourceElements() {
            return AbstractEntityMappings.this.getXmlTableGenerators();
        }

        @Override
        public XmlTableGenerator extractResourceElement(OrmTableGenerator contextElement) {
            return contextElement.getXmlGenerator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeIsConverterType
    extends PredicateAdapter<OrmManagedType> {
        public boolean evaluate(OrmManagedType mt) {
            return mt.getManagedTypeType() == ConverterType2_1.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeIsPersistentType
    extends PredicateAdapter<OrmManagedType> {
        public boolean evaluate(OrmManagedType mt) {
            return mt.getManagedTypeType() == PersistentType.class;
        }
    }

    protected static interface TypeLookupAdapter {
        public Object resolveType(EntityMappings var1, String var2);
    }
}

