/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.platform;

import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformFactory;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.internal.platform.InternalJpaPlatformGroupConfig;
import org.eclipse.jpt.jpa.core.internal.platform.InternalJpaPlatformManager;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

class InternalJpaPlatformConfig
implements JpaPlatform.Config {
    private final InternalJpaPlatformManager jpaPlatformManager;
    private final String id;
    private final String label;
    private final String factoryClassName;
    private IProjectFacetVersion jpaFacetVersion;
    private boolean default_ = false;
    private InternalJpaPlatformGroupConfig group;
    private String pluginId;
    private JpaPlatform jpaPlatform;

    InternalJpaPlatformConfig(InternalJpaPlatformManager jpaPlatformManager, String id, String label, String factoryClassName) {
        this.jpaPlatformManager = jpaPlatformManager;
        this.id = id;
        this.label = label;
        this.factoryClassName = factoryClassName;
    }

    public JpaPlatformManager getJpaPlatformManager() {
        return this.jpaPlatformManager;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    String getFactoryClassName() {
        return this.factoryClassName;
    }

    public IProjectFacetVersion getJpaFacetVersion() {
        return this.jpaFacetVersion;
    }

    void setJpaFacetVersion(IProjectFacetVersion jpaFacetVersion) {
        this.jpaFacetVersion = jpaFacetVersion;
    }

    public boolean supportsJpaFacetVersion(IProjectFacetVersion version) {
        if (!version.getProjectFacet().equals(JpaProject.FACET)) {
            throw new IllegalArgumentException(version.toString());
        }
        return this.jpaFacetVersion == null || this.jpaFacetVersion.equals(version);
    }

    public boolean isDefault() {
        return this.default_;
    }

    void setDefault(boolean default_) {
        this.default_ = default_;
    }

    public JpaPlatform.GroupConfig getGroupConfig() {
        return this.group;
    }

    void setGroup(InternalJpaPlatformGroupConfig group) {
        this.group = group;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public synchronized JpaPlatform getJpaPlatform() {
        if (this.jpaPlatform == null) {
            this.jpaPlatform = this.buildJpaPlatform();
        }
        return this.jpaPlatform;
    }

    private JpaPlatform buildJpaPlatform() {
        JpaPlatformFactory factory = this.buildJpaPlatformFactory();
        return factory == null ? null : factory.buildJpaPlatform(this);
    }

    private JpaPlatformFactory buildJpaPlatformFactory() {
        return (JpaPlatformFactory)ExtensionPointTools.instantiate((String)this.pluginId, (String)this.jpaPlatformManager.getExtensionPointName(), (String)this.factoryClassName, JpaPlatformFactory.class);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.label);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SupportsJpaFacetVersion
    extends CriterionPredicate<InternalJpaPlatformConfig, IProjectFacetVersion> {
        SupportsJpaFacetVersion(IProjectFacetVersion jpaFacetVersion) {
            super((Object)jpaFacetVersion);
        }

        public boolean evaluate(InternalJpaPlatformConfig config) {
            return config.supportsJpaFacetVersion((IProjectFacetVersion)this.criterion);
        }
    }
}

