/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryMember;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.JavaResourceTypeBinding;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryAbstractType
extends BinaryMember
implements JavaResourceAbstractType {
    private JavaResourceTypeBinding typeBinding;
    private String declaringTypeName;

    protected BinaryAbstractType(JavaResourceModel parent, TypeAdapter adapter) {
        super(parent, adapter);
        this.typeBinding = this.buildTypeBinding(adapter.getTypeBinding());
        this.declaringTypeName = this.buildDeclaringTypeName();
    }

    protected IType getElement() {
        return (IType)super.getElement();
    }

    @Override
    public void update() {
        super.update();
        this.updateTypeBinding();
        this.updateDeclaringTypeName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.typeBinding.getSimpleName());
    }

    @Override
    public String getName() {
        return this.typeBinding.getSimpleName();
    }

    @Override
    public JavaResourceTypeBinding getTypeBinding() {
        return this.typeBinding;
    }

    protected JavaResourceTypeBinding buildTypeBinding(ITypeBinding jdtTypeBinding) {
        return new JavaResourceTypeBinding(jdtTypeBinding);
    }

    protected void updateTypeBinding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return ObjectTools.equals((Object)packageFragment.getElementName(), (Object)this.typeBinding.getPackageName());
    }

    @Override
    public boolean isIn(IPackageFragmentRoot sourceFolder) {
        return this.getSourceFolder().equals(sourceFolder);
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getElement().getAncestor(3);
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    private String buildDeclaringTypeName() {
        IType declaringType = this.getElement().getDeclaringType();
        return declaringType == null ? null : declaringType.getFullyQualifiedName('.');
    }

    protected void updateDeclaringTypeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceType> getTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceEnum> getEnums() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceType> getAllTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceEnum> getAllEnums() {
        throw new UnsupportedOperationException();
    }

    static class TypeAdapter
    implements BinaryMember.MemberAdapter {
        private final IType type;
        private final ITypeBinding typeBinding;

        TypeAdapter(IType type) {
            this.type = type;
            this.typeBinding = this.buildTypeBinding();
        }

        protected ITypeBinding buildTypeBinding() {
            return (ITypeBinding)ASTTools.createBinding((IMember)this.type);
        }

        public IType getElement() {
            return this.type;
        }

        public ITypeBinding getTypeBinding() {
            return this.typeBinding;
        }

        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.type.getAnnotations();
        }
    }
}

