/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.SpecifiedDiscriminatorColumn;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.db.ColumnCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscriminatorColumnComposite<T extends Entity>
extends Pane<T> {
    public DiscriminatorColumnComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, JptJpaUiDetailsMessages.INHERITANCE_COMPOSITE_DISCRIMINATOR_COLUMN_GROUP_BOX, 2, null);
    }

    protected void initializeLayout(Composite container) {
        PropertyValueModel<SpecifiedDiscriminatorColumn> discriminatorColumnHolder = this.buildDiscriminatorColumnHolder();
        ModifiablePropertyValueModel<Boolean> enabledModel = this.buildDiscriminatorColumnEnabledHolder();
        this.addLabel(container, JptJpaUiDetailsMessages.DISCRIMINATOR_COLUMN_COMPOSITE_NAME, (PropertyValueModel)enabledModel);
        this.addDiscriminatorColumnCombo(container, discriminatorColumnHolder, (PropertyValueModel<Boolean>)enabledModel);
        this.addLabel(container, JptJpaUiDetailsMessages.DISCRIMINATOR_COLUMN_COMPOSITE_DISCRIMINATOR_TYPE, (PropertyValueModel)enabledModel);
        this.addDiscriminatorTypeCombo(container, discriminatorColumnHolder, (PropertyValueModel<Boolean>)enabledModel);
        Section detailsSection = this.getWidgetFactory().createSection(container, 18);
        detailsSection.setLayoutData((Object)new GridData(768));
        detailsSection.setText(JptJpaUiDetailsMessages.INHERITANCE_COMPOSITE_DETAILS_GROUP_BOX);
        detailsSection.setClient(this.initializeDetailsClient(detailsSection, discriminatorColumnHolder, (PropertyValueModel<Boolean>)enabledModel));
    }

    protected Control initializeDetailsClient(Section detailsSection, PropertyValueModel<SpecifiedDiscriminatorColumn> discriminatorColumnHolder, PropertyValueModel<Boolean> enabledModel) {
        Composite detailsClient = this.addSubPane((Composite)detailsSection, 2, 0, 0, 0, 0);
        detailsSection.setClient((Control)detailsClient);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        detailsSection.setLayoutData((Object)gridData);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_LENGTH, enabledModel);
        this.addLengthCombo(detailsClient, discriminatorColumnHolder, enabledModel);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_COLUMN_DEFINITION, enabledModel);
        this.addText(detailsClient, this.buildColumnDefinitionHolder(discriminatorColumnHolder), null, enabledModel);
        return detailsClient;
    }

    private ColumnCombo<SpecifiedDiscriminatorColumn> addDiscriminatorColumnCombo(Composite container, PropertyValueModel<SpecifiedDiscriminatorColumn> discriminatorColumnHolder, PropertyValueModel<Boolean> enabledModel) {
        return new ColumnCombo<SpecifiedDiscriminatorColumn>((Pane)this, discriminatorColumnHolder, enabledModel, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("specifiedName");
                propertyNames.add("defaultName");
                propertyNames.add("dbTable");
            }

            protected void propertyChanged(String propertyName) {
                if (propertyName.equals("dbTable")) {
                    this.doPopulate();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((SpecifiedDiscriminatorColumn)this.getSubject()).getDefaultName();
            }

            protected void setValue(String value) {
                ((SpecifiedDiscriminatorColumn)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((SpecifiedDiscriminatorColumn)this.getSubject()).getDbTable();
            }

            protected String getValue() {
                return ((SpecifiedDiscriminatorColumn)this.getSubject()).getSpecifiedName();
            }

            protected String buildNullDefaultValueEntry() {
                return JptCommonUiMessages.NONE_SELECTED;
            }

            protected String getHelpId() {
                return JpaHelpContextIds.ENTITY_INHERITANCE_DISCRIMINATOR_COLUMN;
            }

            public String toString() {
                return "DiscriminatorColumnComposite.columnCombo";
            }
        };
    }

    private PropertyValueModel<SpecifiedDiscriminatorColumn> buildDiscriminatorColumnHolder() {
        return new PropertyAspectAdapter<Entity, SpecifiedDiscriminatorColumn>(this.getSubjectHolder()){

            protected SpecifiedDiscriminatorColumn buildValue_() {
                return ((Entity)this.subject).getDiscriminatorColumn();
            }
        };
    }

    private EnumFormComboViewer<SpecifiedDiscriminatorColumn, DiscriminatorType> addDiscriminatorTypeCombo(Composite container, PropertyValueModel<SpecifiedDiscriminatorColumn> discriminatorColumnHolder, PropertyValueModel<Boolean> enabledModel) {
        return new EnumFormComboViewer<SpecifiedDiscriminatorColumn, DiscriminatorType>((Pane)this, discriminatorColumnHolder, enabledModel, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultDiscriminatorType");
                propertyNames.add("specifiedDiscriminatorType");
            }

            protected DiscriminatorType[] getChoices() {
                return DiscriminatorType.values();
            }

            protected DiscriminatorType getDefaultValue() {
                return ((SpecifiedDiscriminatorColumn)this.getSubject()).getDefaultDiscriminatorType();
            }

            protected String displayString(DiscriminatorType value) {
                switch (value) {
                    case CHAR: {
                        return JptJpaUiDetailsMessages.DISCRIMINATOR_COLUMN_COMPOSITE_CHAR;
                    }
                    case INTEGER: {
                        return JptJpaUiDetailsMessages.DISCRIMINATOR_COLUMN_COMPOSITE_INTEGER;
                    }
                    case STRING: {
                        return JptJpaUiDetailsMessages.DISCRIMINATOR_COLUMN_COMPOSITE_STRING;
                    }
                }
                throw new IllegalStateException();
            }

            protected String nullDisplayString() {
                return JptCommonUiMessages.NONE_SELECTED;
            }

            protected DiscriminatorType getValue() {
                return ((SpecifiedDiscriminatorColumn)this.getSubject()).getSpecifiedDiscriminatorType();
            }

            protected void setValue(DiscriminatorType value) {
                ((SpecifiedDiscriminatorColumn)this.getSubject()).setSpecifiedDiscriminatorType(value);
            }

            protected String getHelpId() {
                return JpaHelpContextIds.ENTITY_INHERITANCE_DISCRIMINATOR_TYPE;
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> buildDiscriminatorColumnEnabledHolder() {
        return new PropertyAspectAdapter<Entity, Boolean>(this.getSubjectHolder(), new String[]{"specifiedDiscriminatorColumnIsAllowed"}){

            protected Boolean buildValue_() {
                return this.subject != null && ((Entity)this.subject).specifiedDiscriminatorColumnIsAllowed();
            }
        };
    }

    private void addLengthCombo(Composite container, PropertyValueModel<SpecifiedDiscriminatorColumn> subjectHolder, PropertyValueModel<Boolean> enabledModel) {
        new IntegerCombo<SpecifiedDiscriminatorColumn>((Pane)this, subjectHolder, enabledModel, container){

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN_LENGTH;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<SpecifiedDiscriminatorColumn, Integer>(this.getSubjectHolder(), new String[]{"defaultLength"}){

                    protected Integer buildValue_() {
                        return ((SpecifiedDiscriminatorColumn)this.subject).getDefaultLength();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<SpecifiedDiscriminatorColumn, Integer>(this.getSubjectHolder(), new String[]{"specifiedLength"}){

                    protected Integer buildValue_() {
                        return ((SpecifiedDiscriminatorColumn)this.subject).getSpecifiedLength();
                    }

                    protected void setValue_(Integer value) {
                        ((SpecifiedDiscriminatorColumn)this.subject).setSpecifiedLength(value);
                    }
                };
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildColumnDefinitionHolder(PropertyValueModel<SpecifiedDiscriminatorColumn> discriminatorColumnHolder) {
        return new PropertyAspectAdapter<SpecifiedDiscriminatorColumn, String>(discriminatorColumnHolder, new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((SpecifiedDiscriminatorColumn)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((SpecifiedDiscriminatorColumn)this.subject).setColumnDefinition(value);
            }
        };
    }
}

