/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.validation.JptJpaEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaObjectTypeConverter
extends EclipseLinkJavaConverter<ObjectTypeConverterAnnotation>
implements EclipseLinkObjectTypeConverter {
    private String dataType;
    private String fullyQualifiedDataType;
    private String objectType;
    private String fullyQualifiedObjectType;
    protected final AbstractJpaContextModel.ContextListContainer<EclipseLinkJavaConversionValue, ConversionValueAnnotation> conversionValueContainer;
    private String defaultObjectValue;

    public EclipseLinkJavaObjectTypeConverter(EclipseLinkJavaConverterContainer parent, ObjectTypeConverterAnnotation converterAnnotation) {
        super(parent, converterAnnotation);
        this.dataType = converterAnnotation.getDataType();
        this.objectType = converterAnnotation.getObjectType();
        this.conversionValueContainer = this.buildConversionValueContainer();
        this.defaultObjectValue = converterAnnotation.getDefaultObjectValue();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDataType_(((ObjectTypeConverterAnnotation)this.converterAnnotation).getDataType());
        this.setObjectType_(((ObjectTypeConverterAnnotation)this.converterAnnotation).getObjectType());
        this.syncConversionValues();
        this.setDefaultObjectValue_(((ObjectTypeConverterAnnotation)this.converterAnnotation).getDefaultObjectValue());
    }

    @Override
    public void update() {
        super.update();
        this.setFullyQualifiedDataType(((ObjectTypeConverterAnnotation)this.converterAnnotation).getFullyQualifiedDataType());
        this.setFullyQualifiedObjectType(((ObjectTypeConverterAnnotation)this.converterAnnotation).getFullyQualifiedObjectType());
        this.updateModels((Iterable)this.getConversionValues());
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        ((ObjectTypeConverterAnnotation)this.converterAnnotation).setDataType(dataType);
        this.setDataType_(dataType);
    }

    protected void setDataType_(String dataType) {
        String old = this.dataType;
        this.dataType = dataType;
        this.firePropertyChanged("dataType", old, dataType);
    }

    @Override
    public String getFullyQualifiedDataType() {
        return this.fullyQualifiedDataType;
    }

    protected void setFullyQualifiedDataType(String dataType) {
        String old = this.fullyQualifiedDataType;
        this.fullyQualifiedDataType = dataType;
        this.firePropertyChanged("fullyQualifiedDataType", old, dataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        ((ObjectTypeConverterAnnotation)this.converterAnnotation).setObjectType(objectType);
        this.setObjectType_(objectType);
    }

    protected void setObjectType_(String objectType) {
        String old = this.objectType;
        this.objectType = objectType;
        this.firePropertyChanged("objectType", old, objectType);
    }

    @Override
    public String getFullyQualifiedObjectType() {
        return this.fullyQualifiedObjectType;
    }

    protected void setFullyQualifiedObjectType(String objectType) {
        String old = this.fullyQualifiedObjectType;
        this.fullyQualifiedObjectType = objectType;
        this.firePropertyChanged("fullyQualifiedObjectType", old, objectType);
    }

    public ListIterable<EclipseLinkJavaConversionValue> getConversionValues() {
        return this.conversionValueContainer;
    }

    @Override
    public int getConversionValuesSize() {
        return this.conversionValueContainer.size();
    }

    @Override
    public EclipseLinkConversionValue getConversionValue(int index) {
        return (EclipseLinkConversionValue)this.conversionValueContainer.get(index);
    }

    @Override
    public EclipseLinkJavaConversionValue addConversionValue() {
        return this.addConversionValue(this.getConversionValuesSize());
    }

    @Override
    public EclipseLinkJavaConversionValue addConversionValue(int index) {
        ConversionValueAnnotation annotation = ((ObjectTypeConverterAnnotation)this.converterAnnotation).addConversionValue(index);
        return (EclipseLinkJavaConversionValue)this.conversionValueContainer.addContextElement(index, (Object)annotation);
    }

    @Override
    public void removeConversionValue(EclipseLinkConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValueContainer.indexOf((JpaContextModel)((EclipseLinkJavaConversionValue)conversionValue)));
    }

    @Override
    public void removeConversionValue(int index) {
        ((ObjectTypeConverterAnnotation)this.converterAnnotation).removeConversionValue(index);
        this.conversionValueContainer.remove(index);
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        ((ObjectTypeConverterAnnotation)this.converterAnnotation).moveConversionValue(targetIndex, sourceIndex);
        this.conversionValueContainer.move(targetIndex, sourceIndex);
    }

    protected EclipseLinkJavaConversionValue buildConversionValue(ConversionValueAnnotation conversionValueAnnotation) {
        return new EclipseLinkJavaConversionValue(this, conversionValueAnnotation);
    }

    protected void syncConversionValues() {
        this.conversionValueContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<ConversionValueAnnotation> getConversionValueAnnotations() {
        return ((ObjectTypeConverterAnnotation)this.converterAnnotation).getConversionValues();
    }

    protected AbstractJpaContextModel.ContextListContainer<EclipseLinkJavaConversionValue, ConversionValueAnnotation> buildConversionValueContainer() {
        return this.buildSpecifiedContextListContainer("conversionValues", (AbstractJpaContextModel.Container.Adapter)new ConversionValueContainerAdapter());
    }

    @Override
    public Iterable<String> getDataValues() {
        return IterableTools.transform(this.getConversionValues(), EclipseLinkConversionValue.DATA_VALUE_TRANSFORMER);
    }

    @Override
    public int getDataValuesSize() {
        return this.getConversionValuesSize();
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String value) {
        ((ObjectTypeConverterAnnotation)this.converterAnnotation).setDefaultObjectValue(value);
        this.setDefaultObjectValue_(value);
    }

    protected void setDefaultObjectValue_(String value) {
        String old = this.defaultObjectValue;
        this.defaultObjectValue = value;
        this.firePropertyChanged("defaultObjectValue", old, value);
    }

    @Override
    public Class<EclipseLinkObjectTypeConverter> getConverterType() {
        return EclipseLinkObjectTypeConverter.class;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.checkForDuplicateDataValues(messages);
        for (EclipseLinkJavaConversionValue conversionValue : this.getConversionValues()) {
            conversionValue.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateDataValues(List<IMessage> messages) {
        for (ArrayList<EclipseLinkJavaConversionValue> dups : this.mapConversionValuesByDataValue().values()) {
            if (dups.size() <= 1) continue;
            for (EclipseLinkJavaConversionValue dup : dups) {
                messages.add(this.buildValidationMessage(dup.getDataValueTextRange(), JptJpaEclipseLinkCoreValidationMessages.MULTIPLE_OBJECT_VALUES_FOR_DATA_VALUE, new Object[]{dup.getDataValue()}));
            }
        }
    }

    protected HashMap<String, ArrayList<EclipseLinkJavaConversionValue>> mapConversionValuesByDataValue() {
        HashMap<String, ArrayList<EclipseLinkJavaConversionValue>> map = new HashMap<String, ArrayList<EclipseLinkJavaConversionValue>>(this.getConversionValuesSize());
        for (EclipseLinkJavaConversionValue conversionValue : this.getConversionValues()) {
            String dataValue = conversionValue.getDataValue();
            ArrayList<EclipseLinkJavaConversionValue> list = map.get(dataValue);
            if (list == null) {
                list = new ArrayList();
                map.put(dataValue, list);
            }
            list.add(conversionValue);
        }
        return map;
    }

    @Override
    protected boolean isEquivalentTo_(EclipseLinkConverter other) {
        return super.isEquivalentTo_(other) && this.isEquivalentTo_((EclipseLinkObjectTypeConverter)other);
    }

    protected boolean isEquivalentTo_(EclipseLinkObjectTypeConverter other) {
        return ObjectTools.equals((Object)this.fullyQualifiedObjectType, (Object)other.getFullyQualifiedObjectType()) && ObjectTools.equals((Object)this.fullyQualifiedDataType, (Object)other.getFullyQualifiedDataType()) && ObjectTools.equals((Object)this.defaultObjectValue, (Object)other.getDefaultObjectValue()) && this.conversionValuesAreEquivalentTo(other);
    }

    protected boolean conversionValuesAreEquivalentTo(EclipseLinkObjectTypeConverter converter) {
        ArrayList conversionValues1 = ListTools.list(this.getConversionValues());
        ArrayList conversionValues2 = ListTools.list(converter.getConversionValues());
        if (conversionValues1.size() != conversionValues2.size()) {
            return false;
        }
        int i = 0;
        while (i < conversionValues1.size()) {
            if (!((EclipseLinkJavaConversionValue)conversionValues1.get(i)).isEquivalentTo((EclipseLinkConversionValue)conversionValues2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void convertTo(EclipseLinkOrmConverterContainer ormConverterContainer) {
        ormConverterContainer.addObjectTypeConverter(this.getName()).convertFrom(this);
    }

    @Override
    public void delete() {
        ((EclipseLinkJavaConverterContainer)this.parent).removeObjectTypeConverter(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConversionValueContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<EclipseLinkJavaConversionValue, ConversionValueAnnotation> {
        public ConversionValueContainerAdapter() {
            super((AbstractJpaContextModel)EclipseLinkJavaObjectTypeConverter.this);
        }

        public EclipseLinkJavaConversionValue buildContextElement(ConversionValueAnnotation resourceElement) {
            return EclipseLinkJavaObjectTypeConverter.this.buildConversionValue(resourceElement);
        }

        public ListIterable<ConversionValueAnnotation> getResourceElements() {
            return EclipseLinkJavaObjectTypeConverter.this.getConversionValueAnnotations();
        }

        public ConversionValueAnnotation extractResourceElement(EclipseLinkJavaConversionValue contextElement) {
            return contextElement.getConversionValueAnnotation();
        }
    }
}

