/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConversionValueAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EclipseLinkSourceConversionValueAnnotation
extends SourceAnnotation
implements ConversionValueAnnotation {
    private DeclarationAnnotationElementAdapter<String> dataValueDeclarationAdapter = this.buildDataValueDeclarationAdapter();
    private AnnotationElementAdapter<String> dataValueAdapter = this.buildDataValueAdapter();
    private String dataValue;
    private TextRange dataValueTextRange;
    private DeclarationAnnotationElementAdapter<String> objectValueDeclarationAdapter = this.buildObjectValueDeclarationAdapter();
    private AnnotationElementAdapter<String> objectValueAdapter = this.buildObjectValueAdapter();
    private String objectValue;
    private TextRange objectValueTextRange;

    public static EclipseLinkSourceConversionValueAnnotation buildNestedSourceConversionValueAnnotation(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        return new EclipseLinkSourceConversionValueAnnotation(parent, element, idaa);
    }

    private EclipseLinkSourceConversionValueAnnotation(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, element, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(element, idaa));
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ConversionValue";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.dataValue = this.buildDataValue(astAnnotation);
        this.dataValueTextRange = this.buildDataValueTextRange(astAnnotation);
        this.objectValue = this.buildObjectValue(astAnnotation);
        this.objectValueTextRange = this.buildObjectValueTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncDataValue(this.buildDataValue(astAnnotation));
        this.dataValueTextRange = this.buildDataValueTextRange(astAnnotation);
        this.syncObjectValue(this.buildObjectValue(astAnnotation));
        this.objectValueTextRange = this.buildObjectValueTextRange(astAnnotation);
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String dataValue) {
        if (ObjectTools.notEquals((Object)this.dataValue, (Object)dataValue)) {
            this.dataValue = dataValue;
            this.dataValueAdapter.setValue((Object)dataValue);
        }
    }

    private void syncDataValue(String astDataValue) {
        String old = this.dataValue;
        this.dataValue = astDataValue;
        this.firePropertyChanged("dataValue", old, astDataValue);
    }

    private String buildDataValue(Annotation astAnnotation) {
        return (String)this.dataValueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getDataValueTextRange() {
        return this.dataValueTextRange;
    }

    private TextRange buildDataValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.dataValueDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildDataValueDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"dataValue");
    }

    private AnnotationElementAdapter<String> buildDataValueAdapter() {
        return this.buildStringElementAdapter(this.dataValueDeclarationAdapter);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String objectValue) {
        if (ObjectTools.notEquals((Object)this.objectValue, (Object)objectValue)) {
            this.objectValue = objectValue;
            this.objectValueAdapter.setValue((Object)objectValue);
        }
    }

    private void syncObjectValue(String astObjectValue) {
        String old = this.objectValue;
        this.objectValue = astObjectValue;
        this.firePropertyChanged("objectValue", old, astObjectValue);
    }

    private String buildObjectValue(Annotation astAnnotation) {
        return (String)this.objectValueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getObjectValueTextRange() {
        return this.objectValueTextRange;
    }

    private TextRange buildObjectValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.objectValueDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildObjectValueDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"objectValue");
    }

    private AnnotationElementAdapter<String> buildObjectValueAdapter() {
        return this.buildStringElementAdapter(this.objectValueDeclarationAdapter);
    }

    public boolean isUnset() {
        return super.isUnset() && this.dataValue == null && this.objectValue == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.dataValue);
        sb.append("=>");
        sb.append(this.objectValue);
    }
}

