/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.operations;

import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jpt.common.core.internal.operations.AbstractJptFileCreationDataModelProvider;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.JaxbPreferences;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.jpt.jaxb.eclipselink.core.JptJaxbEclipseLinkCoreMessages;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.operations.OxmFileCreationDataModelProperties;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.operations.OxmFileCreationOperation;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.plugin.JptJaxbEclipseLinkCorePlugin;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlBindings;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OxmFileCreationDataModelProvider
extends AbstractJptFileCreationDataModelProvider
implements OxmFileCreationDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new OxmFileCreationOperation(this.getDataModel());
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("OxmFileCreationDataModelProperties.VERSION");
        propertyNames.add("OxmFileCreationDataModelProperties.PACKAGE_NAME");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("OxmFileCreationDataModelProperties.VERSION")) {
            return this.getDefaultVersion();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected String getDefaultFileName() {
        return "oxm.xml";
    }

    protected final String getDefaultVersion() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        JaxbProject jaxbProject = this.getJaxbProject_(project);
        JaxbPlatformDefinition jaxbPlatformDef = jaxbProject != null ? jaxbProject.getPlatform().getDefinition() : this.getJaxbPlatformDefinition();
        return jaxbPlatformDef.getMostRecentSupportedResourceType(this.getContentType()).getVersion();
    }

    protected String getPackageName() {
        return this.getStringProperty("OxmFileCreationDataModelProperties.PACKAGE_NAME");
    }

    protected IContentType getContentType() {
        return EXmlBindings.CONTENT_TYPE;
    }

    protected JaxbPlatformDefinition getJaxbPlatformDefinition() {
        IProject project = this.getProject();
        return project == null ? null : this.getJaxbPlatformDefinition(project);
    }

    protected JaxbPlatformDefinition getJaxbPlatformDefinition(IProject project) {
        String jaxbPlatformID = JaxbPreferences.getJaxbPlatformID((IProject)project);
        JaxbPlatformManager jaxbPlatformManager = this.getJaxbPlatformManager();
        return jaxbPlatformManager == null ? null : jaxbPlatformManager.getJaxbPlatformDefinition(jaxbPlatformID);
    }

    protected JaxbProject getJaxbProject() {
        return this.getJaxbProject(this.getProject());
    }

    protected JaxbProject getJaxbProject(IProject project) {
        return project == null ? null : this.getJaxbProject_(project);
    }

    protected JaxbProject getJaxbProject_(IProject project) {
        JaxbProjectManager jaxbProjectManager = this.getJaxbProjectManager();
        return jaxbProjectManager == null ? null : jaxbProjectManager.getJaxbProject(project);
    }

    protected JaxbPlatformManager getJaxbPlatformManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbPlatformManager();
    }

    protected JaxbProjectManager getJaxbProjectManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbProjectManager();
    }

    protected JaxbWorkspace getJaxbWorkspace() {
        return (JaxbWorkspace)ResourcesPlugin.getWorkspace().getAdapter(JaxbWorkspace.class);
    }

    public IStatus validate(String propertyName) {
        IStatus status = super.validate(propertyName);
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals("OxmFileCreationDataModelProperties.PACKAGE_NAME")) {
            status = this.validatePackageName();
        }
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateContainerPathAndFileName() {
        IStatus status = super.validateContainerPathAndFileName();
        if (!status.isOK()) {
            return status;
        }
        IContainer container = this.getContainer();
        IProject project = container.getProject();
        if (!ProjectTools.hasFacet((IProject)project, (IProjectFacet)JaxbProject.FACET)) {
            return JptJaxbEclipseLinkCorePlugin.instance().buildErrorStatus(JptJaxbEclipseLinkCoreMessages.VALIDATE__NEW_OXM_FILE__PROJECT_NOT_JAXB);
        }
        if (!this.isEclipseLink(project)) {
            return JptJaxbEclipseLinkCorePlugin.instance().buildErrorStatus(JptJaxbEclipseLinkCoreMessages.VALIDATE__NEW_OXM_FILE__PROJECT_NOT_ECLIPSELINK);
        }
        ProjectResourceLocator resourceLocator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
        if (!resourceLocator.locationIsValid(container)) {
            return JptJaxbEclipseLinkCorePlugin.instance().buildWarningStatus(JptJaxbEclipseLinkCoreMessages.VALIDATE__NEW_OXM_FILE__CONTAINER_QUESTIONABLE);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validatePackageName() {
        String packageName = this.getPackageName();
        if (StringTools.isBlank((String)packageName)) {
            return JptJaxbEclipseLinkCorePlugin.instance().buildWarningStatus(JptJaxbEclipseLinkCoreMessages.VALIDATE__NEW_OXM_FILE__PACKAGE_UNSPECIFIED);
        }
        IStatus status = JavaConventions.validatePackageName((String)packageName, (String)"1.5", (String)"1.5");
        if (!status.isOK()) {
            return status;
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null && IterableTools.isEmpty((Iterable)JavaProjectTools.getPackageFragments((IJavaProject)javaProject, (String)packageName))) {
            return JptJaxbEclipseLinkCorePlugin.instance().buildWarningStatus(JptJaxbEclipseLinkCoreMessages.VALIDATE__NEW_OXM_FILE__PACKAGE_DOESNT_EXIST);
        }
        return Status.OK_STATUS;
    }

    protected boolean isEclipseLink(IProject project) {
        JaxbPlatformDefinition def = this.getJaxbPlatformDefinition(project);
        return def != null && ObjectTools.equals((Object)def.getConfig().getGroupConfig(), (Object)this.getJaxbPlatformManager().getJaxbPlatformGroupConfig("eclipselink"));
    }
}

