/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.WSDLException;
import org.eclipse.persistence.dbws.DBWSModel;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectClassConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectXMLConfig;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.DBWSBuilderHelper;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModel;
import org.eclipse.persistence.tools.dbws.DBWSBuilderModelProject;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.DefaultNamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.OperationModel;
import org.eclipse.persistence.tools.dbws.SQLOperationModel;
import org.eclipse.persistence.tools.dbws.SQLX2003Transformer;
import org.eclipse.persistence.tools.dbws.TableOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.WSDLGenerator;
import org.eclipse.persistence.tools.dbws.XRPackager;
import org.eclipse.persistence.tools.dbws.jdbc.JDBCHelper;
import org.eclipse.persistence.tools.dbws.oracle.OracleHelper;

public class DBWSBuilder
extends DBWSBuilderModel {
    public static final String BUILDER_FILE_PATH = "-builderFile";
    public static final String BUILDER_PACKAGING = "-packageAs";
    public static final String STAGE_DIR = "-stageDir";
    public static final String DRIVER_KEY = "driver";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    public static final String URL_KEY = "url";
    public static final String PROJNAME_KEY = "projectName";
    public static final String DEFAULT_PROJECT_NAME = "myProject";
    public static final String CONTEXT_ROOT_KEY = "contextRoot";
    public static final String DATASOURCE_KEY = "dataSource";
    public static final String SESSIONS_FILENAME_KEY = "sessionsFileName";
    public static final String NO_SESSIONS_FILENAME = "no-sessions-fileName";
    public static final String PLATFORM_CLASSNAME_KEY = "platformClassname";
    public static final String ORSESSION_CUSTOMIZER_KEY = "orSessionCustomizerClassName";
    public static final String OXSESSION_CUSTOMIZER_KEY = "oxSessionCustomizerClassName";
    public static final String WSDL_URI_KEY = "wsdlLocationURI";
    public static final String LOG_LEVEL_KEY = "logLevel";
    public static final String TARGET_NAMESPACE_KEY = "targetNamespace";
    public static final String USE_SOAP12_KEY = "useSOAP12";
    public static Map<String, DBWSPackager> PACKAGERS = new HashMap<String, DBWSPackager>();
    protected DBWSPackager packager;
    protected Logger logger;
    public boolean quiet = false;
    protected String destDir;
    protected DatabasePlatform databasePlatform;
    protected Connection conn;
    protected Project orProject;
    protected Project oxProject;
    protected WSDLGenerator wsdlGenerator = null;
    protected Schema schema = new Schema();
    protected NamespaceResolver ns = this.schema.getNamespaceResolver();
    protected XRServiceModel xrServiceModel = new DBWSModel();
    protected DBWSBuilderHelper builderHelper = null;
    protected NamingConventionTransformer topTransformer;
    protected Set<String> typeDDL = new HashSet<String>();
    protected Set<String> typeDropDDL = new HashSet<String>();
    public List<String> requireCRUDOperations = new ArrayList<String>();

    public DBWSBuilder() {
        this.ns.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.ns.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    public static void main(String[] args) throws WSDLException {
        DBWSBuilder builder = new DBWSBuilder();
        builder.start(args);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void start(String[] args) throws WSDLException {
        block13: {
            if (args.length > 5 && BUILDER_FILE_PATH.equals(args[0]) && STAGE_DIR.equals(args[2]) && args[4].startsWith(BUILDER_PACKAGING)) {
                File builderFile;
                String builderFilename = args[1];
                String stageDirname = args[3];
                String packagerTag = args[5];
                String archiverTag = null;
                DBWSPackager.ArchiveUse archiveUse = DBWSPackager.ArchiveUse.ignore;
                int cIdx = args[4].indexOf(58);
                if (cIdx == 10) {
                    archiverTag = args[4].substring(cIdx + 1);
                    if (DBWSPackager.ArchiveUse.archive.name().equals(archiverTag)) {
                        archiveUse = DBWSPackager.ArchiveUse.archive;
                    } else if (DBWSPackager.ArchiveUse.noArchive.name().equals(archiverTag)) {
                        archiveUse = DBWSPackager.ArchiveUse.noArchive;
                    }
                }
                String[] additionalArgs = null;
                if (args.length > 6) {
                    additionalArgs = new String[args.length - 6];
                    System.arraycopy(args, 6, additionalArgs, 0, args.length - 6);
                }
                if ((builderFile = new File(builderFilename)).exists() && builderFile.isFile()) {
                    File stageDir = new File(stageDirname);
                    if (stageDir.exists() && stageDir.isDirectory()) {
                        XMLContext context = new XMLContext((Project)new DBWSBuilderModelProject());
                        XMLUnmarshaller unmarshaller = context.createUnmarshaller();
                        DBWSBuilderModel model = (DBWSBuilderModel)unmarshaller.unmarshal(builderFile);
                        this.properties = model.properties;
                        this.operations = model.operations;
                        if (this.operations.size() == 0) {
                            this.logMessage(Level.SEVERE, "No operations specified");
                            return;
                        }
                        this.packager = PACKAGERS.get(packagerTag);
                        if (this.packager != null) {
                            this.packager.setDBWSBuilder(this);
                            this.packager.setArchiveUse(archiveUse);
                            this.packager.setAdditionalArgs(additionalArgs);
                            this.packager.setStageDir(stageDir);
                            this.packager.setSessionsFileName(this.getSessionsFileName());
                            this.start();
                            return;
                        }
                        break block13;
                    } else {
                        this.logMessage(Level.SEVERE, "DBWSBuilder unable to locate stage directory " + stageDirname);
                        return;
                    }
                }
                this.logMessage(Level.SEVERE, "DBWSBuilder unable to locate dbws-builder.xml file " + builderFilename);
                return;
            }
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append("DBWSBuilder usage ([] indicates optional argument):\nprompt> java -cp eclipselink.jar:eclipselink-dbwsutils.jar:your_favourite_jdbc_driver.jar \\\n\t");
        sb.append(this.getClass().getName());
        sb.append(" ");
        sb.append(BUILDER_FILE_PATH);
        sb.append(" {path_to_dbwsbuilder.xml} \\\n\t");
        sb.append(STAGE_DIR);
        sb.append(" ");
        sb.append(" {path_to_stageDir}");
        sb.append(" ");
        sb.append(BUILDER_PACKAGING);
        sb.append("[:archive_flag - archive, noArchive, ignore] {packager} [additional arguments]\nAvailable packagers:\n\t");
        Iterator<Map.Entry<String, DBWSPackager>> i = PACKAGERS.entrySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                this.logMessage(Level.SEVERE, sb.toString());
                return;
            }
            Map.Entry<String, DBWSPackager> me = i.next();
            sb.append(me.getValue().getUsage());
            if (!i.hasNext()) continue;
            sb.append("\n\t");
        }
    }

    public void start() throws WSDLException {
        this.packager.setHasAttachments(this.hasAttachments());
        OutputStream dbwsSchemaStream = null;
        try {
            dbwsSchemaStream = this.packager.getSchemaStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-schema.xsd", fnfe);
            return;
        }
        OutputStream dbwsSessionsStream = null;
        try {
            dbwsSessionsStream = this.packager.getSessionsStream(this.getSessionsFileName());
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-sessions.xml", fnfe);
            return;
        }
        OutputStream dbwsServiceStream = null;
        try {
            dbwsServiceStream = this.packager.getServiceStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws.xml", fnfe);
            return;
        }
        OutputStream dbwsOrStream = null;
        try {
            dbwsOrStream = this.packager.getOrStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-or.xml", fnfe);
            return;
        }
        OutputStream dbwsOxStream = null;
        try {
            dbwsOxStream = this.packager.getOxStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws-ox.xml", fnfe);
            return;
        }
        OutputStream wsdlStream = null;
        try {
            wsdlStream = this.packager.getWSDLStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create eclipselink-dbws.wsdl", fnfe);
            return;
        }
        OutputStream swarefStream = null;
        try {
            swarefStream = this.packager.getSWARefStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create " + Util.SWAREF_FILENAME, fnfe);
            return;
        }
        OutputStream webXmlStream = null;
        try {
            webXmlStream = this.packager.getWebXmlStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create web.xml", fnfe);
            return;
        }
        OutputStream classProviderStream = null;
        try {
            classProviderStream = this.packager.getProviderClassStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create DBWSProvider.class", fnfe);
            return;
        }
        OutputStream sourceProviderStream = null;
        try {
            sourceProviderStream = this.packager.getProviderSourceStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create DBWSProvider.java", fnfe);
            return;
        }
        OutputStream classProviderListenerStream = null;
        try {
            classProviderListenerStream = this.packager.getProviderListenerClassStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create ProviderListener.class", fnfe);
            return;
        }
        OutputStream sourceProviderListenerStream = null;
        try {
            sourceProviderListenerStream = this.packager.getProviderListenerSourceStream();
        }
        catch (FileNotFoundException fnfe) {
            this.logMessage(Level.SEVERE, "DBWSBuilder unable to create ProviderListener.java", fnfe);
            return;
        }
        OutputStream deploymentDescriptorStream = null;
        if (this.packager.getDeploymentDescriptorFileName() != null) {
            try {
                deploymentDescriptorStream = this.packager.getDeploymentDescriptorStream();
            }
            catch (FileNotFoundException fnfe) {
                this.logMessage(Level.SEVERE, "DBWSBuilder unable to create " + this.packager.getDeploymentDescriptorFileName(), fnfe);
                return;
            }
        }
        this.build(dbwsSchemaStream, dbwsSessionsStream, dbwsServiceStream, dbwsOrStream, dbwsOxStream, swarefStream, webXmlStream, wsdlStream, classProviderStream, sourceProviderStream, classProviderListenerStream, sourceProviderListenerStream, deploymentDescriptorStream, this.logger);
    }

    public void build(OutputStream dbwsSchemaStream, OutputStream dbwsSessionsStream, OutputStream dbwsServiceStream, OutputStream dbwsOrStream, OutputStream dbwsOxStream, OutputStream swarefStream, OutputStream webXmlStream, OutputStream wsdlStream, OutputStream classProviderStream, OutputStream sourceProviderStream, OutputStream classProviderListenerStream, OutputStream sourceProviderListenerStream, Logger logger) throws WSDLException {
        this.build(dbwsSchemaStream, dbwsSessionsStream, dbwsServiceStream, dbwsOrStream, dbwsOxStream, swarefStream, webXmlStream, wsdlStream, classProviderStream, sourceProviderStream, classProviderListenerStream, sourceProviderListenerStream, null, logger);
    }

    public void build(OutputStream dbwsSchemaStream, OutputStream dbwsSessionsStream, OutputStream dbwsServiceStream, OutputStream dbwsOrStream, OutputStream dbwsOxStream, OutputStream swarefStream, OutputStream webXmlStream, OutputStream wsdlStream, OutputStream classProviderStream, OutputStream sourceProviderStream, OutputStream classProviderListenerStream, OutputStream sourceProviderListenerStream, OutputStream deploymentDescriptorStream, Logger logger) throws WSDLException {
        this.logger = logger;
        this.xrServiceModel.setName(this.getProjectName());
        String sessionsFileName = this.getSessionsFileName();
        if (sessionsFileName != null && sessionsFileName.length() > 0) {
            this.xrServiceModel.setSessionsFile(sessionsFileName);
        }
        if (this.topTransformer == null) {
            NamingConventionTransformer nextTransformer;
            ServiceLoader<NamingConventionTransformer> transformers = ServiceLoader.load(NamingConventionTransformer.class);
            Iterator<NamingConventionTransformer> transformerIter = transformers.iterator();
            this.topTransformer = transformerIter.next();
            LinkedList<NamingConventionTransformer> transformerList = new LinkedList<NamingConventionTransformer>();
            if (!((DefaultNamingConventionTransformer)this.topTransformer).isDefaultTransformer()) {
                while (transformerIter.hasNext()) {
                    nextTransformer = transformerIter.next();
                    if (!((DefaultNamingConventionTransformer)nextTransformer).isDefaultTransformer()) {
                        transformerList.addLast(nextTransformer);
                        continue;
                    }
                    if (!(nextTransformer instanceof SQLX2003Transformer)) continue;
                    transformerList.addLast(nextTransformer);
                }
            } else {
                while (transformerIter.hasNext()) {
                    transformerList.addLast(transformerIter.next());
                }
            }
            nextTransformer = this.topTransformer;
            for (NamingConventionTransformer nct : transformerList) {
                ((DefaultNamingConventionTransformer)nextTransformer).setNextTransformer(nct);
                nextTransformer = nct;
            }
        }
        this.packager.start();
        DBWSBuilderHelper helper = this.getBuilderHelper();
        helper.buildDbArtifacts();
        helper.buildOROXProjects(this.topTransformer, helper.buildTypesList(this.operations));
        helper.buildSchema(this.topTransformer);
        helper.buildSessionsXML(dbwsSessionsStream);
        this.packager.setHasAttachments(this.hasAttachments());
        helper.buildDBWSModel(this.topTransformer, dbwsServiceStream);
        helper.writeAttachmentSchema(swarefStream);
        helper.buildWSDL(wsdlStream, this.topTransformer);
        helper.writeWebXML(webXmlStream);
        helper.generateDBWSProvider(sourceProviderStream, classProviderStream, sourceProviderListenerStream, classProviderListenerStream);
        helper.writeSchema(dbwsSchemaStream);
        helper.writeOROXProjects(dbwsOrStream, dbwsOxStream);
        helper.writeDeploymentDescriptor(deploymentDescriptorStream);
        this.packager.end();
    }

    public OutputStream getShadowDDLStream() {
        return XRPackager.__nullStream;
    }

    @Deprecated
    public void addSqlOperation(SQLOperationModel sqlOperation) {
        this.operations.add(sqlOperation);
    }

    public void addOperation(OperationModel operation) {
        this.operations.add(operation);
    }

    protected ProjectConfig buildORProjectConfig() {
        ProjectXMLConfig orProjectConfig = null;
        boolean useProjectXML = false;
        if (this.builderHelper.hasTables() || this.hasBuildSqlOperations()) {
            useProjectXML = true;
        }
        if (!useProjectXML) {
            if (this.orProject.getQueries().size() > 0) {
                useProjectXML = true;
            } else if (this.orProject.getDescriptors().size() > 0) {
                Collection descriptors = this.orProject.getDescriptors().values();
                for (ClassDescriptor desc : descriptors) {
                    if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                    useProjectXML = true;
                    break;
                }
            }
        }
        if (useProjectXML) {
            orProjectConfig = new ProjectXMLConfig();
            String pathPrefix = this.packager.getOrProjectPathPrefix();
            orProjectConfig.setProjectString(pathPrefix == null ? "eclipselink-dbws-or.xml" : pathPrefix + "eclipselink-dbws-or.xml");
        } else {
            orProjectConfig = new ProjectClassConfig();
            orProjectConfig.setProjectString(Project.class.getName());
        }
        return orProjectConfig;
    }

    protected ProjectConfig buildOXProjectConfig() {
        ProjectXMLConfig oxProjectConfig = null;
        boolean useProjectXML = false;
        if (this.builderHelper.hasTables() || this.hasBuildSqlOperations()) {
            useProjectXML = true;
        }
        if (!useProjectXML) {
            if (this.orProject.getQueries().size() > 0) {
                useProjectXML = true;
            } else if (this.orProject.getDescriptors().size() > 0) {
                Collection descriptors = this.orProject.getDescriptors().values();
                for (ClassDescriptor desc : descriptors) {
                    if (!desc.isObjectRelationalDataTypeDescriptor()) continue;
                    useProjectXML = true;
                    break;
                }
            }
        }
        if (useProjectXML) {
            oxProjectConfig = new ProjectXMLConfig();
            String pathPrefix = this.packager.getOxProjectPathPrefix();
            oxProjectConfig.setProjectString(pathPrefix == null ? "eclipselink-dbws-ox.xml" : pathPrefix + "eclipselink-dbws-ox.xml");
        } else {
            oxProjectConfig = new ProjectClassConfig();
            oxProjectConfig.setProjectString(SimpleXMLFormatProject.class.getName());
        }
        return oxProjectConfig;
    }

    protected boolean hasAttachments() {
        for (Object op : this.xrServiceModel.getOperationsList()) {
            if (!(op instanceof QueryOperation) || !((QueryOperation)op).isAttachment()) continue;
            return true;
        }
        for (Object op : this.operations) {
            if (((OperationModel)op).getBinaryAttachment()) {
                return true;
            }
            if (!((OperationModel)op).isTableOperation()) continue;
            TableOperationModel top = (TableOperationModel)op;
            if (top.additionalOperations == null || top.additionalOperations.size() <= 0) continue;
            for (OperationModel addOp : top.additionalOperations) {
                if (!addOp.binaryAttachment) continue;
                return true;
            }
        }
        return false;
    }

    public DBWSPackager getPackager() {
        return this.packager;
    }

    public void setPackager(DBWSPackager packager) {
        this.packager = packager;
    }

    public String getDriver() {
        return (String)this.properties.get(DRIVER_KEY);
    }

    public void setDriver(String driver) {
        this.properties.put(DRIVER_KEY, driver);
    }

    public String getUsername() {
        return (String)this.properties.get(USERNAME_KEY);
    }

    public void setUsername(String username) {
        this.properties.put(USERNAME_KEY, username);
    }

    public String getPassword() {
        return (String)this.properties.get(PASSWORD_KEY);
    }

    public void setPassword(String password) {
        this.properties.put(PASSWORD_KEY, password);
    }

    public String getUrl() {
        return (String)this.properties.get(URL_KEY);
    }

    public void setUrl(String url) {
        this.properties.put(URL_KEY, url);
    }

    public Connection getConnection() {
        if (this.conn == null) {
            String driverClassName = this.getDriver();
            try {
                Class driverClass = null;
                driverClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(driverClassName)) : PrivilegedAccessHelper.getClassForName((String)driverClassName);
                Properties props = new Properties();
                props.put("user", this.getUsername());
                props.put(PASSWORD_KEY, this.getPassword());
                if (this.getPlatformClassname().contains("MySQL")) {
                    props.put("useInformationSchema", "true");
                }
                this.conn = DriverManager.getConnection(this.getUrl(), props);
            }
            catch (Exception e) {
                this.logMessage(Level.SEVERE, "JDBC driver error: " + driverClassName, e);
            }
        }
        return this.conn;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public String getProjectName() {
        String prjName = (String)this.properties.get(PROJNAME_KEY);
        return prjName != null && prjName.length() > 0 ? prjName : DEFAULT_PROJECT_NAME;
    }

    public void setProjectName(String projectName) {
        this.properties.put(PROJNAME_KEY, projectName);
    }

    public String getContextRoot() {
        String contextRoot = (String)this.properties.get(CONTEXT_ROOT_KEY);
        if (contextRoot == null) {
            contextRoot = "/" + this.getProjectName();
            this.setContextRoot(contextRoot);
        }
        return contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.properties.put(CONTEXT_ROOT_KEY, contextRoot);
    }

    public String getDataSource() {
        return (String)this.properties.get(DATASOURCE_KEY);
    }

    public void setDataSource(String dataSource) {
        this.properties.put(DATASOURCE_KEY, dataSource);
    }

    public String getSessionsFileName() {
        String sessionsFileName = (String)this.properties.get(SESSIONS_FILENAME_KEY);
        if (NO_SESSIONS_FILENAME.equals(sessionsFileName)) {
            return null;
        }
        if (sessionsFileName == null || sessionsFileName.length() == 0) {
            sessionsFileName = "eclipselink-dbws-sessions.xml";
            this.setSessionsFileName(sessionsFileName);
        }
        return sessionsFileName;
    }

    public void setSessionsFileName(String sessionsFileName) {
        this.properties.put(SESSIONS_FILENAME_KEY, sessionsFileName);
    }

    public String getPlatformClassname() {
        String platformClassname = (String)this.properties.get(PLATFORM_CLASSNAME_KEY);
        if (platformClassname == null || platformClassname.length() == 0) {
            platformClassname = "org.eclipse.persistence.platform.database.OraclePlatform";
            this.setPlatformClassname(platformClassname);
        }
        return platformClassname;
    }

    public void setPlatformClassname(String platformClassname) {
        this.properties.put(PLATFORM_CLASSNAME_KEY, platformClassname);
    }

    public DatabasePlatform getDatabasePlatform() {
        if (this.databasePlatform == null) {
            String platformClassname = this.getPlatformClassname();
            try {
                Class platformClass = null;
                platformClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(platformClassname)) : PrivilegedAccessHelper.getClassForName((String)platformClassname);
                this.databasePlatform = (DatabasePlatform)Helper.getInstanceFromClass((Class)platformClass);
            }
            catch (Exception e) {
                this.databasePlatform = new MySQLPlatform();
            }
        }
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public Project getOrProject() {
        return this.orProject;
    }

    public void setOrProject(Project orProject) {
        this.orProject = orProject;
    }

    public Project getOxProject() {
        return this.oxProject;
    }

    public void setOxProject(Project oxProject) {
        this.oxProject = oxProject;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public XRServiceModel getXrServiceModel() {
        return this.xrServiceModel;
    }

    public String getOrSessionCustomizerClassName() {
        return (String)this.properties.get(ORSESSION_CUSTOMIZER_KEY);
    }

    public void setOrSessionCustomizerClassName(String sessionCustomizerClassName) {
        this.properties.put(ORSESSION_CUSTOMIZER_KEY, sessionCustomizerClassName);
    }

    public String getOxSessionCustomizerClassName() {
        return (String)this.properties.get(OXSESSION_CUSTOMIZER_KEY);
    }

    public void setOXSessionCustomizerClassName(String sessionCustomizerClassName) {
        this.properties.put(OXSESSION_CUSTOMIZER_KEY, sessionCustomizerClassName);
    }

    public WSDLGenerator getWSDLGenerator() {
        return this.wsdlGenerator;
    }

    public String getWsdlLocationURI() {
        String wsdlLocationURI = (String)this.properties.get(WSDL_URI_KEY);
        if (wsdlLocationURI == null || wsdlLocationURI.length() == 0) {
            wsdlLocationURI = "REPLACE_WITH_ENDPOINT_ADDRESS";
        }
        return wsdlLocationURI;
    }

    public void setWsdlLocationURI(String wsdlLocationURI) {
        this.properties.put(WSDL_URI_KEY, wsdlLocationURI);
    }

    public String getLogLevel() {
        return (String)this.properties.get(LOG_LEVEL_KEY);
    }

    public void setLogLevel(String logLevel) {
        this.properties.put(LOG_LEVEL_KEY, logLevel);
    }

    public String getTargetNamespace() {
        String targetNamespace = (String)this.properties.get(TARGET_NAMESPACE_KEY);
        if (targetNamespace == null) {
            targetNamespace = "urn:" + this.getProjectName();
            this.setTargetNamespace(targetNamespace);
        }
        return targetNamespace;
    }

    public Set<String> getTypeDDL() {
        return this.typeDDL;
    }

    public Set<String> getTypeDropDDL() {
        return this.typeDropDDL;
    }

    public DBWSBuilderHelper getBuilderHelper() {
        if (this.builderHelper == null) {
            boolean isOracle = this.getDatabasePlatform().getClass().getName().contains("Oracle");
            this.builderHelper = isOracle ? new OracleHelper(this) : new JDBCHelper(this);
        }
        return this.builderHelper;
    }

    public void setBuilderHelper(DBWSBuilderHelper builderHelper) {
        this.builderHelper = builderHelper;
    }

    public void useSOAP12() {
        this.properties.put(USE_SOAP12_KEY, "true");
    }

    public boolean usesSOAP12() {
        boolean useSOAP12 = false;
        String s = (String)this.properties.get(USE_SOAP12_KEY);
        if (s != null) {
            useSOAP12 = s.toLowerCase().equals("true");
        }
        return useSOAP12;
    }

    public boolean mtomEnabled() {
        boolean mtomEnabled = false;
        for (OperationModel opModel : this.getOperations()) {
            String attachmentType = opModel.getAttachmentType();
            if (!"MTOM".equalsIgnoreCase(attachmentType) && !"SWAREF".equalsIgnoreCase(attachmentType)) continue;
            mtomEnabled = true;
            break;
        }
        return mtomEnabled;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.properties.put(TARGET_NAMESPACE_KEY, targetNamespace);
    }

    public void logMessage(Level level, String message) {
        if (this.logger != null) {
            this.logger.log(level, message);
        } else if (!this.quiet) {
            System.out.println(message);
        }
    }

    protected void logMessage(Level severe, String message, Exception e) {
        if (this.logger != null) {
            this.logger.log(severe, message, e);
        } else {
            PrintWriter pw = new PrintWriter(System.out);
            e.printStackTrace(pw);
            System.out.println(message);
        }
    }

    public NamingConventionTransformer getTopNamingConventionTransformer() {
        return this.topTransformer;
    }

    public void setTopNamingConventionTransformer(NamingConventionTransformer topTransformer) {
        this.topTransformer = topTransformer;
    }

    public boolean hasBuildSqlOperations() {
        boolean flag = false;
        for (OperationModel om : this.operations) {
            SQLOperationModel sqlOm;
            String buildSql;
            if (!om.isSQLOperation() || (buildSql = (sqlOm = (SQLOperationModel)om).getBuildSql()) == null || buildSql.length() <= 0) continue;
            flag = true;
            break;
        }
        return flag;
    }

    static {
        ServiceLoader<DBWSPackager> packagers = ServiceLoader.load(DBWSPackager.class);
        for (DBWSPackager packager : packagers) {
            PACKAGERS.put(packager.getPackagerLabel(), packager);
        }
    }
}

