/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmOneToManyRelationship2_0;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmOneToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmOneToManyMappingTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkOrmOneToManyMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("import java.util.Collection;");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.JoinTable").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.JoinColumn").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @JoinTable(name=\"DEP_EMP\", joinColumns=@JoinColumn(name=\"DEPT_ID\"), inverseJoinColumns=@JoinColumn(name=\"EMP_ID\"))").append(CR);
                sb.append("    private Collection<Employee> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    private void createTestTargetEntityAddress() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithOneToManyMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(fetch=FetchType.EAGER, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestTypeWithCollection() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"java.util.Collection"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("    private Collection<Foo> oneToMany;").append(CR);
            }
        });
    }

    public void testUpdatePrivateOwned() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        EclipseLinkOneToManyMapping contextOneToMany = (EclipseLinkOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToMany resourceOneToMany = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
        resourceOneToMany.setPrivateOwned(true);
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
        resourceOneToMany.setPrivateOwned(false);
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
    }

    public void testModifyPrivateOwned() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        EclipseLinkOneToManyMapping contextOneToMany = (EclipseLinkOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToMany resourceOneToMany = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
        contextOneToMany.getPrivateOwned().setPrivateOwned(true);
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
        contextOneToMany.getPrivateOwned().setPrivateOwned(false);
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
    }

    public void testUpdateJoinFetch() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        EclipseLinkOneToManyMapping contextOneToMany = (EclipseLinkOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToMany resourceOneToMany = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)contextOneToMany.getJoinFetch().getValue());
        resourceOneToMany.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextOneToMany.getJoinFetch().getValue());
        resourceOneToMany.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextOneToMany.getJoinFetch().getValue());
        resourceOneToMany.setJoinFetch(null);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)contextOneToMany.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("oneToMany"), "oneToMany");
        EclipseLinkOneToManyMapping contextOneToMany = (EclipseLinkOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToMany resourceOneToMany = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)contextOneToMany.getJoinFetch().getValue());
        contextOneToMany.getJoinFetch().setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextOneToMany.getJoinFetch().getValue());
        contextOneToMany.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextOneToMany.getJoinFetch().getValue());
        contextOneToMany.getJoinFetch().setValue(null);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)contextOneToMany.getJoinFetch().getValue());
    }

    public void testJoinFetchDefault() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        EclipseLinkOneToManyMapping oneToMany = (EclipseLinkOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        oneToMany = (EclipseLinkOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employees").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        oneToMany = (EclipseLinkOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)oneToMany.getJoinFetch().getValue());
    }

    public void testDefaultJoinTable() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        OrmPersistentAttribute attribute = departmentPersistentType.getAttributeNamed("employees");
        OneToManyMapping oneToMany = (OneToManyMapping)attribute.getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)attribute.isVirtual());
        SpecifiedJoinTable ormJoinTable = oneToMany.getRelationship().getJoinTableStrategy().getJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"DEP_EMP", (String)ormJoinTable.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"DEPT_ID", (String)((SpecifiedJoinColumn)ormJoinTable.getSpecifiedJoinColumns().iterator().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)((SpecifiedJoinColumn)ormJoinTable.getSpecifiedJoinColumns().iterator().next()).getReferencedColumnName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"EMP_ID", (String)((SpecifiedJoinColumn)ormJoinTable.getSpecifiedInverseJoinColumns().iterator().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"empId", (String)((SpecifiedJoinColumn)ormJoinTable.getSpecifiedInverseJoinColumns().iterator().next()).getReferencedColumnName());
        departmentPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        departmentPersistentType.addAttributeToXml(departmentPersistentType.getAttributeNamed("id"), "id");
        attribute = departmentPersistentType.getAttributeNamed("employees");
        oneToMany = (OneToManyMapping)attribute.getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)attribute.isVirtual());
        ormJoinTable = oneToMany.getRelationship().getJoinTableStrategy().getJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Department_Employee", (String)ormJoinTable.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Department_id", (String)ormJoinTable.getDefaultJoinColumn().getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)ormJoinTable.getDefaultJoinColumn().getReferencedColumnName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"employees_empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getReferencedColumnName());
        departmentPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.FALSE);
        attribute = departmentPersistentType.getAttributeNamed("employees");
        oneToMany = (OneToManyMapping)attribute.getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)attribute.isVirtual());
        ormJoinTable = oneToMany.getRelationship().getJoinTableStrategy().getJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"DEP_EMP", (String)ormJoinTable.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"DEPT_ID", (String)((SpecifiedJoinColumn)ormJoinTable.getSpecifiedJoinColumns().iterator().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)((SpecifiedJoinColumn)ormJoinTable.getSpecifiedJoinColumns().iterator().next()).getReferencedColumnName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"EMP_ID", (String)((SpecifiedJoinColumn)ormJoinTable.getSpecifiedInverseJoinColumns().iterator().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"empId", (String)((SpecifiedJoinColumn)ormJoinTable.getSpecifiedInverseJoinColumns().iterator().next()).getReferencedColumnName());
        departmentPersistentType.addAttributeToXml(departmentPersistentType.getAttributeNamed("employees"), "oneToMany");
        attribute = departmentPersistentType.getAttributeNamed("employees");
        oneToMany = (OneToManyMapping)attribute.getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)attribute.isVirtual());
        ormJoinTable = oneToMany.getRelationship().getJoinTableStrategy().getJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Department_Employee", (String)ormJoinTable.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((int)0, (int)ormJoinTable.getSpecifiedJoinColumnsSize());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Department_id", (String)ormJoinTable.getDefaultJoinColumn().getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)ormJoinTable.getDefaultJoinColumn().getReferencedColumnName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((int)0, (int)ormJoinTable.getSpecifiedInverseJoinColumnsSize());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"employees_empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getReferencedColumnName());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping ormOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)ormOneToManyMapping.getMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isPkMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setPkMapKey(true);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)ormOneToManyMapping.getMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isPkMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isNoMapKey());
        javaOneToManyMapping.setCustomMapKey(true);
        javaOneToManyMapping.setSpecifiedMapKey("city");
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"city", (String)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"city", (String)ormOneToManyMapping.getMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isPkMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isCustomMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isNoMapKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals(null, (String)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertEquals(null, (String)ormOneToManyMapping.getMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isPkMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)ormOneToManyMapping.isCustomMapKey());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)ormOneToManyMapping.isNoMapKey());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = oneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OneToManyMapping ormOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaOneToManyMapping javaOneToManyMapping = (JavaOneToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormPersistentType.getAttributeNamed("addresses").addToXml();
        ormOneToManyMapping = (OneToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = ormOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormOneToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = ormOneToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        EclipseLinkOrmOneToManyMapping contextMapping = (EclipseLinkOrmOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOrmOneToManyRelationship2_0 rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        EclipseLinkOrmOneToManyMapping contextMapping = (EclipseLinkOrmOneToManyMapping)contextAttribute.getMapping();
        EclipseLinkOrmOneToManyRelationship2_0 rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToMany resourceMapping = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLinkOrmOneToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EclipseLinkOneToManyMapping virtualOneToManyMapping = (EclipseLinkOneToManyMapping)virtualPersistentAttribute.getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"address", (String)virtualOneToManyMapping.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)virtualOneToManyMapping.getSpecifiedFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Address", (String)virtualOneToManyMapping.getSpecifiedTargetEntity());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade cascade = virtualOneToManyMapping.getCascade();
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.getOrderable().isOrderByOrdering());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"city", (String)virtualOneToManyMapping.getOrderable().getOrderBy().getKey());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)virtualOneToManyMapping.getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"oneToMany", (String)virtualPersistentAttribute.getMappingKey());
        EclipseLinkOneToManyMapping virtualOneToManyMapping = (EclipseLinkOneToManyMapping)virtualPersistentAttribute.getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"address", (String)virtualOneToManyMapping.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)virtualOneToManyMapping.getFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"test.Address", (String)virtualOneToManyMapping.getTargetEntity());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)virtualOneToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade cascade = virtualOneToManyMapping.getCascade();
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)virtualOneToManyMapping.getOrderable().isNoOrdering());
        EclipseLinkOrmOneToManyMappingTests.assertEquals(null, (String)virtualOneToManyMapping.getOrderable().getOrderBy().getKey());
        EclipseLinkOrmOneToManyMappingTests.assertEquals(null, (Object)virtualOneToManyMapping.getJoinFetch().getValue());
    }
}

