/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CompositeListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.tests.internal.iterator.ReadOnlyCompositeListIteratorTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeListIteratorTests
extends ReadOnlyCompositeListIteratorTests {
    public CompositeListIteratorTests(String name) {
        super(name);
    }

    @Override
    public void testRemove() {
        super.testRemove();
        List<String> list1 = this.buildList1();
        List<String> list2 = this.buildList2();
        List<String> list3 = this.buildList3();
        String firstElement3 = list3.get(0);
        ArrayList<ListIterator<String>> list = new ArrayList<ListIterator<String>>();
        list.add(list1.listIterator());
        list.add(list2.listIterator());
        list.add(list3.listIterator());
        ListIterator stream = (ListIterator)this.buildCompositeIterator(list.listIterator());
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            Object previous = stream.previous();
            if (previous.equals("333")) {
                stream.remove();
            }
            if (!previous.equals(firstElement3)) continue;
            stream.hasPrevious();
            stream.remove();
        }
        stream.remove();
        CompositeListIteratorTests.assertEquals((String)"nothing removed from collection 1", (int)(this.buildList1().size() - 2), (int)list1.size());
        CompositeListIteratorTests.assertFalse((String)"element still in collection 1", (boolean)list1.contains("1"));
        CompositeListIteratorTests.assertFalse((String)"element still in collection 1", (boolean)list1.contains("333"));
        CompositeListIteratorTests.assertEquals((String)"nothing removed from collection 3", (int)(this.buildList3().size() - 1), (int)list3.size());
        CompositeListIteratorTests.assertFalse((String)"first element still in collection 3", (boolean)list3.contains(firstElement3));
        CompositeListIteratorTests.assertTrue((String)"wrong element removed from collection 3", (boolean)list3.contains("666666"));
    }

    public void testAdd() {
        List<String> list1 = this.buildList1();
        String lastElement1 = list1.get(list1.size() - 1);
        List<String> list2 = this.buildList2();
        List<String> list3 = this.buildList3();
        String firstElement3 = list3.get(0);
        ArrayList<ListIterator<String>> list = new ArrayList<ListIterator<String>>();
        list.add(list1.listIterator());
        list.add(list2.listIterator());
        list.add(list3.listIterator());
        ListIterator stream = (ListIterator)this.buildCompositeIterator(list.listIterator());
        while (stream.hasNext()) {
            Object next = stream.next();
            if (next.equals("333")) {
                stream.add("3.5");
            }
            if (!next.equals(lastElement1)) continue;
            stream.hasNext();
            stream.add("something in 3");
        }
        stream.add("finale");
        boolean checkForFinale = true;
        while (stream.hasPrevious()) {
            Object previous = stream.previous();
            if (checkForFinale) {
                checkForFinale = false;
                CompositeListIteratorTests.assertEquals((String)"added element dropped", (Object)"finale", previous);
            }
            if (previous.equals("333")) {
                stream.add("2.5");
            }
            if (!previous.equals(firstElement3)) continue;
            stream.hasPrevious();
            stream.add("old start of 3");
        }
        stream.add("prelude");
        CompositeListIteratorTests.assertEquals((String)"added element dropped", (String)"prelude", (String)((String)stream.previous()));
        CompositeListIteratorTests.assertEquals((String)"elements not added to collection 1", (int)(this.buildList1().size() + 3), (int)list1.size());
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 1", (String)"prelude", (String)list1.get(0));
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 1", (String)"2.5", (String)list1.get(3));
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 1", (String)"3.5", (String)list1.get(5));
        CompositeListIteratorTests.assertEquals((String)"elements not added to collection 3", (int)(this.buildList3().size() + 3), (int)list3.size());
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 3", (String)"something in 3", (String)list3.get(0));
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 3", (String)"old start of 3", (String)list3.get(1));
        CompositeListIteratorTests.assertEquals((String)"element not added to collection 3", (String)"finale", (String)list3.get(list3.size() - 1));
        stream = (ListIterator)this.buildCompositeIterator();
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.next()).equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.previous()).equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            stream.previous();
        }
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.next()).equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            stream.previous();
        }
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.previous()).equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        stream.next();
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.next()).equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        stream.next();
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.previous()).equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        stream.previous();
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.next()).equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        stream.previous();
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.previous()).equals("blah"));
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        stream.add("blah");
        CompositeListIteratorTests.assertFalse((String)"added element should be placed BEFORE the \"cursor\"", (boolean)stream.hasNext());
        stream = (ListIterator)this.buildCompositeIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        stream.add("blah");
        CompositeListIteratorTests.assertTrue((String)"added element should be placed BEFORE the \"cursor\"", (boolean)((String)stream.previous()).equals("blah"));
    }

    public void testSet() {
        List<String> list1 = this.buildList1();
        String lastElement1 = list1.get(list1.size() - 1);
        List<String> list2 = this.buildList2();
        List<String> list3 = this.buildList3();
        String firstElement3 = list3.get(0);
        ArrayList<ListIterator<String>> list = new ArrayList<ListIterator<String>>();
        list.add(list1.listIterator());
        list.add(list2.listIterator());
        list.add(list3.listIterator());
        ListIterator stream = (ListIterator)this.buildCompositeIterator(list.listIterator());
        while (stream.hasNext()) {
            Object next = stream.next();
            if (next.equals("333")) {
                stream.set("333a");
            }
            if (!next.equals(lastElement1)) continue;
            stream.hasNext();
            stream.set("end of 1");
        }
        while (stream.hasPrevious()) {
            Object previous = stream.previous();
            if (previous.equals("22")) {
                stream.set("22a");
            }
            if (!previous.equals(firstElement3)) continue;
            stream.hasPrevious();
            stream.set("start of 3");
        }
        CompositeListIteratorTests.assertEquals((String)"element(s) added to collection 1", (int)this.buildList1().size(), (int)list1.size());
        CompositeListIteratorTests.assertEquals((String)"element not set in collection 1", (String)"22a", (String)list1.get(1));
        CompositeListIteratorTests.assertFalse((String)"element not set in collection 1", (boolean)list1.contains("22"));
        CompositeListIteratorTests.assertEquals((String)"element not set in collection 1", (String)"333a", (String)list1.get(2));
        CompositeListIteratorTests.assertFalse((String)"element not set in collection 1", (boolean)list1.contains("333"));
        CompositeListIteratorTests.assertEquals((String)"element not set in collection 1", (String)"end of 1", (String)list1.get(list1.size() - 1));
        CompositeListIteratorTests.assertFalse((String)"element not set in collection 1", (boolean)list1.contains(lastElement1));
        CompositeListIteratorTests.assertEquals((String)"element(s) added to collection 3", (int)this.buildList3().size(), (int)list3.size());
        CompositeListIteratorTests.assertEquals((String)"element not set in collection 3", (String)"start of 3", (String)list3.get(0));
        CompositeListIteratorTests.assertFalse((String)"element not set in collection 3", (boolean)list3.contains(firstElement3));
    }

    @Override
    public void testNextIndexPreviousIndex() {
        int i = 0;
        ListIterator stream = (ListIterator)this.buildCompositeIterator();
        CompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
        CompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        while (stream.hasNext()) {
            Object next = stream.next();
            ++i;
            if (next.equals("333")) {
                stream.remove();
                --i;
            }
            if (next.equals("7777777")) {
                stream.add("7.5");
                ++i;
            }
            CompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
            CompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        }
        CompositeListIteratorTests.assertEquals((String)"index is corrupt", (int)8, (int)i);
        CompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
        CompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        while (stream.hasPrevious()) {
            Object previous = stream.previous();
            --i;
            if (previous.equals("666666")) {
                stream.remove();
            }
            if (previous.equals("22")) {
                stream.add("1.5");
                ++i;
            }
            CompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
            CompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        }
        CompositeListIteratorTests.assertEquals((String)"index is corrupt", (int)0, (int)i);
    }

    @Override
    public void testIllegalStateException() {
        this.verifyIllegalStateException();
    }

    @Override
    public void testEmptyIllegalStateException1() {
        this.verifyEmptyIllegalStateException1();
    }

    @Override
    public void testEmptyIllegalStateException2() {
        this.verifyEmptyIllegalStateException2();
    }

    @Override
    Iterator<String> buildCompositeIterator(Iterator iterators) {
        return new CompositeListIterator((ListIterator)iterators);
    }

    @Override
    Iterator<String> buildCompositeIterator2() {
        return IteratorTools.concatenate((ListIterator[])new ListIterator[]{this.buildIterator1(), this.buildIterator2(), this.buildIterator3()});
    }

    @Override
    Iterator<String> buildCompositeIterator3() {
        return IteratorTools.concatenate((ListIterator[])new ListIterator[]{this.buildIterator1(), this.buildIterator2(), this.buildIterator3()});
    }

    @Override
    ListIterator<String> buildCompositeListIterator(String string, ListIterator<String> iterator) {
        return IteratorTools.insert((Object)string, iterator);
    }
}

