/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelWrapper;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedListValueModelWrapperTests
extends TestCase {
    private List<String> list;
    private SimpleListValueModel<String> listModel;
    private SortedListValueModelWrapper<String> sortedListModel;

    public SortedListValueModelWrapperTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.list = new ArrayList<String>();
        this.listModel = new SimpleListValueModel(this.list);
        this.sortedListModel = new SortedListValueModelWrapper(this.listModel);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    private void verifyList(Collection<String> expected, ListValueModel<String> actual) {
        this.verifyList(expected, actual, null);
    }

    private void verifyList(Collection<String> expected, ListValueModel<String> actual, Comparator<String> comparator) {
        TreeSet<String> sortedSet = new TreeSet<String>(comparator);
        sortedSet.addAll(expected);
        ArrayList<String> expectedList = new ArrayList<String>(sortedSet);
        ArrayList actualList = ListTools.list(actual);
        SortedListValueModelWrapperTests.assertEquals(expectedList, (Object)actualList);
    }

    public void testAdd() {
        this.sortedListModel.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(this){

            public void itemsAdded(ListAddEvent e) {
            }

            public void itemsReplaced(ListReplaceEvent e) {
            }
        });
        this.listModel.add((Object)"foo");
        this.listModel.add((Object)"bar");
        this.listModel.add((Object)"baz");
        SortedListValueModelWrapperTests.assertEquals((int)3, (int)this.sortedListModel.size());
        this.verifyList((Collection<String>)this.list, (ListValueModel<String>)this.sortedListModel);
    }

    public void testAddItem() {
        CoordinatedList<String> sortedSynchList = new CoordinatedList<String>((ListValueModel<String>)this.sortedListModel);
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.listModel);
        this.listModel.add((Object)"foo");
        SortedListValueModelWrapperTests.assertTrue((boolean)this.list.contains("foo"));
        this.listModel.add((Object)"bar");
        this.listModel.add((Object)"baz");
        this.listModel.add((Object)"joo");
        this.listModel.add((Object)"jar");
        this.listModel.add((Object)"jaz");
        SortedListValueModelWrapperTests.assertEquals((int)6, (int)this.list.size());
        this.verifyList((Collection<String>)this.list, (ListValueModel<String>)this.sortedListModel);
        SortedListValueModelWrapperTests.assertEquals(this.list, synchList);
        SortedListValueModelWrapperTests.assertEquals((Object)ListTools.list(this.sortedListModel), sortedSynchList);
    }

    public void testRemoveItem() {
        CoordinatedList<String> sortedSynchList = new CoordinatedList<String>((ListValueModel<String>)this.sortedListModel);
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.listModel);
        this.listModel.add((Object)"foo");
        this.listModel.add((Object)"bar");
        this.listModel.add((Object)"baz");
        this.listModel.add((Object)"joo");
        this.listModel.add((Object)"jar");
        this.listModel.add((Object)"jaz");
        this.listModel.remove((Object)"jaz");
        SortedListValueModelWrapperTests.assertFalse((boolean)this.list.contains("jaz"));
        this.listModel.remove((Object)"foo");
        SortedListValueModelWrapperTests.assertFalse((boolean)this.list.contains("foo"));
        SortedListValueModelWrapperTests.assertEquals((int)4, (int)this.list.size());
        this.verifyList((Collection<String>)this.list, (ListValueModel<String>)this.sortedListModel);
        SortedListValueModelWrapperTests.assertEquals(this.list, synchList);
        SortedListValueModelWrapperTests.assertEquals((Object)ListTools.list(this.sortedListModel), sortedSynchList);
    }

    public void testReplaceItem() {
        CoordinatedList<String> sortedSynchList = new CoordinatedList<String>((ListValueModel<String>)this.sortedListModel);
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.listModel);
        this.listModel.add((Object)"foo");
        SortedListValueModelWrapperTests.assertTrue((boolean)this.list.contains("foo"));
        this.listModel.add((Object)"bar");
        this.listModel.add((Object)"baz");
        this.listModel.add((Object)"joo");
        this.listModel.add((Object)"jar");
        this.listModel.add((Object)"jaz");
        SortedListValueModelWrapperTests.assertEquals((int)6, (int)this.list.size());
        this.listModel.set(3, (Object)"ttt");
        this.listModel.set(4, (Object)"xxx");
        SortedListValueModelWrapperTests.assertTrue((boolean)this.list.contains("xxx"));
        this.verifyList((Collection<String>)this.list, (ListValueModel<String>)this.sortedListModel);
        SortedListValueModelWrapperTests.assertEquals(this.list, synchList);
        SortedListValueModelWrapperTests.assertEquals((Object)ListTools.list(this.sortedListModel), sortedSynchList);
    }

    public void testListSynch() {
        this.sortedListModel.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(this){

            public void itemsAdded(ListAddEvent e) {
            }

            public void itemsRemoved(ListRemoveEvent e) {
            }

            public void itemsReplaced(ListReplaceEvent e) {
            }
        });
        this.listModel.add((Object)"foo");
        this.listModel.add((Object)"bar");
        this.listModel.add((Object)"baz");
        this.listModel.add((Object)"joo");
        this.listModel.add((Object)"jar");
        this.listModel.add((Object)"jaz");
        this.listModel.remove((Object)"jaz");
        SortedListValueModelWrapperTests.assertFalse((boolean)this.list.contains("jaz"));
        this.listModel.remove((Object)"foo");
        SortedListValueModelWrapperTests.assertFalse((boolean)this.list.contains("foo"));
        SortedListValueModelWrapperTests.assertEquals((int)4, (int)this.list.size());
        this.verifyList((Collection<String>)this.list, (ListValueModel<String>)this.sortedListModel);
    }

    public void testSetComparator() {
        CoordinatedList<String> sortedSynchList = new CoordinatedList<String>((ListValueModel<String>)this.sortedListModel);
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.listModel);
        this.listModel.add((Object)"foo");
        SortedListValueModelWrapperTests.assertTrue((boolean)this.list.contains("foo"));
        this.listModel.add((Object)"bar");
        this.listModel.add((Object)"baz");
        this.listModel.add((Object)"joo");
        this.listModel.add((Object)"jar");
        this.listModel.add((Object)"jaz");
        SortedListValueModelWrapperTests.assertEquals((int)6, (int)this.list.size());
        this.verifyList((Collection<String>)this.list, (ListValueModel<String>)this.sortedListModel);
        SortedListValueModelWrapperTests.assertEquals(this.list, synchList);
        SortedListValueModelWrapperTests.assertEquals((Object)ListTools.list(this.sortedListModel), sortedSynchList);
        this.sortedListModel.setComparator(ComparatorTools.reverseComparator());
        this.verifyList((Collection<String>)this.list, (ListValueModel<String>)this.sortedListModel, ComparatorTools.reverseComparator());
        SortedListValueModelWrapperTests.assertEquals(this.list, synchList);
    }

    public void testHasListeners() {
        SortedListValueModelWrapperTests.assertFalse((boolean)this.sortedListModel.hasAnyListChangeListeners("list values"));
        CoordinatedList<String> sortedSynchList = new CoordinatedList<String>((ListValueModel<String>)this.sortedListModel);
        SortedListValueModelWrapperTests.assertTrue((boolean)this.sortedListModel.hasAnyListChangeListeners("list values"));
        this.sortedListModel.removeListChangeListener("list values", sortedSynchList);
        SortedListValueModelWrapperTests.assertFalse((boolean)this.sortedListModel.hasAnyListChangeListeners("list values"));
        ChangeAdapter cl = new ChangeAdapter();
        this.sortedListModel.addChangeListener((ChangeListener)cl);
        SortedListValueModelWrapperTests.assertTrue((boolean)this.sortedListModel.hasAnyListChangeListeners("list values"));
        this.sortedListModel.removeChangeListener((ChangeListener)cl);
        SortedListValueModelWrapperTests.assertFalse((boolean)this.sortedListModel.hasAnyListChangeListeners("list values"));
    }

    public void testListChange() {
        this.listModel.add((Object)"fred");
        this.sortedListModel.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(this){

            public void listChanged(ListChangeEvent e) {
            }
        });
        this.listModel.setListValues(Arrays.asList("foo", "bar", "baz"));
        SortedListValueModelWrapperTests.assertEquals((int)3, (int)this.sortedListModel.size());
        this.verifyList((Collection<String>)this.list, (ListValueModel<String>)this.sortedListModel);
    }

    class TestListChangeListener
    implements ListChangeListener {
        TestListChangeListener() {
        }

        public void itemsAdded(ListAddEvent e) {
            SortedListValueModelWrapperTests.fail((String)"unexpected event");
        }

        public void itemsRemoved(ListRemoveEvent e) {
            SortedListValueModelWrapperTests.fail((String)"unexpected event");
        }

        public void itemsReplaced(ListReplaceEvent e) {
            SortedListValueModelWrapperTests.fail((String)"unexpected event");
        }

        public void itemsMoved(ListMoveEvent e) {
            SortedListValueModelWrapperTests.fail((String)"unexpected event");
        }

        public void listCleared(ListClearEvent e) {
            SortedListValueModelWrapperTests.fail((String)"unexpected event");
        }

        public void listChanged(ListChangeEvent e) {
            SortedListValueModelWrapperTests.fail((String)"unexpected event");
        }
    }
}

