/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm;

import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbContextRoot;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlAccessOrder;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlAccessType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.OxmFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm.OxmContextModelTestCase;

public class OxmXmlBindingsTests
extends OxmContextModelTestCase {
    public OxmXmlBindingsTests(String name) {
        super(name);
    }

    protected void addOxmFile(String fileName, String packageName) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(CR);
        sb.append("<xml-bindings").append(CR);
        sb.append("    version=\"2.4\"").append(CR);
        sb.append("    xmlns=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm\"").append(CR);
        sb.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(CR);
        sb.append("    xsi:schemaLocation=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm http://www.eclipse.org/eclipselink/xsds/eclipselink_oxm_2_4.xsd\"").append(CR);
        sb.append("    package-name=\"").append(packageName).append("\"").append(CR);
        sb.append("    />").append(CR);
        this.addOxmFile(fileName, sb);
    }

    public void testUpdateAccessType() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)xmlBindings.getAccessType());
        eXmlBindings.setXmlAccessorType(EXmlAccessType.FIELD);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=\"FIELD\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessType.FIELD, (Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.FIELD, (Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.FIELD, (Object)xmlBindings.getAccessType());
        eXmlBindings.setXmlAccessorType(EXmlAccessType.NONE);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=\"NONE\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessType.NONE, (Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.NONE, (Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.NONE, (Object)xmlBindings.getAccessType());
        eXmlBindings.setXmlAccessorType(EXmlAccessType.PROPERTY);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=\"PROPERTY\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessType.PROPERTY, (Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)xmlBindings.getAccessType());
        eXmlBindings.setXmlAccessorType(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=", false);
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)xmlBindings.getAccessType());
    }

    public void testModifyAccessType() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)xmlBindings.getAccessType());
        xmlBindings.setSpecifiedAccessType(XmlAccessType.FIELD);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=\"FIELD\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessType.FIELD, (Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.FIELD, (Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.FIELD, (Object)xmlBindings.getAccessType());
        xmlBindings.setSpecifiedAccessType(XmlAccessType.NONE);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=\"NONE\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessType.NONE, (Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.NONE, (Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.NONE, (Object)xmlBindings.getAccessType());
        xmlBindings.setSpecifiedAccessType(XmlAccessType.PROPERTY);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=\"PROPERTY\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessType.PROPERTY, (Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)xmlBindings.getAccessType());
        xmlBindings.setSpecifiedAccessType(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=", false);
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlAccessorType());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedAccessType());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)xmlBindings.getAccessType());
    }

    public void testUpdateAccessOrder() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlAccessorOrder());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedAccessOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlBindings.getAccessOrder());
        eXmlBindings.setXmlAccessorOrder(EXmlAccessOrder.ALPHABETICAL);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order=\"ALPHABETICAL\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessOrder.ALPHABETICAL, (Object)eXmlBindings.getXmlAccessorOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)xmlBindings.getSpecifiedAccessOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)xmlBindings.getAccessOrder());
        eXmlBindings.setXmlAccessorOrder(EXmlAccessOrder.UNDEFINED);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order=\"UNDEFINED\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessOrder.UNDEFINED, (Object)eXmlBindings.getXmlAccessorOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlBindings.getSpecifiedAccessOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlBindings.getAccessOrder());
        eXmlBindings.setXmlAccessorOrder(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order=", false);
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlAccessorOrder());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedAccessOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlBindings.getAccessOrder());
    }

    public void testModifyAccessOrder() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlAccessorOrder());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedAccessOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlBindings.getAccessOrder());
        xmlBindings.setSpecifiedAccessOrder(XmlAccessOrder.ALPHABETICAL);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order=\"ALPHABETICAL\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessOrder.ALPHABETICAL, (Object)eXmlBindings.getXmlAccessorOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)xmlBindings.getSpecifiedAccessOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)xmlBindings.getAccessOrder());
        xmlBindings.setSpecifiedAccessOrder(XmlAccessOrder.UNDEFINED);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order=\"UNDEFINED\"", true);
        OxmXmlBindingsTests.assertEquals((Object)EXmlAccessOrder.UNDEFINED, (Object)eXmlBindings.getXmlAccessorOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlBindings.getSpecifiedAccessOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlBindings.getAccessOrder());
        xmlBindings.setSpecifiedAccessOrder(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order=", false);
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlAccessorOrder());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedAccessOrder());
        OxmXmlBindingsTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlBindings.getAccessOrder());
    }

    public void testUpdateXmlMappingMetadataComplete() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlMappingMetadataComplete());
        OxmXmlBindingsTests.assertFalse((boolean)xmlBindings.isXmlMappingMetadataComplete());
        eXmlBindings.setXmlMappingMetadataComplete(Boolean.TRUE);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-mapping-metadata-complete=\"true\"", true);
        OxmXmlBindingsTests.assertEquals((Object)Boolean.TRUE, (Object)eXmlBindings.getXmlMappingMetadataComplete());
        OxmXmlBindingsTests.assertTrue((boolean)xmlBindings.isXmlMappingMetadataComplete());
        eXmlBindings.setXmlMappingMetadataComplete(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-mapping-metadata-complete=", false);
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlMappingMetadataComplete());
        OxmXmlBindingsTests.assertFalse((boolean)xmlBindings.isXmlMappingMetadataComplete());
    }

    public void testModifyXmlMappingMetadataComplete() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlMappingMetadataComplete());
        OxmXmlBindingsTests.assertFalse((boolean)xmlBindings.isXmlMappingMetadataComplete());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-mapping-metadata-complete=\"true\"", true);
        OxmXmlBindingsTests.assertEquals((Object)Boolean.TRUE, (Object)eXmlBindings.getXmlMappingMetadataComplete());
        OxmXmlBindingsTests.assertTrue((boolean)xmlBindings.isXmlMappingMetadataComplete());
        xmlBindings.setXmlMappingMetadataComplete(false);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-mapping-metadata-complete=", false);
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getXmlMappingMetadataComplete());
        OxmXmlBindingsTests.assertFalse((boolean)xmlBindings.isXmlMappingMetadataComplete());
    }

    public void testUpdatePackageName() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertEquals((String)"test.oxm", (String)eXmlBindings.getPackageName());
        OxmXmlBindingsTests.assertEquals((String)"test.oxm", (String)xmlBindings.getSpecifiedPackageName());
        OxmXmlBindingsTests.assertEquals((String)"", (String)xmlBindings.getImpliedPackageName());
        OxmXmlBindingsTests.assertEquals((String)"test.oxm", (String)xmlBindings.getPackageName());
        eXmlBindings.setPackageName("foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "package-name=\"foo\"", true);
        OxmXmlBindingsTests.assertEquals((String)"foo", (String)eXmlBindings.getPackageName());
        OxmXmlBindingsTests.assertEquals((String)"foo", (String)xmlBindings.getSpecifiedPackageName());
        OxmXmlBindingsTests.assertEquals((String)"", (String)xmlBindings.getImpliedPackageName());
        OxmXmlBindingsTests.assertEquals((String)"foo", (String)xmlBindings.getPackageName());
        eXmlBindings.setPackageName(null);
        EJavaType eJavaType = OxmFactory.eINSTANCE.createEJavaType();
        eJavaType.setName("test.foo.Foo");
        eXmlBindings.getJavaTypes().add((Object)eJavaType);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "package-name=", false);
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getPackageName());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedPackageName());
        OxmXmlBindingsTests.assertEquals((String)"test.foo", (String)xmlBindings.getImpliedPackageName());
        OxmXmlBindingsTests.assertEquals((String)"test.foo", (String)xmlBindings.getPackageName());
    }

    public void testModifyPackageName() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertEquals((String)"test.oxm", (String)eXmlBindings.getPackageName());
        OxmXmlBindingsTests.assertEquals((String)"test.oxm", (String)xmlBindings.getSpecifiedPackageName());
        xmlBindings.setSpecifiedPackageName("foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "package-name=\"foo\"", true);
        OxmXmlBindingsTests.assertEquals((String)"foo", (String)eXmlBindings.getPackageName());
        OxmXmlBindingsTests.assertEquals((String)"foo", (String)xmlBindings.getSpecifiedPackageName());
        xmlBindings.setSpecifiedPackageName(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "package-name=", false);
        OxmXmlBindingsTests.assertNull((Object)eXmlBindings.getPackageName());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getSpecifiedPackageName());
    }

    public void testUpdateXmlEnums() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)0, (int)xmlBindings.getXmlEnumsSize());
        EXmlEnum eXmlEnum = OxmFactory.eINSTANCE.createEXmlEnum();
        eXmlEnum.setJavaEnum("test.oxm.Foo");
        eXmlBindings.getXmlEnums().add((Object)eXmlEnum);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-enums", true);
        this.assertFileContentsContains("oxm.xml", "test.oxm.Foo", true);
        OxmXmlBindingsTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)1, (int)xmlBindings.getXmlEnumsSize());
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getXmlEnum("test.oxm.Foo"));
        eXmlEnum = OxmFactory.eINSTANCE.createEXmlEnum();
        eXmlEnum.setJavaEnum("test.oxm.Bar");
        eXmlBindings.getXmlEnums().add((Object)eXmlEnum);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "test.oxm.Bar", true);
        OxmXmlBindingsTests.assertEquals((int)2, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)2, (int)xmlBindings.getXmlEnumsSize());
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getXmlEnum("test.oxm.Bar"));
        eXmlBindings.getXmlEnums().remove(0);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "test.oxm.Foo", false);
        this.assertFileContentsContains("oxm.xml", "test.oxm.Bar", true);
        OxmXmlBindingsTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)1, (int)xmlBindings.getXmlEnumsSize());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getXmlEnum("test.oxm.Foo"));
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getXmlEnum("test.oxm.Bar"));
        eXmlBindings.getXmlEnums().remove(0);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-types", false);
        OxmXmlBindingsTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)0, (int)xmlBindings.getXmlEnumsSize());
    }

    public void testModifyXmlEnums() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)0, (int)xmlBindings.getXmlEnumsSize());
        OxmXmlEnum xmlEnum = xmlBindings.addXmlEnum(0);
        xmlEnum.setSpecifiedJavaEnum("test.oxm.Foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-enums", true);
        this.assertFileContentsContains("oxm.xml", "test.oxm.Foo", true);
        OxmXmlBindingsTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)1, (int)xmlBindings.getXmlEnumsSize());
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getXmlEnum("test.oxm.Foo"));
        xmlEnum = xmlBindings.addXmlEnum(0);
        xmlEnum.setSpecifiedJavaEnum("test.oxm.Bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "test.oxm.Bar", true);
        OxmXmlBindingsTests.assertEquals((int)2, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)2, (int)xmlBindings.getXmlEnumsSize());
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getXmlEnum("test.oxm.Bar"));
        xmlBindings.removeXmlEnum(1);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "test.oxm.Foo", false);
        this.assertFileContentsContains("oxm.xml", "test.oxm.Bar", true);
        OxmXmlBindingsTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)1, (int)xmlBindings.getXmlEnumsSize());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getXmlEnum("test.oxm.Foo"));
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getXmlEnum("test.oxm.Bar"));
        xmlBindings.removeXmlEnum(0);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-enums", false);
        OxmXmlBindingsTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlBindings.getXmlEnums()));
        OxmXmlBindingsTests.assertEquals((int)0, (int)xmlBindings.getXmlEnumsSize());
    }

    public void testUpdateJavaTypes() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)0, (int)xmlBindings.getJavaTypesSize());
        EJavaType eJavaType = OxmFactory.eINSTANCE.createEJavaType();
        eJavaType.setName("test.oxm.Foo");
        eXmlBindings.getJavaTypes().add((Object)eJavaType);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-types", true);
        this.assertFileContentsContains("oxm.xml", "test.oxm.Foo", true);
        OxmXmlBindingsTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)1, (int)xmlBindings.getJavaTypesSize());
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getJavaType("test.oxm.Foo"));
        eJavaType = OxmFactory.eINSTANCE.createEJavaType();
        eJavaType.setName("test.oxm.Bar");
        eXmlBindings.getJavaTypes().add((Object)eJavaType);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "test.oxm.Bar", true);
        OxmXmlBindingsTests.assertEquals((int)2, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)2, (int)xmlBindings.getJavaTypesSize());
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getJavaType("test.oxm.Bar"));
        eXmlBindings.getJavaTypes().remove(0);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "test.oxm.Foo", false);
        this.assertFileContentsContains("oxm.xml", "test.oxm.Bar", true);
        OxmXmlBindingsTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)1, (int)xmlBindings.getJavaTypesSize());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getJavaType("test.oxm.Foo"));
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getJavaType("test.oxm.Bar"));
        eXmlBindings.getJavaTypes().remove(0);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-types", false);
        OxmXmlBindingsTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)0, (int)xmlBindings.getJavaTypesSize());
    }

    public void testModifyJavaTypes() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlBindingsTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)0, (int)xmlBindings.getJavaTypesSize());
        OxmJavaType javaType = xmlBindings.addJavaType(0);
        javaType.setSpecifiedName("test.oxm.Foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-types", true);
        this.assertFileContentsContains("oxm.xml", "test.oxm.Foo", true);
        OxmXmlBindingsTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)1, (int)xmlBindings.getJavaTypesSize());
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getJavaType("test.oxm.Foo"));
        javaType = xmlBindings.addJavaType(0);
        javaType.setSpecifiedName("test.oxm.Bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "test.oxm.Bar", true);
        OxmXmlBindingsTests.assertEquals((int)2, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)2, (int)xmlBindings.getJavaTypesSize());
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getJavaType("test.oxm.Bar"));
        xmlBindings.removeJavaType(1);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "test.oxm.Foo", false);
        this.assertFileContentsContains("oxm.xml", "test.oxm.Bar", true);
        OxmXmlBindingsTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)1, (int)xmlBindings.getJavaTypesSize());
        OxmXmlBindingsTests.assertNull((Object)xmlBindings.getJavaType("test.oxm.Foo"));
        OxmXmlBindingsTests.assertNotNull((Object)xmlBindings.getJavaType("test.oxm.Bar"));
        xmlBindings.removeJavaType(0);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-types", false);
        OxmXmlBindingsTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlBindings.getJavaTypes()));
        OxmXmlBindingsTests.assertEquals((int)0, (int)xmlBindings.getJavaTypesSize());
    }
}

