/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests;

import java.util.Dictionary;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleActivatorTest
extends TestCase {
    private final Class<?> clazz;
    private final Bundle bundle;
    private static final TransformerAdapter<String, String> PACKAGE_NAME_EXTRACTOR = new PackageNameExtractor();

    public BundleActivatorTest(Class<?> clazz) {
        super(BundleActivatorTest.buildName(clazz));
        this.bundle = BundleActivatorTest.buildBundle(clazz);
        this.clazz = clazz;
    }

    private static String buildName(Class<?> clazz) {
        Bundle bundle = BundleActivatorTest.buildBundle(clazz);
        return String.valueOf(BundleActivatorTest.class.getSimpleName()) + ": " + bundle.getSymbolicName();
    }

    private static Bundle buildBundle(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader instanceof BundleReference ? ((BundleReference)classLoader).getBundle() : null;
    }

    protected void runTest() throws Throwable {
        if (this.bundle == null) {
            BundleActivatorTest.fail((String)("non-bundle class: " + this.clazz));
        }
        Dictionary headers = this.bundle.getHeaders();
        String exportPackageHeader = (String)headers.get("Export-Package");
        Object[] exportPackageEntries = exportPackageHeader.split(",");
        Object[] exportPackages = (String[])ArrayTools.transform((Object[])exportPackageEntries, PACKAGE_NAME_EXTRACTOR, String.class);
        BundleContext bundleContext = this.bundle.getBundleContext();
        BundleActivator activator = (BundleActivator)ObjectTools.get((Object)bundleContext, (String)"activator");
        String activatorClassName = activator.getClass().getName();
        Class<?> activatorClass = activator.getClass().getClassLoader().loadClass(activatorClassName);
        String activatorPackage = activatorClass.getPackage().getName();
        if (ArrayTools.contains((Object[])exportPackages, (Object)activatorPackage)) {
            BundleActivatorTest.fail((String)("Bundle activator class is exported: " + activatorClassName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PackageNameExtractor
    extends TransformerAdapter<String, String> {
        PackageNameExtractor() {
        }

        public String transform(String exportPackageEntry) {
            return exportPackageEntry.split(";")[0];
        }
    }
}

