/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context;

import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.operations.PersistenceFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.Generic2_1ContextModelTestCase;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class JpaProject2_1Tests
extends Generic2_1ContextModelTestCase {
    public JpaProject2_1Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType("MyEntity", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType("MyMappedSuperclass", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }
        });
    }

    private ICompilationUnit createTestEmbeddable() throws Exception {
        return this.createTestType("MyEmbeddable", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable");
            }
        });
    }

    private ICompilationUnit createTestConverter() throws Exception {
        return this.createTestType("MyConverter", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Converter");
            }
        });
    }

    public void testGetPersistenceXmlResource() throws Exception {
        JptXmlResource resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProject2_1Tests.assertNotNull((Object)resource);
        JpaProject2_1Tests.assertEquals((Object)XmlPersistence.CONTENT_TYPE, (Object)resource.getContentType());
        JpaProject2_1Tests.assertEquals((String)"src/META-INF/persistence.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProject2_1Tests.assertNull((Object)resource);
        this.createPersistenceXmlFile();
        resource = this.getJpaProject().getPersistenceXmlResource();
        JpaProject2_1Tests.assertNotNull((Object)resource);
        JpaProject2_1Tests.assertEquals((Object)XmlPersistence.CONTENT_TYPE, (Object)resource.getContentType());
        JpaProject2_1Tests.assertEquals((String)"src/META-INF/persistence.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    private void createPersistenceXmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new PersistenceFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.getDefaultOperation().execute(null, null);
    }

    public void testGetDefaultOrmXmlResource() throws Exception {
        JptXmlResource resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProject2_1Tests.assertNotNull((Object)resource);
        JpaProject2_1Tests.assertEquals((Object)XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        JpaProject2_1Tests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProject2_1Tests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        JpaProject2_1Tests.assertNotNull((Object)resource);
        JpaProject2_1Tests.assertEquals((Object)XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        JpaProject2_1Tests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    private void createDefaultOrmXmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.getDefaultOperation().execute(null, null);
    }

    private void createOrmXmlFile(String fileName) throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)fileName);
        config.getDefaultOperation().execute(null, null);
    }

    public void testGetMappingFileResource() throws Exception {
        JptXmlResource resource = this.getJpaProject().getMappingFileXmlResource(XmlEntityMappings.DEFAULT_RUNTIME_PATH);
        JpaProject2_1Tests.assertNotNull((Object)resource);
        JpaProject2_1Tests.assertEquals((Object)XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        JpaProject2_1Tests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource(XmlEntityMappings.DEFAULT_RUNTIME_PATH);
        JpaProject2_1Tests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getMappingFileXmlResource(XmlEntityMappings.DEFAULT_RUNTIME_PATH);
        JpaProject2_1Tests.assertNotNull((Object)resource);
        JpaProject2_1Tests.assertEquals((Object)XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        JpaProject2_1Tests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetMappingFileResourceDifferentlyName() throws Exception {
        JptXmlResource resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        JpaProject2_1Tests.assertNull((Object)resource);
        this.createOrmXmlFile("orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        JpaProject2_1Tests.assertNotNull((Object)resource);
        JpaProject2_1Tests.assertEquals((Object)XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        JpaProject2_1Tests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        JpaProject2_1Tests.assertNull((Object)resource);
        this.createOrmXmlFile("orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        JpaProject2_1Tests.assertNotNull((Object)resource);
        JpaProject2_1Tests.assertEquals((Object)XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        JpaProject2_1Tests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetPotentialJavaSourceTypes() throws Exception {
        this.createTestEntity();
        this.createTestEmbeddable();
        this.createTestMappedSuperclass();
        this.createTestConverter();
        this.createTestType();
        Iterable potentialJavaSourceTypes = this.getJpaProject().getPotentialJavaSourceTypes();
        JpaProject2_1Tests.assertEquals((int)4, (int)IterableTools.size((Iterable)potentialJavaSourceTypes));
        JpaProject2_1Tests.assertTrue((boolean)IterableTools.contains((Iterable)potentialJavaSourceTypes, (Object)this.getJpaProject().getJavaResourceType("test.MyEntity")));
        JpaProject2_1Tests.assertTrue((boolean)IterableTools.contains((Iterable)potentialJavaSourceTypes, (Object)this.getJpaProject().getJavaResourceType("test.MyEmbeddable")));
        JpaProject2_1Tests.assertTrue((boolean)IterableTools.contains((Iterable)potentialJavaSourceTypes, (Object)this.getJpaProject().getJavaResourceType("test.MyMappedSuperclass")));
        JpaProject2_1Tests.assertTrue((boolean)IterableTools.contains((Iterable)potentialJavaSourceTypes, (Object)this.getJpaProject().getJavaResourceType("test.MyConverter")));
    }
}

