/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.internal.driver.AbstractDTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.CatalogStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapterFactory;
import org.eclipse.jpt.jpa.db.internal.driver.FoldingStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.NonFoldingStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.SimpleCatalogStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Sybase
extends AbstractDTPDriverAdapter {
    private static final String MASTER_CATALOG_NAME = "master";
    private static final String DEFAULT_SCHEMA_NAME = "dbo";
    private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[]{'_', '@'};
    private static final char[] EXTENDED_REGULAR_NAME_PART_CHARACTERS = new char[]{'$', '\u00a5', '\u00a3', '#'};

    Sybase(Database database) {
        super(database);
    }

    @Override
    CatalogStrategy buildCatalogStrategy() {
        return new SimpleCatalogStrategy(this.database.getDTPDatabase());
    }

    @Override
    FoldingStrategy buildFoldingStrategy() {
        return NonFoldingStrategy.instance();
    }

    @Override
    boolean regularNamesMatch(String name1, String name2) {
        return name1.equals(name2);
    }

    @Override
    void addDefaultCatalogNamesTo(ArrayList<String> names) {
        names.add(this.database.getName());
        names.add(MASTER_CATALOG_NAME);
    }

    @Override
    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        names.add(DEFAULT_SCHEMA_NAME);
    }

    @Override
    char[] getExtendedRegularNameStartCharacters() {
        return EXTENDED_REGULAR_NAME_START_CHARACTERS;
    }

    @Override
    char[] getExtendedRegularNamePartCharacters() {
        return EXTENDED_REGULAR_NAME_PART_CHARACTERS;
    }

    @Override
    String delimitName(String name) {
        return String.valueOf('[') + name + ']';
    }

    @Override
    boolean identifierIsDelimited(String identifier) {
        return StringTools.isBracketed((String)identifier) || super.identifierIsDelimited(identifier);
    }

    static class Factory
    implements DTPDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"Sybase_ASA", "Sybase_ASE"};

        Factory() {
        }

        public String[] getSupportedVendors() {
            return VENDORS;
        }

        public DTPDriverAdapter buildAdapter(Database database) {
            return new Sybase(database);
        }
    }
}

