/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.command;

import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class DeleteAttributeCommand
implements Command {
    private PersistentType jpt;
    private String attributeName;
    private IJPAEditorFeatureProvider fp;

    public DeleteAttributeCommand(PersistentType jpt, String attributeName, IJPAEditorFeatureProvider fp) {
        this.jpt = jpt;
        this.attributeName = attributeName;
        this.fp = fp;
    }

    public void execute() {
        JpaArtifactFactory.instance().removeOrmPersistentAttribute(this.jpt, this.attributeName);
        try {
            IJavaProject jp = JavaCore.create((IProject)this.jpt.getJpaProject().getProject());
            IType javaType = jp.findType(this.jpt.getName());
            String attrNameWithCapitalLetter = String.valueOf(this.attributeName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + this.attributeName.substring(1);
            IMethod getAttributeMethod = this.findGetterMethod(javaType, attrNameWithCapitalLetter);
            String typeSignature = this.getReturnedType(getAttributeMethod);
            this.deleteGetterMethod(typeSignature, getAttributeMethod);
            this.deleteField(javaType);
            this.deleteSetterMethod(javaType, attrNameWithCapitalLetter, typeSignature);
            IWorkbenchPartSite ws = ((IDiagramContainerUI)this.fp.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getSite();
            JPAEditorUtil.organizeImports(javaType.getCompilationUnit(), (IWorkbenchSite)ws);
            this.jpt.getJavaResourceType().getJavaResourceCompilationUnit().synchronizeWithJavaSource();
            this.jpt.synchronizeWithResourceModel();
            this.jpt.update();
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannnot delete attribute with name " + this.attributeName, e);
        }
    }

    private String getReturnedType(IMethod getAttributeMethod) throws JavaModelException {
        String typeSignature = null;
        if (getAttributeMethod != null && getAttributeMethod.exists()) {
            typeSignature = getAttributeMethod.getReturnType();
        }
        return typeSignature;
    }

    private IMethod findGetterMethod(IType javaType, String attrNameWithCapitalLetter) {
        String getterPrefix = "get";
        String methodName = String.valueOf(getterPrefix) + attrNameWithCapitalLetter;
        IMethod getAttributeMethod = javaType.getMethod(methodName, new String[0]);
        if (!getAttributeMethod.exists()) {
            getterPrefix = "is";
        }
        methodName = String.valueOf(getterPrefix) + attrNameWithCapitalLetter;
        getAttributeMethod = javaType.getMethod(methodName, new String[0]);
        return getAttributeMethod;
    }

    private void deleteSetterMethod(IType javaType, String attrNameWithCapitalLetter, String typeSignature) throws JavaModelException {
        IMethod setAttributeMethod;
        String methodName = "set" + attrNameWithCapitalLetter;
        if (typeSignature != null && (setAttributeMethod = javaType.getMethod(methodName, new String[]{typeSignature})) != null && setAttributeMethod.exists()) {
            setAttributeMethod.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void deleteGetterMethod(String typeSignature, IMethod getAttributeMethod) throws JavaModelException {
        if (getAttributeMethod != null && getAttributeMethod.exists()) {
            getAttributeMethod.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void deleteField(IType javaType) throws JavaModelException {
        IField attributeField = javaType.getField(this.attributeName);
        if (attributeField != null) {
            if (!attributeField.exists()) {
                attributeField = javaType.getField(JPAEditorUtil.revertFirstLetterCase(this.attributeName));
            }
            attributeField.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

