/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.w3c.dom.Element;

public class W11UpdateImportCommand
extends W11TopLevelElementCommand {
    private Import theImport;
    private String prefix;
    private String locationURI;
    private String namespaceURI;

    public W11UpdateImportCommand(Import theImport, String locationURI, String namespaceURI, String prefix) {
        super(Messages._UI_ACTION_UPDATE_IMPORT, theImport.getEnclosingDefinition());
        this.theImport = theImport;
        this.namespaceURI = namespaceURI;
        this.prefix = prefix;
        this.locationURI = locationURI;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        super.execute();
        Element definitionElement = this.definition.getElement();
        try {
            String existingPrefix;
            this.beginRecording(definitionElement);
            this.theImport.setLocationURI(this.locationURI);
            Definition definition = this.theImport.getEnclosingDefinition();
            if (definition != null && (existingPrefix = definition.getPrefix(this.namespaceURI)) == null) {
                String uniquePrefix = this.getImportPrefix();
                definitionElement.setAttribute("xmlns:" + uniquePrefix, this.namespaceURI);
            }
            this.theImport.setNamespaceURI(this.namespaceURI);
            ((ImportImpl)this.theImport).importDefinitionOrSchema();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.endRecording(definitionElement);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.endRecording(definitionElement);
    }

    private String getImportPrefix() {
        String uniquePrefix;
        if (this.prefix != null && this.prefix.trim().equals("")) {
            URI uri = URI.createPlatformResourceURI((String)this.locationURI, (boolean)false);
            uniquePrefix = this.getUniquePrefix(this.definition, uri.fileExtension());
        } else {
            uniquePrefix = this.prefix;
        }
        return uniquePrefix;
    }

    private String getUniquePrefix(Definition definition, String initPrefix) {
        String uniquePrefix;
        Map map = definition.getNamespaces();
        if (definition.getNamespace(initPrefix) == null) {
            uniquePrefix = initPrefix;
        } else {
            String tempPrefix = initPrefix;
            int i = 1;
            while (map.containsKey(String.valueOf(tempPrefix) + i)) {
                ++i;
            }
            uniquePrefix = String.valueOf(tempPrefix) + i;
        }
        return uniquePrefix;
    }
}

