/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.TreeSet;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.tests.internal.TestCommand;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestTools {
    private static final Class<TestCase> TestCase_class = TestCase.class;

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void execute(TestCommand command) {
        TestTools.execute(command, -1);
    }

    public static void execute(TestCommand command, int attempts) {
        TestTools.execute(command, attempts, 1000L);
    }

    public static void execute(TestCommand command, int attempts, long delay) {
        int i = 1;
        while (i <= attempts) {
            try {
                command.execute();
                return;
            }
            catch (Exception ex) {
                if (attempts != -1 && i == attempts) {
                    throw new RuntimeException("attempts: " + i, ex);
                }
                TestTools.sleep(delay);
                ++i;
            }
        }
    }

    public static void assertEquals(String expected, char[] actual) {
        Assert.assertEquals((Object)expected, (Object)(actual == null ? null : new String(actual)));
    }

    public static void assertEquals(String expected, byte[] actual) {
        Assert.assertEquals((Object)expected, (Object)(actual == null ? null : new String(actual)));
    }

    public static void assertEquals(CharSequence expected, char[] actual) {
        TestTools.assertEquals(expected.toString(), actual);
    }

    public static void assertEquals(CharSequence expected, byte[] actual) {
        TestTools.assertEquals(expected.toString(), actual);
    }

    public static <T> T serialize(T o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baOutStream = new ByteArrayOutputStream(2000);
        ObjectOutputStream outStream = new ObjectOutputStream(baOutStream);
        outStream.writeObject(o);
        outStream.close();
        ByteArrayInputStream baInStream = new ByteArrayInputStream(baOutStream.toByteArray());
        ObjectInputStream inStream = new ObjectInputStream(baInStream);
        T o2 = TestTools.readObject(inStream);
        inStream.close();
        return o2;
    }

    private static <T> T readObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        return (T)objectInput.readObject();
    }

    public static void redirectSystemStreamsTo(OutputStream outputStream) {
        TestTools.redirectSystemStreamsTo(new PrintStream(outputStream));
    }

    public static void redirectSystemStreamsTo(PrintStream printStream) {
        System.setOut(printStream);
        System.setErr(printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printSystemProperties() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            TestTools.printSystemPropertiesOn(System.out);
        }
    }

    public static void printSystemPropertiesOn(PrintStream stream) {
        TreeSet<String> sortedKeys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Object object : System.getProperties().keySet()) {
            sortedKeys.add((String)object);
        }
        for (String string : sortedKeys) {
            stream.print(string);
            stream.print(" => ");
            stream.print(System.getProperty(string));
            stream.println();
        }
    }

    public static String execute(TestCase testCase) {
        long start = System.currentTimeMillis();
        TestResult result = testCase.run();
        long end = System.currentTimeMillis();
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.print(testCase.getName());
        writer.print(": ");
        if (result.wasSuccessful()) {
            writer.println("OK");
        } else {
            TestFailure failure = null;
            failure = result.failures().hasMoreElements() ? (TestFailure)result.failures().nextElement() : (TestFailure)result.errors().nextElement();
            failure.thrownException().printStackTrace(writer);
        }
        writer.print("elapsed time: ");
        long elapsed = end - start;
        writer.print(elapsed / 1000L);
        writer.println(" sec.");
        return stringWriter.toString();
    }

    public static void clear(TestCase testCase) throws IllegalAccessException {
        Class<?> clazz = testCase.getClass();
        while (clazz != TestCase_class) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!field.getType().isPrimitive() && !Modifier.isStatic(field.getModifiers())) {
                    field.setAccessible(true);
                    field.set(testCase, null);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static boolean debug(Class<?> clazz) {
        Boolean debug = (Boolean)ClassTools.get(clazz, (String)"DEBUG");
        return debug;
    }

    public static void assertFalseDEBUG(Class<?> clazz) {
        Assert.assertFalse((String)("Recompile with \"DEBUG = false\": " + clazz.getName()), (boolean)TestTools.debug(clazz));
    }

    public static void setUpJUnitThreadContextClassLoader() {
        Thread.currentThread().setContextClassLoader(TestTools.class.getClassLoader());
    }

    private TestTools() {
        throw new UnsupportedOperationException();
    }
}

