/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.enumeration;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.enumeration.EnumerationTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationToolsTests
extends TestCase {
    public EnumerationToolsTests(String name) {
        super(name);
    }

    public void testContainsEnumerationObject_String() {
        Vector<String> v = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.contains(v.elements(), (Object)"one"));
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.contains(v.elements(), null));
        v.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.contains(v.elements(), null));
    }

    public void testContainsEnumerationObject_Object() {
        Vector<String> c = new Vector<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.contains(c.elements(), (Object)one));
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.contains(c.elements(), null));
        c.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.contains(c.elements(), null));
    }

    public void testContainsAllEnumerationCollection() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), v1));
        Vector<String> v2 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), v2));
        v2.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.containsAll(v1.elements(), v2));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), v2));
    }

    public void testContainsAllEnumerationIntCollection() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), v1));
        Vector<String> v2 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), v2));
        v2.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), v2));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), v2));
    }

    public void testContainsAllEnumerationIterable() {
        Vector<String> v2;
        Vector<String> v1;
        Vector<String> stream1 = v1 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), stream1));
        Vector<String> stream2 = v2 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), stream2));
        v2.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.containsAll(v1.elements(), stream2));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), stream2));
    }

    public void testContainsAllEnumerationIntIterable() {
        Vector<String> v2;
        Vector<String> v1;
        Vector<String> stream1 = v1 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), stream1));
        Vector<String> stream2 = v2 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), stream2));
        v2.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), stream2));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), stream2));
    }

    public void testContainsAllEnumerationEnumeration() {
        Vector<String> v1 = this.buildStringVector1();
        Enumeration<String> stream1 = v1.elements();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), stream1));
        Vector<String> v2 = this.buildStringVector1();
        Enumeration<String> stream2 = v2.elements();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), stream2));
        v2.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.containsAll(v1.elements(), stream2));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), stream2));
    }

    public void testContainsAllEnumerationIntEnumeration() {
        Vector<String> v1 = this.buildStringVector1();
        Enumeration<String> stream1 = v1.elements();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), stream1));
        Vector<String> v2 = this.buildStringVector1();
        Enumeration<String> stream2 = v2.elements();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), stream2));
        v2.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), stream2));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), stream2));
    }

    public void testContainsAllEnumerationArray() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), v1));
        Object[] v2 = this.buildStringVector1().toArray(StringTools.EMPTY_STRING_ARRAY);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (Object[])v2));
        v2 = (String[])ArrayTools.add((Object[])v2, null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.containsAll(v1.elements(), (Object[])v2));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (Object[])v2));
    }

    public void testContainsAllEnumerationIntArray() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), v1));
        Object[] v2 = this.buildStringVector1().toArray(StringTools.EMPTY_STRING_ARRAY);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), (Object[])v2));
        v2 = (String[])ArrayTools.add((Object[])v2, null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), (Object[])v2));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.containsAll(v1.elements(), (int)v1.size(), (Object[])v2));
    }

    public void testElementsAreDifferentEnumerationEnumeration() {
        Vector<String> v1 = this.buildStringVector1();
        Vector<String> v2 = this.buildStringVector1();
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreDifferent(v1.elements(), v2.elements()));
        v2.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreDifferent(v1.elements(), v2.elements()));
        v1.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreDifferent(v1.elements(), v2.elements()));
    }

    public void testElementsAreEqualEnumerationEnumeration() {
        Vector<String> v1 = this.buildStringVector1();
        Vector<String> v2 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreEqual(v1.elements(), v2.elements()));
        v2.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreEqual(v1.elements(), v2.elements()));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreEqual(v1.elements(), v2.elements()));
        v2.setElementAt("foo", 1);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreEqual(v1.elements(), v2.elements()));
        v1.setElementAt("foo", 1);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreEqual(v1.elements(), v2.elements()));
    }

    public void testElementsAreIdenticalEnumerationEnumeration() {
        Vector<String> v1 = this.buildStringVector1();
        Vector<String> v2 = new Vector<String>(v1);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreIdentical(v1.elements(), v2.elements()));
        v2.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreIdentical(v1.elements(), v2.elements()));
        v1.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreIdentical(v1.elements(), v2.elements()));
        String foo = "foo";
        v2.setElementAt(foo, 1);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreIdentical(v1.elements(), v2.elements()));
        v1.setElementAt(foo, 1);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreIdentical(v1.elements(), v2.elements()));
    }

    public void testElementsAreNotIdenticalEnumerationEnumeration() {
        Vector<String> v1 = this.buildStringVector1();
        Vector<String> v2 = new Vector<String>(v1);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreNotIdentical(v1.elements(), v2.elements()));
        v2.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreNotIdentical(v1.elements(), v2.elements()));
        v1.add(null);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreNotIdentical(v1.elements(), v2.elements()));
        String foo = "foo";
        v2.setElementAt(foo, 1);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreNotIdentical(v1.elements(), v2.elements()));
        v1.setElementAt(foo, 1);
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.elementsAreNotIdentical(v1.elements(), v2.elements()));
    }

    public void testEmptyEnumeration() {
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.emptyEnumeration().hasMoreElements());
    }

    public void testEnumerationIterator() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreIdentical(v1.elements(), (Enumeration)EnumerationTools.enumeration(v1.iterator())));
    }

    public void testGetEnumerationInt() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertEquals((String)"zero", (String)((String)EnumerationTools.get(v1.elements(), (int)0)));
        EnumerationToolsTests.assertEquals((String)"one", (String)((String)EnumerationTools.get(v1.elements(), (int)1)));
        EnumerationToolsTests.assertEquals((String)"two", (String)((String)EnumerationTools.get(v1.elements(), (int)2)));
    }

    public void testGetEnumerationInt_Exception() {
        Vector<String> v1 = this.buildStringVector1();
        boolean exCaught = false;
        try {
            Object at = EnumerationTools.get(v1.elements(), (int)55);
            EnumerationToolsTests.fail((String)("bogus: " + at));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        EnumerationToolsTests.assertTrue((boolean)exCaught);
    }

    public void testHashCodeEnumeration() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertEquals((int)v1.hashCode(), (int)EnumerationTools.hashCode(v1.elements()));
    }

    public void testIndexOfEnumerationObject() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertEquals((int)1, (int)EnumerationTools.indexOf(v1.elements(), (Object)"one"));
    }

    public void testIndexOfEnumerationObjectInt() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertEquals((int)1, (int)EnumerationTools.indexOf(v1.elements(), (Object)"one", (int)-1));
        EnumerationToolsTests.assertEquals((int)1, (int)EnumerationTools.indexOf(v1.elements(), (Object)"one", (int)1));
        EnumerationToolsTests.assertEquals((int)2, (int)EnumerationTools.indexOf(v1.elements(), (Object)"two", (int)1));
        EnumerationToolsTests.assertEquals((int)-1, (int)EnumerationTools.indexOf(v1.elements(), (Object)"one", (int)2));
        EnumerationToolsTests.assertEquals((int)-1, (int)EnumerationTools.indexOf(v1.elements(), (Object)"one", (int)22));
    }

    public void testIndexOfEnumerationObject_Null() {
        Vector<String> v1 = this.buildStringVector1();
        v1.add(null);
        EnumerationToolsTests.assertEquals((int)(v1.size() - 1), (int)EnumerationTools.indexOf(v1.elements(), null));
    }

    public void testIndexOfEnumerationObjectInt_Null() {
        Vector<String> v1 = this.buildStringVector1();
        v1.add(null);
        EnumerationToolsTests.assertEquals((int)(v1.size() - 1), (int)EnumerationTools.indexOf(v1.elements(), null, (int)-1));
        EnumerationToolsTests.assertEquals((int)(v1.size() - 1), (int)EnumerationTools.indexOf(v1.elements(), null, (int)2));
        EnumerationToolsTests.assertEquals((int)(v1.size() - 1), (int)EnumerationTools.indexOf(v1.elements(), null, (int)(v1.size() - 1)));
        EnumerationToolsTests.assertEquals((int)-1, (int)EnumerationTools.indexOf(v1.elements(), null, (int)22));
    }

    public void testLastIndexOfEnumerationObject() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertEquals((int)1, (int)EnumerationTools.lastIndexOf(v1.elements(), (Object)"one"));
        v1.add(null);
        EnumerationToolsTests.assertEquals((int)(v1.size() - 1), (int)EnumerationTools.lastIndexOf(v1.elements(), null));
    }

    public void testLastIndexOfEnumerationObjectInt() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertEquals((int)-1, (int)EnumerationTools.lastIndexOf(v1.elements(), (Object)"one", (int)-1));
        EnumerationToolsTests.assertEquals((int)1, (int)EnumerationTools.lastIndexOf(v1.elements(), (Object)"one", (int)1));
        EnumerationToolsTests.assertEquals((int)-1, (int)EnumerationTools.lastIndexOf(v1.elements(), (Object)"two", (int)1));
        EnumerationToolsTests.assertEquals((int)1, (int)EnumerationTools.lastIndexOf(v1.elements(), (Object)"one", (int)2));
        EnumerationToolsTests.assertEquals((int)1, (int)EnumerationTools.lastIndexOf(v1.elements(), (Object)"one", (int)22));
    }

    public void testLastIndexOfEnumerationObject_Empty() {
        EnumerationToolsTests.assertEquals((int)-1, (int)EnumerationTools.lastIndexOf((Enumeration)EnumerationTools.emptyEnumeration(), (Object)"foo"));
    }

    public void testLastIndexOfEnumerationObjectInt_Null() {
        Vector<String> v1 = this.buildStringVector1();
        v1.add(null);
        EnumerationToolsTests.assertEquals((int)-1, (int)EnumerationTools.lastIndexOf(v1.elements(), null, (int)-1));
        EnumerationToolsTests.assertEquals((int)-1, (int)EnumerationTools.lastIndexOf(v1.elements(), null, (int)2));
        EnumerationToolsTests.assertEquals((int)(v1.size() - 1), (int)EnumerationTools.lastIndexOf(v1.elements(), null, (int)(v1.size() - 1)));
        EnumerationToolsTests.assertEquals((int)(v1.size() - 1), (int)EnumerationTools.lastIndexOf(v1.elements(), null, (int)22));
    }

    public void testLastEnumeration1() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertEquals((String)"two", (String)((String)EnumerationTools.last(v1.elements())));
        v1.add(null);
        EnumerationToolsTests.assertEquals(null, (String)((String)EnumerationTools.last(v1.elements())));
    }

    public void testLastEnumeration2() {
        Vector v1 = new Vector();
        boolean exCaught = false;
        try {
            EnumerationTools.last(v1.elements());
            EnumerationToolsTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EnumerationToolsTests.assertTrue((boolean)exCaught);
    }

    public void testSizeEnumeration() {
        EnumerationToolsTests.assertEquals((int)3, (int)EnumerationTools.size(this.buildStringVector1().elements()));
    }

    public void testIsEmptyEnumeration() {
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.isEmpty((Enumeration)EnumerationTools.emptyEnumeration()));
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.isEmpty(this.buildStringVector1().elements()));
    }

    public void testSortEnumeration() {
        Vector<String> list = new Vector<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        Enumeration enumeration1 = list.elements();
        Enumeration enumeration2 = EnumerationTools.sort(enumeration1);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreEqual((Enumeration)EnumerationTools.enumeration(ss), (Enumeration)enumeration2));
    }

    public void testSortEnumerationInt() {
        Vector<String> list = new Vector<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        Enumeration enumeration1 = list.elements();
        Enumeration enumeration2 = EnumerationTools.sort(enumeration1, (int)77);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreEqual((Enumeration)EnumerationTools.enumeration(ss), (Enumeration)enumeration2));
    }

    public void testSortEnumerationComparator() {
        Vector<String> list = new Vector<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>(ComparatorTools.reverseComparator());
        ss.addAll(list);
        Enumeration enumeration1 = list.elements();
        Enumeration enumeration2 = EnumerationTools.sort(enumeration1, (Comparator)ComparatorTools.reverseComparator());
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreEqual((Enumeration)EnumerationTools.enumeration(ss), (Enumeration)enumeration2));
    }

    public void testSortEnumerationComparatorInt() {
        Vector<String> list = new Vector<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>(ComparatorTools.reverseComparator());
        ss.addAll(list);
        Enumeration enumeration1 = list.elements();
        Enumeration enumeration2 = EnumerationTools.sort(enumeration1, (Comparator)ComparatorTools.reverseComparator(), (int)77);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.elementsAreEqual((Enumeration)EnumerationTools.enumeration(ss), (Enumeration)enumeration2));
    }

    public void testIteratorEnumeration() {
        Vector<String> v1 = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)IteratorTools.elementsAreIdentical((Iterator)EnumerationTools.iterator(v1.elements()), v1.iterator()));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(EnumerationTools.class);
                EnumerationToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        EnumerationToolsTests.assertTrue((boolean)exCaught);
    }

    private Vector<String> buildStringVector1() {
        Vector<String> v = new Vector<String>();
        this.addToCollection1(v);
        return v;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }
}

