/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.prefs;

import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.prefs.PreferencePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.model.value.prefs.PreferencesTestCase;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class PreferencePropertyValueModelTests
extends PreferencesTestCase {
    private ModifiablePropertyValueModel<Preferences> nodeHolder;
    PreferencePropertyValueModel<String> preferenceAdapter;
    PropertyChangeEvent event;
    PropertyChangeListener listener;
    boolean listenerRemoved = false;
    PreferenceChangeEvent preferenceEvent;
    private static final String KEY_NAME = "foo";
    private static final String STRING_VALUE = "original string value";

    public PreferencePropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode.put(KEY_NAME, STRING_VALUE);
        this.nodeHolder = new SimplePropertyValueModel((Object)this.testNode);
        this.preferenceAdapter = PreferencePropertyValueModel.forString(this.nodeHolder, (String)KEY_NAME, null);
        this.listener = this.buildValueChangeListener();
        this.preferenceAdapter.addPropertyChangeListener("value", this.listener);
        this.event = null;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (PreferencePropertyValueModelTests.this.event != null) {
                    throw new IllegalStateException("unexpected this.event: " + e);
                }
                PreferencePropertyValueModelTests.this.event = e;
            }
        };
    }

    public void testSubjectHolder() throws Exception {
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        String ANOTHER_STRING_VALUE = "some other value";
        Preferences anotherNode = this.classNode.node("another test node");
        anotherNode.put(KEY_NAME, ANOTHER_STRING_VALUE);
        this.nodeHolder.setValue((Object)anotherNode);
        this.verifyEvent(STRING_VALUE, ANOTHER_STRING_VALUE);
        PreferencePropertyValueModelTests.assertEquals((String)ANOTHER_STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
        this.event = null;
        this.nodeHolder.setValue(null);
        this.verifyEvent(ANOTHER_STRING_VALUE, null);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceAdapter.getValue());
        this.event = null;
        this.nodeHolder.setValue((Object)this.testNode);
        this.verifyEvent(null, STRING_VALUE);
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
    }

    public void testPreferenceChange() throws Exception {
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        this.testNode.put(KEY_NAME, "original string valueoriginal string value");
        this.waitForEventQueueToClear();
        this.verifyEvent(STRING_VALUE, "original string valueoriginal string value");
        PreferencePropertyValueModelTests.assertEquals((String)"original string valueoriginal string value", (String)((String)this.preferenceAdapter.getValue()));
        this.event = null;
        this.testNode.remove(KEY_NAME);
        this.waitForEventQueueToClear();
        this.verifyEvent("original string valueoriginal string value", null);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceAdapter.getValue());
        this.event = null;
        this.testNode.put(KEY_NAME, STRING_VALUE);
        this.waitForEventQueueToClear();
        this.verifyEvent(null, STRING_VALUE);
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
    }

    public void testValue() throws Exception {
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)this.testNode.get(KEY_NAME, "<missing preference>"));
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
    }

    public void testSetValue() throws Exception {
        String ANOTHER_STRING_VALUE = "some other value";
        this.preferenceAdapter.setValue((Object)ANOTHER_STRING_VALUE);
        PreferencePropertyValueModelTests.assertEquals((String)ANOTHER_STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
        PreferencePropertyValueModelTests.assertEquals((String)ANOTHER_STRING_VALUE, (String)this.testNode.get(KEY_NAME, "<missing preference>"));
    }

    public void testHasListeners() throws Exception {
        PreferencePropertyValueModelTests.assertTrue((boolean)this.preferenceAdapter.hasAnyPropertyChangeListeners("value"));
        PreferencePropertyValueModelTests.assertTrue((boolean)this.nodeHasAnyPrefListeners(this.testNode));
        this.preferenceAdapter.removePropertyChangeListener("value", this.listener);
        PreferencePropertyValueModelTests.assertFalse((boolean)this.nodeHasAnyPrefListeners(this.testNode));
        PreferencePropertyValueModelTests.assertFalse((boolean)this.preferenceAdapter.hasAnyPropertyChangeListeners("value"));
        ChangeListener listener2 = this.buildChangeListener();
        this.preferenceAdapter.addChangeListener(listener2);
        PreferencePropertyValueModelTests.assertTrue((boolean)this.preferenceAdapter.hasAnyPropertyChangeListeners("value"));
        PreferencePropertyValueModelTests.assertTrue((boolean)this.nodeHasAnyPrefListeners(this.testNode));
        this.preferenceAdapter.removeChangeListener(listener2);
        PreferencePropertyValueModelTests.assertFalse((boolean)this.nodeHasAnyPrefListeners(this.testNode));
        PreferencePropertyValueModelTests.assertFalse((boolean)this.preferenceAdapter.hasAnyPropertyChangeListeners("value"));
    }

    private ChangeListener buildChangeListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (PreferencePropertyValueModelTests.this.event != null) {
                    throw new IllegalStateException("unexpected this.event: " + e);
                }
                PreferencePropertyValueModelTests.this.event = e;
            }
        };
    }

    public void testRemoveAndReAddPreference() throws Exception {
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)this.testNode.get(KEY_NAME, null));
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        this.testNode.remove(KEY_NAME);
        this.waitForEventQueueToClear();
        PreferencePropertyValueModelTests.assertNull((Object)this.testNode.get(KEY_NAME, null));
        this.verifyEvent(STRING_VALUE, null);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceAdapter.getValue());
        this.event = null;
        this.testNode.put(KEY_NAME, STRING_VALUE);
        this.waitForEventQueueToClear();
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)this.testNode.get(KEY_NAME, null));
        this.verifyEvent(null, STRING_VALUE);
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
    }

    public void testDefaultValue() throws Exception {
        String DEFAULT_VALUE = "default value";
        this.preferenceAdapter.removePropertyChangeListener("value", this.listener);
        this.preferenceAdapter = PreferencePropertyValueModel.forString(this.nodeHolder, (String)KEY_NAME, (String)DEFAULT_VALUE);
        this.preferenceAdapter.addPropertyChangeListener("value", this.listener);
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)this.testNode.get(KEY_NAME, null));
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        this.testNode.remove(KEY_NAME);
        this.waitForEventQueueToClear();
        PreferencePropertyValueModelTests.assertNull((Object)this.testNode.get(KEY_NAME, null));
        this.verifyEvent(STRING_VALUE, DEFAULT_VALUE);
        PreferencePropertyValueModelTests.assertEquals((String)DEFAULT_VALUE, (String)((String)this.preferenceAdapter.getValue()));
        this.event = null;
        this.testNode.put(KEY_NAME, STRING_VALUE);
        this.waitForEventQueueToClear();
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)this.testNode.get(KEY_NAME, null));
        this.verifyEvent(DEFAULT_VALUE, STRING_VALUE);
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
    }

    public void testUnsynchronizedValue() throws Exception {
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        this.preferenceAdapter.removePropertyChangeListener("value", this.listener);
        this.testNode.put(KEY_NAME, "original string valueoriginal string value");
        this.waitForEventQueueToClear();
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceAdapter.getValue());
        this.testNode.remove(KEY_NAME);
        this.waitForEventQueueToClear();
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceAdapter.getValue());
        this.testNode.put(KEY_NAME, STRING_VALUE);
        this.waitForEventQueueToClear();
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceAdapter.getValue());
        this.preferenceAdapter.addPropertyChangeListener("value", this.listener);
        PreferencePropertyValueModelTests.assertEquals((String)STRING_VALUE, (String)((String)this.preferenceAdapter.getValue()));
    }

    public void testIntegerPreference() throws Exception {
        this.preferenceAdapter.removePropertyChangeListener("value", this.listener);
        PreferencePropertyValueModel integerPreferenceAdapter = PreferencePropertyValueModel.forInteger(this.nodeHolder, (String)KEY_NAME, (int)0);
        this.testNode.putInt(KEY_NAME, 123);
        integerPreferenceAdapter = PreferencePropertyValueModel.forInteger((Preferences)this.testNode, (String)KEY_NAME, (int)0);
        integerPreferenceAdapter.addPropertyChangeListener("value", this.listener);
        PreferencePropertyValueModelTests.assertEquals((Object)new Integer(123), (Object)integerPreferenceAdapter.getValue());
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        this.testNode.putInt(KEY_NAME, 246);
        this.waitForEventQueueToClear();
        this.verifyEvent((Model)integerPreferenceAdapter, new Integer(123), new Integer(246));
        PreferencePropertyValueModelTests.assertEquals((Object)new Integer(246), (Object)integerPreferenceAdapter.getValue());
        this.event = null;
        this.testNode.remove(KEY_NAME);
        this.waitForEventQueueToClear();
        this.verifyEvent((Model)integerPreferenceAdapter, new Integer(246), new Integer(0));
        PreferencePropertyValueModelTests.assertEquals((Object)new Integer(0), (Object)integerPreferenceAdapter.getValue());
        this.event = null;
        this.testNode.putInt(KEY_NAME, 123);
        this.waitForEventQueueToClear();
        this.verifyEvent((Model)integerPreferenceAdapter, new Integer(0), new Integer(123));
        PreferencePropertyValueModelTests.assertEquals((Object)new Integer(123), (Object)integerPreferenceAdapter.getValue());
    }

    public void testRemoveNode() throws Exception {
        PreferencePropertyValueModelTests.assertTrue((boolean)this.preferenceAdapter.hasAnyPropertyChangeListeners("value"));
        Preferences parent = this.testNode.parent();
        parent.addNodeChangeListener(this.buildParentNodeChangeListener());
        this.testNode.removeNode();
        this.testNode.flush();
        this.waitForEventQueueToClear();
        PreferencePropertyValueModelTests.assertTrue((boolean)this.listenerRemoved);
        PreferencePropertyValueModelTests.assertTrue((boolean)this.preferenceAdapter.hasNoPropertyChangeListeners("value"));
    }

    private NodeChangeListener buildParentNodeChangeListener() {
        return new NodeChangeListener(){

            public void childAdded(NodeChangeEvent e) {
                throw new IllegalStateException("unexpected this.event: " + e);
            }

            public void childRemoved(NodeChangeEvent e) {
                if (e.getChild() == PreferencePropertyValueModelTests.this.testNode) {
                    PreferencePropertyValueModelTests.this.preferenceAdapter.removePropertyChangeListener("value", PreferencePropertyValueModelTests.this.listener);
                    PreferencePropertyValueModelTests.this.listenerRemoved = true;
                }
            }
        };
    }

    public void testSetSameValue() {
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceEvent);
        this.testNode.addPreferenceChangeListener(this.buildPreferenceChangeListener());
        String ANOTHER_STRING_VALUE = "some other value";
        this.preferenceAdapter.setValue((Object)ANOTHER_STRING_VALUE);
        this.verifyEvent(STRING_VALUE, ANOTHER_STRING_VALUE);
        this.waitForEventQueueToClear();
        this.verifyPreferenceEvent(ANOTHER_STRING_VALUE);
        this.event = null;
        this.preferenceEvent = null;
        this.preferenceAdapter.setValue((Object)ANOTHER_STRING_VALUE);
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceEvent);
    }

    public void testSetSameValueForcePassThrough() throws Exception {
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        PreferencePropertyValueModelTests.assertNull((Object)this.preferenceEvent);
        this.preferenceAdapter.removePropertyChangeListener("value", this.listener);
        this.preferenceAdapter = AlwaysUpdatePreferencePropertyValueModel.forString(this.nodeHolder, KEY_NAME, null);
        this.preferenceAdapter.addPropertyChangeListener("value", this.listener);
        this.testNode.addPreferenceChangeListener(this.buildPreferenceChangeListener());
        String ANOTHER_STRING_VALUE = "some other value";
        this.preferenceAdapter.setValue((Object)ANOTHER_STRING_VALUE);
        this.verifyEvent(STRING_VALUE, ANOTHER_STRING_VALUE);
        this.waitForEventQueueToClear();
        this.verifyPreferenceEvent(ANOTHER_STRING_VALUE);
        this.event = null;
        this.preferenceEvent = null;
        this.preferenceAdapter.setValue((Object)ANOTHER_STRING_VALUE);
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
        this.waitForEventQueueToClear();
        this.verifyPreferenceEvent(ANOTHER_STRING_VALUE);
        PreferencePropertyValueModelTests.assertNull((Object)this.event);
    }

    private PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                PreferencePropertyValueModelTests.this.preferenceEvent = evt;
            }
        };
    }

    private void verifyEvent(Model source, Object oldValue, Object newValue) {
        PreferencePropertyValueModelTests.assertNotNull((Object)this.event);
        PreferencePropertyValueModelTests.assertEquals((Object)source, (Object)this.event.getSource());
        PreferencePropertyValueModelTests.assertEquals((String)"value", (String)this.event.getPropertyName());
        PreferencePropertyValueModelTests.assertEquals((Object)oldValue, (Object)this.event.getOldValue());
        PreferencePropertyValueModelTests.assertEquals((Object)newValue, (Object)this.event.getNewValue());
    }

    private void verifyEvent(Object oldValue, Object newValue) {
        this.verifyEvent((Model)this.preferenceAdapter, oldValue, newValue);
    }

    private void verifyPreferenceEvent(Object newValue) {
        PreferencePropertyValueModelTests.assertNotNull((Object)this.preferenceEvent);
        PreferencePropertyValueModelTests.assertEquals((Object)this.testNode, (Object)this.preferenceEvent.getSource());
        PreferencePropertyValueModelTests.assertEquals((String)KEY_NAME, (String)this.preferenceEvent.getKey());
        PreferencePropertyValueModelTests.assertEquals((Object)newValue, (Object)this.preferenceEvent.getNewValue());
        PreferencePropertyValueModelTests.assertEquals((Object)newValue, (Object)this.testNode.get(KEY_NAME, "<missing preference>"));
    }

    private boolean nodeHasAnyPrefListeners(Preferences node) throws Exception {
        PreferenceChangeListener[] prefListeners = (PreferenceChangeListener[])ObjectTools.get((Object)node, (String)"prefListeners");
        return prefListeners.length > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AlwaysUpdatePreferencePropertyValueModel<P>
    extends PreferencePropertyValueModel<P> {
        public static PreferencePropertyValueModel<String> forString(PropertyValueModel<? extends Preferences> preferencesModel, String key, String defaultValue) {
            return new AlwaysUpdatePreferencePropertyValueModel<String>(preferencesModel, key, defaultValue, TransformerTools.passThruTransformer());
        }

        AlwaysUpdatePreferencePropertyValueModel(PropertyValueModel<? extends Preferences> preferencesModel, String key, P defaultValue, Transformer<String, P> stringTransformer) {
            super(preferencesModel, key, defaultValue, stringTransformer);
        }

        protected boolean preferenceIsToBeSet(Object oldValue, Object newValue) {
            return true;
        }
    }
}

