/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteConverterTestCase
extends BaseWriteTestCase {
    protected static final String CONVERTER = "converter";
    private static final String CONVERTER_CLASS = CommonStructuresUtil.createPreficedString("converter", "class");
    private static final String CONVERTER_CLASS_FOR = CommonStructuresUtil.createPreficedString("converter", CommonStructuresUtil.createPreficedString("class", "for"));
    protected static final String CONVERTER_ID = CommonStructuresUtil.createPreficedString("converter", "id");

    public WriteConverterTestCase(String name) {
        super(name);
    }

    public void testWriteConverter() {
        ConverterIdType converterId;
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            ConverterType converter = facesConfigFactory.createConverterType();
            converter.getDescription().add((Object)CommonStructuresUtil.createDescription(CONVERTER));
            converter.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(CONVERTER));
            converter.getIcon().add((Object)CommonStructuresUtil.createIcon(CONVERTER));
            ConverterClassType converterClassType = facesConfigFactory.createConverterClassType();
            converterClassType.setTextContent(CONVERTER_CLASS);
            converterClassType.setId(CommonStructuresUtil.createPreficedString(CONVERTER_CLASS, "id"));
            converter.setConverterClass(converterClassType);
            ConverterForClassType converterForClassType = facesConfigFactory.createConverterForClassType();
            converterForClassType.setTextContent(CONVERTER_CLASS_FOR);
            converterForClassType.setId(CommonStructuresUtil.createPreficedString(CONVERTER_CLASS_FOR, "id"));
            converter.setConverterForClass(converterForClassType);
            converterId = facesConfigFactory.createConverterIdType();
            converterId.setTextContent(CONVERTER_ID);
            converterId.setId(CommonStructuresUtil.createPreficedString(CONVERTER_CLASS_FOR, "id"));
            converter.setConverterId(converterId);
            converter.getAttribute().add((Object)CommonStructuresUtil.createAttribute(CONVERTER));
            converter.getProperty().add((Object)CommonStructuresUtil.createProperty(CONVERTER));
            converter.setId(CONVERTER_ID);
            edit.getFacesConfig().getConverter().add((Object)converter);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteConverterTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            ConverterType converter = (ConverterType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getConverter(), CONVERTER_ID);
            WriteConverterTestCase.assertNotNull((Object)converter);
            WriteConverterTestCase.assertEquals((int)1, (int)converter.getDescription().size());
            CommonStructuresUtil.assertMatchesDescription(CONVERTER, (DescriptionType)converter.getDescription().get(0));
            WriteConverterTestCase.assertEquals((int)1, (int)converter.getDisplayName().size());
            CommonStructuresUtil.assertMatchesDisplayName(CONVERTER, (DisplayNameType)converter.getDisplayName().get(0));
            WriteConverterTestCase.assertEquals((int)1, (int)converter.getIcon().size());
            CommonStructuresUtil.assertMatchesIcon(CONVERTER, (IconType)converter.getIcon().get(0));
            ConverterClassType converterClassType = converter.getConverterClass();
            WriteConverterTestCase.assertEquals((String)CONVERTER_CLASS, (String)converterClassType.getTextContent());
            WriteConverterTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(CONVERTER_CLASS, "id"), (String)converterClassType.getId());
            ConverterForClassType converterForClassType = converter.getConverterForClass();
            WriteConverterTestCase.assertEquals((String)CONVERTER_CLASS_FOR, (String)converterForClassType.getTextContent());
            WriteConverterTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(CONVERTER_CLASS_FOR, "id"), (String)converterForClassType.getId());
            converterId = converter.getConverterId();
            WriteConverterTestCase.assertEquals((String)CONVERTER_ID, (String)converterId.getTextContent());
            WriteConverterTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(CONVERTER_CLASS_FOR, "id"), (String)converterId.getId());
            converter.getAttribute().add((Object)CommonStructuresUtil.createAttribute(CONVERTER));
            converter.getProperty().add((Object)CommonStructuresUtil.createProperty(CONVERTER));
            WriteConverterTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(CONVERTER, "id"), (String)converter.getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

