/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.test;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.facesconfig.ui.test.FacesConfigEditorTest;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;

public class WebrootUtilTest
extends FacesConfigEditorTest {
    private static final String WEB_CONTENT_PATH = "/emptyjsfproject/WebContent";

    public void testGetWebPathIPath() {
    }

    public void testIsUnderWebContentFolder() throws CoreException {
        IFile resource = this.project.getFile((IPath)new Path("WebContent/web.xml"));
        WebrootUtilTest.assertTrue((boolean)WebrootUtil.isUnderWebContentFolder((IResource)resource));
        IContainer container = WebrootUtil.getWebContentContainer((IProject)this.project);
        IFile page1 = container.getFile((IPath)new Path("page1.jsp"));
        page1.create(null, true, (IProgressMonitor)new NullProgressMonitor());
        WebrootUtilTest.assertTrue((boolean)WebrootUtil.isUnderWebContentFolder((IResource)page1));
        IFile file1 = this.project.getFile("file1.txt");
        file1.create(null, true, (IProgressMonitor)new NullProgressMonitor());
        WebrootUtilTest.assertFalse((boolean)WebrootUtil.isUnderWebContentFolder((IResource)file1));
    }

    public void testGetWebContentPath() {
        IPath path = WebrootUtil.getWebContentPath((IProject)this.project);
        WebrootUtilTest.assertNotNull((Object)path);
        WebrootUtilTest.assertEquals((String)path.toString(), (String)WEB_CONTENT_PATH);
    }

    public void testGetWebContentContainer() {
        IContainer container = WebrootUtil.getWebContentContainer((IProject)this.project);
        WebrootUtilTest.assertNotNull((Object)container);
        WebrootUtilTest.assertTrue((boolean)container.exists());
        WebrootUtilTest.assertEquals((String)container.getFullPath().toString(), (String)WEB_CONTENT_PATH);
    }

    public void testGetWebContentFolderDepth() {
        WebrootUtilTest.assertEquals((int)2, (int)WebrootUtil.getWebContentFolderDepth((IProject)this.project));
    }

    public void testIsValidWebFile() throws CoreException {
        IContainer container = WebrootUtil.getWebContentContainer((IProject)this.project);
        IFile page1 = container.getFile((IPath)new Path("page1.jsp"));
        page1.create(null, true, (IProgressMonitor)new NullProgressMonitor());
        WebrootUtilTest.assertTrue((boolean)WebrootUtil.isValidWebFile((IPath)page1.getFullPath()));
        IFile page2 = container.getFile((IPath)new Path("page2.jsv"));
        page2.create(null, true, (IProgressMonitor)new NullProgressMonitor());
        WebrootUtilTest.assertTrue((boolean)WebrootUtil.isValidWebFile((IPath)page2.getFullPath()));
        IFile file1 = this.project.getFile("file1.txt");
        file1.create(null, true, (IProgressMonitor)new NullProgressMonitor());
        WebrootUtilTest.assertFalse((boolean)WebrootUtil.isValidWebFile((IPath)file1.getFullPath()));
    }

    public void testGetWebPathString() {
    }

    public void testGetPageNameFromWebPath() {
    }
}

