/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.utility.jdt;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.common.core.tests.CoreTestTools;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementIterator;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationTestCase
extends TestCase {
    protected JavaProjectTestHarness javaProjectTestHarness;
    public static final String CR = StringTools.CR;
    public static final String SEP = File.separator;
    public static final String PROJECT_NAME = "AnnotationTestProject";
    public static final String PACKAGE_NAME = "test";
    public static final String PACKAGE_NAME_ = "test.";
    public static final String PACKAGE_INFO_FILE_NAME = "package-info.java";
    public static final IPath PACKAGE_INFO_FILE_PATH = new Path("src" + SEP + "test" + SEP + "package-info.java");
    public static final String TYPE_NAME = "AnnotationTestType";
    public static final String FULLY_QUALIFIED_TYPE_NAME = "test.AnnotationTestType";
    public static final String FILE_NAME = "AnnotationTestType.java";
    public static final IPath FILE_PATH = new Path("src" + SEP + "test" + SEP + "AnnotationTestType.java");

    protected AnnotationTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.javaProjectTestHarness = this.buildJavaProjectTestHarness(false);
    }

    protected JavaProjectTestHarness buildJavaProjectTestHarness(boolean autoBuild) throws Exception {
        return this.buildJavaProjectTestHarness(PROJECT_NAME, autoBuild);
    }

    protected JavaProjectTestHarness buildJavaProjectTestHarness(String projectName, boolean autoBuild) throws Exception {
        return new JavaProjectTestHarness(projectName, autoBuild);
    }

    protected void tearDown() throws Exception {
        CoreTestTools.delete(this.javaProjectTestHarness.getProject());
        TestTools.clear((TestCase)this);
        super.tearDown();
    }

    protected void dumpSource(ICompilationUnit cu) throws Exception {
        System.out.println("*** " + this.getName() + " ****");
        System.out.println(this.getSource(cu));
        System.out.println();
    }

    protected ICompilationUnit createTestPackageInfo() throws CoreException {
        return this.createTestPackageInfo(new DefaultAnnotationWriter());
    }

    protected ICompilationUnit createTestPackageInfo(String packageName) throws CoreException {
        return this.createTestPackageInfo(packageName, new DefaultAnnotationWriter());
    }

    protected ICompilationUnit createTestPackageInfo(final String packageAnnotation, final String ... imports) throws CoreException {
        return this.createTestPackageInfo(new DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])imports);
            }

            @Override
            public void appendPackageAnnotationTo(StringBuilder sb) {
                sb.append(packageAnnotation);
            }
        });
    }

    protected ICompilationUnit createTestPackageInfo(AnnotationWriter annotationWriter) throws CoreException {
        return this.createTestPackageInfo(PACKAGE_NAME, annotationWriter);
    }

    protected ICompilationUnit createTestPackageInfo(String packageName, AnnotationWriter annotationWriter) throws CoreException {
        return this.javaProjectTestHarness.createCompilationUnit(packageName, PACKAGE_INFO_FILE_NAME, this.createSourceWriter(annotationWriter, packageName, null));
    }

    protected ICompilationUnit createTestType() throws CoreException {
        return this.createTestType(new DefaultAnnotationWriter());
    }

    protected ICompilationUnit createTestType(final String annotationImport, final String idFieldAnnotation) throws CoreException {
        return this.createTestType(new DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return annotationImport == null ? EmptyIterator.instance() : new SingleElementIterator((Object)annotationImport);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(idFieldAnnotation);
            }
        });
    }

    protected ICompilationUnit createTestType(String idFieldAnnotation) throws CoreException {
        return this.createTestType(null, idFieldAnnotation);
    }

    protected ICompilationUnit createTestType(AnnotationWriter annotationWriter) throws CoreException {
        return this.javaProjectTestHarness.createCompilationUnit(PACKAGE_NAME, FILE_NAME, this.createSourceWriter(annotationWriter));
    }

    protected ICompilationUnit createTestType(String typeName, AnnotationWriter annotationWriter) throws CoreException {
        return this.javaProjectTestHarness.createCompilationUnit(PACKAGE_NAME, String.valueOf(typeName) + ".java", this.createSourceWriter(annotationWriter, typeName));
    }

    protected ICompilationUnit createTestType(String packageName, String fileName, String typeName, AnnotationWriter annotationWriter) throws CoreException {
        return this.javaProjectTestHarness.createCompilationUnit(packageName, fileName, this.createSourceWriter(annotationWriter, typeName));
    }

    protected JavaProjectTestHarness.SourceWriter createSourceWriter(AnnotationWriter annotationWriter) {
        return new AnnotatedSourceWriter(annotationWriter);
    }

    protected JavaProjectTestHarness.SourceWriter createSourceWriter(AnnotationWriter annotationWriter, String typeName) {
        return new AnnotatedSourceWriter(annotationWriter, typeName);
    }

    protected JavaProjectTestHarness.SourceWriter createSourceWriter(AnnotationWriter annotationWriter, String packageName, String typeName) {
        return new AnnotatedSourceWriter(annotationWriter, packageName, typeName);
    }

    protected ICompilationUnit createTestEnum(EnumAnnotationWriter annotationWriter) throws CoreException {
        return this.javaProjectTestHarness.createCompilationUnit(PACKAGE_NAME, FILE_NAME, this.createEnumSourceWriter(annotationWriter));
    }

    protected ICompilationUnit createTestEnum(String packageName, String fileName, String enumName, EnumAnnotationWriter annotationWriter) throws CoreException {
        return this.javaProjectTestHarness.createCompilationUnit(packageName, fileName, this.createEnumSourceWriter(annotationWriter, enumName));
    }

    protected JavaProjectTestHarness.SourceWriter createEnumSourceWriter(EnumAnnotationWriter annotationWriter) {
        return new EnumAnnotatedSourceWriter(annotationWriter);
    }

    protected JavaProjectTestHarness.SourceWriter createEnumSourceWriter(EnumAnnotationWriter annotationWriter, String enumName) {
        return new EnumAnnotatedSourceWriter(annotationWriter, enumName);
    }

    protected JavaProjectTestHarness.SourceWriter createEnumSourceWriter(EnumAnnotationWriter annotationWriter, String packageName, String enumName) {
        return new EnumAnnotatedSourceWriter(annotationWriter, packageName, enumName);
    }

    protected ICompilationUnit createAnnotatedEnumAndMembers(String enumName, String enumBody) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(PACKAGE_NAME).append(";").append(CR);
        sb.append(CR);
        sb.append("import javax.xml.bind.annotation.XmlEnum;");
        sb.append(CR);
        sb.append(CR);
        sb.append("@XmlEnum");
        sb.append(CR);
        sb.append("public enum ").append(enumName).append(" { ").append(enumBody).append(" }");
        return this.javaProjectTestHarness.createCompilationUnit(PACKAGE_NAME, String.valueOf(enumName) + ".java", sb.toString());
    }

    protected void appendSourceTo(StringBuilder sb, AnnotationWriter annotationWriter, String packageName) {
        annotationWriter.appendPackageAnnotationTo(sb);
        sb.append(CR);
        sb.append("package ").append(packageName).append(";").append(CR);
        sb.append(CR);
        Iterator<String> stream = annotationWriter.imports();
        while (stream.hasNext()) {
            sb.append("import ").append(stream.next()).append(";").append(CR);
        }
    }

    protected void appendSourceTo(StringBuilder sb, AnnotationWriter annotationWriter, String packageName, String typeName) {
        sb.append("package ").append(packageName).append(";").append(CR);
        sb.append(CR);
        Iterator<String> stream = annotationWriter.imports();
        while (stream.hasNext()) {
            sb.append("import ");
            sb.append(stream.next());
            sb.append(";");
            sb.append(CR);
        }
        sb.append(CR);
        annotationWriter.appendTypeAnnotationTo(sb);
        sb.append(CR);
        sb.append("public class ").append(typeName).append(" ");
        annotationWriter.appendExtendsImplementsTo(sb);
        sb.append("{").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendIdFieldAnnotationTo(sb);
        sb.append(CR);
        sb.append("    private int id;").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendNameFieldAnnotationTo(sb);
        sb.append(CR);
        sb.append("    private String name;").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendGetIdMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public int getId() {").append(CR);
        sb.append("        return this.id;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendSetIdMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public void setId(int id) {").append(CR);
        sb.append("        this.id = id;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendGetNameMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public String getName() {").append(CR);
        sb.append("        return this.name;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendSetNameMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public void setTestField(String testField) {").append(CR);
        sb.append("        this.testField = testField;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        annotationWriter.appendMemberTypeTo(sb);
        sb.append(CR);
        sb.append("}").append(CR);
        annotationWriter.appendTopLevelTypesTo(sb);
        sb.append(CR);
    }

    protected void appendEnumSourceTo(StringBuilder sb, EnumAnnotationWriter annotationWriter, String packageName, String enumName) {
        sb.append("package ").append(packageName).append(";").append(CR);
        sb.append(CR);
        Iterator<String> stream = annotationWriter.imports();
        while (stream.hasNext()) {
            sb.append("import ");
            sb.append(stream.next());
            sb.append(";");
            sb.append(CR);
        }
        sb.append(CR);
        annotationWriter.appendEnumAnnotationTo(sb);
        sb.append(CR);
        sb.append("public enum ").append(enumName).append(" {").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendSundayEnumConstantAnnotationTo(sb);
        sb.append(CR);
        sb.append("    SUNDAY, ").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendMondayEnumConstantAnnotationTo(sb);
        sb.append(CR);
        sb.append("    MONDAY").append(CR);
        sb.append(CR);
        sb.append("}").append(CR);
        sb.append(CR);
    }

    protected JavaProjectTestHarness getJavaProjectTestHarness() {
        return this.javaProjectTestHarness;
    }

    protected IProject getProject() {
        return this.javaProjectTestHarness.getProject();
    }

    protected IJavaProject getJavaProject() {
        return this.javaProjectTestHarness.getJavaProject();
    }

    protected JDTType testType(ICompilationUnit cu) {
        return this.buildType(TYPE_NAME, cu);
    }

    protected JDTType buildType(String name, ICompilationUnit cu) {
        return this.buildType(name, 1, cu);
    }

    protected JDTType buildType(String name, int occurrence, ICompilationUnit cu) {
        return this.buildType(null, name, occurrence, cu);
    }

    protected JDTType buildType(Type declaringType, String name, int occurrence, ICompilationUnit cu) {
        return new JDTType(declaringType, name, occurrence, cu);
    }

    protected JDTFieldAttribute idField(ICompilationUnit cu) {
        return this.buildField("id", cu);
    }

    protected JDTFieldAttribute nameField(ICompilationUnit cu) {
        return this.buildField("name", cu);
    }

    protected JDTFieldAttribute buildField(String name, ICompilationUnit cu) {
        return this.buildField(name, 1, cu);
    }

    protected JDTFieldAttribute buildField(String name, int occurrence, ICompilationUnit cu) {
        return this.buildField((Type)this.testType(cu), name, occurrence, cu);
    }

    protected JDTFieldAttribute buildField(Type declaringType, String name, int occurrence, ICompilationUnit cu) {
        return new JDTFieldAttribute(declaringType, name, occurrence, cu);
    }

    protected JDTMethodAttribute idGetMethod(ICompilationUnit cu) {
        return this.buildMethod("getId", cu);
    }

    protected JDTMethodAttribute idSetMethod(ICompilationUnit cu) {
        return this.buildMethod("setId", new String[]{"int"}, cu);
    }

    protected JDTMethodAttribute nameGetMethod(ICompilationUnit cu) {
        return this.buildMethod("getName", cu);
    }

    protected JDTMethodAttribute buildMethod(String name, ICompilationUnit cu) {
        return this.buildMethod(name, StringTools.EMPTY_STRING_ARRAY, cu);
    }

    protected JDTMethodAttribute buildMethod(String name, String[] parameterTypeNames, ICompilationUnit cu) {
        return this.buildMethod(name, parameterTypeNames, 1, cu);
    }

    protected JDTMethodAttribute buildMethod(String name, String[] parameterTypeNames, int occurrence, ICompilationUnit cu) {
        return new JDTMethodAttribute((Type)this.testType(cu), name, parameterTypeNames, occurrence, cu);
    }

    protected JDTMethodAttribute buildMethod(Type declaringType, String name, String[] parameterTypeNames, int occurrence, ICompilationUnit cu) {
        return new JDTMethodAttribute(declaringType, name, parameterTypeNames, occurrence, cu);
    }

    protected String getSource(ICompilationUnit cu) throws JavaModelException {
        return cu.getBuffer().getContents();
    }

    protected CompilationUnit buildASTRoot(ICompilationUnit cu) {
        return ASTTools.buildASTRoot((ICompilationUnit)cu);
    }

    protected boolean compilationUnitContains(String s, ICompilationUnit cu) throws JavaModelException {
        String source = this.getSource(cu).replaceAll("\\s+", "");
        return source.indexOf(s.replaceAll("\\s+", "")) != -1;
    }

    protected void assertSourceContains(String s, ICompilationUnit cu) throws JavaModelException {
        boolean found = this.compilationUnitContains(s, cu);
        if (!found) {
            String msg = "source does not contain the expected string: " + s + " (see System console)";
            System.out.println("*** " + this.getName() + " ****");
            System.out.println(msg);
            System.out.println(this.getSource(cu));
            System.out.println();
            AnnotationTestCase.fail((String)msg);
        }
    }

    protected void assertSourceDoesNotContain(String s, ICompilationUnit cu) throws JavaModelException {
        if (this.compilationUnitContains(s, cu)) {
            String source = this.getSource(cu);
            int pos = source.indexOf(s);
            String msg = "unexpected string in source (position: " + pos + "): " + s + " (see System console)";
            System.out.println("*** " + this.getName() + " ****");
            System.out.println(msg);
            System.out.println(source);
            System.out.println();
            AnnotationTestCase.fail((String)msg);
        }
    }

    protected MemberValuePair memberValuePair(NormalAnnotation annotation, String elementName) {
        for (MemberValuePair pair : this.values(annotation)) {
            if (!pair.getName().getFullyQualifiedName().equals(elementName)) continue;
            return pair;
        }
        return null;
    }

    protected List<MemberValuePair> values(NormalAnnotation na) {
        return na.values();
    }

    protected List<EnumConstantDeclaration> enumConstants(EnumDeclaration ed) {
        return ed.enumConstants();
    }

    protected Expression value_(MemberValuePair pair) {
        return pair == null ? null : pair.getValue();
    }

    protected Expression annotationElementValue(NormalAnnotation annotation, String elementName) {
        return this.value_(this.memberValuePair(annotation, elementName));
    }

    protected Expression annotationElementValue(SingleMemberAnnotation annotation, String elementName) {
        return elementName.equals("value") ? annotation.getValue() : null;
    }

    protected Expression annotationElementValue(Annotation annotation, String elementName) {
        if (annotation.isNormalAnnotation()) {
            return this.annotationElementValue((NormalAnnotation)annotation, elementName);
        }
        if (annotation.isSingleMemberAnnotation()) {
            return this.annotationElementValue((SingleMemberAnnotation)annotation, elementName);
        }
        return null;
    }

    protected ArrayInitializer newArrayInitializer(AST ast, Expression ... expressions) {
        ArrayInitializer arrayInitializer = ast.newArrayInitializer();
        Expression[] expressionArray = expressions;
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            arrayInitializer.expressions().add(expression);
            ++n2;
        }
        return arrayInitializer;
    }

    protected NumberLiteral newNumberLiteral(AST ast, int value) {
        return ast.newNumberLiteral(Integer.toString(value));
    }

    protected BooleanLiteral newBooleanLiteral(AST ast, boolean value) {
        return ast.newBooleanLiteral(value);
    }

    protected StringLiteral newStringLiteral(AST ast, String value) {
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(value);
        return stringLiteral;
    }

    protected TypeLiteral newTypeLiteral(AST ast, String typeName) {
        TypeLiteral typeLiteral = ast.newTypeLiteral();
        typeLiteral.setType((org.eclipse.jdt.core.dom.Type)this.newSimpleType(ast, typeName));
        return typeLiteral;
    }

    protected SimpleType newSimpleType(AST ast, String typeName) {
        return this.newSimpleType(ast, ast.newName(typeName));
    }

    protected SimpleType newSimpleType(AST ast, Name typeName) {
        return ast.newSimpleType(typeName);
    }

    protected MemberValuePair newMemberValuePair(AST ast, SimpleName name, Expression value) {
        MemberValuePair pair = ast.newMemberValuePair();
        pair.setName(name);
        pair.setValue(value);
        return pair;
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, Expression value) {
        return this.newMemberValuePair(ast, ast.newSimpleName(name), value);
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, String value) {
        return this.newMemberValuePair(ast, name, (Expression)this.newStringLiteral(ast, value));
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, int value) {
        return this.newMemberValuePair(ast, name, (Expression)this.newNumberLiteral(ast, value));
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, boolean value) {
        return this.newMemberValuePair(ast, name, (Expression)this.newBooleanLiteral(ast, value));
    }

    protected EnumConstantDeclaration newEnumConstantDeclaration(AST ast, String enumConstantName) {
        EnumConstantDeclaration enumConstantDeclaration = ast.newEnumConstantDeclaration();
        enumConstantDeclaration.setName(ast.newSimpleName(enumConstantName));
        return enumConstantDeclaration;
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, MemberValuePair pair) {
        this.values(annotation).add(pair);
        return annotation;
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, String name, int value) {
        return this.addMemberValuePair(annotation, this.newMemberValuePair(annotation.getAST(), name, value));
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, String name, String value) {
        return this.addMemberValuePair(annotation, this.newMemberValuePair(annotation.getAST(), name, value));
    }

    protected NormalAnnotation addMemberValuePair(MarkerAnnotation annotation, String name, String value) {
        NormalAnnotation normalAnnotation = this.replaceMarkerAnnotation(annotation);
        this.addMemberValuePair(normalAnnotation, this.newMemberValuePair(annotation.getAST(), name, value));
        return normalAnnotation;
    }

    protected NormalAnnotation addMemberValuePair(MarkerAnnotation annotation, String name, boolean value) {
        NormalAnnotation normalAnnotation = this.replaceMarkerAnnotation(annotation);
        this.addMemberValuePair(normalAnnotation, this.newMemberValuePair(annotation.getAST(), name, value));
        return normalAnnotation;
    }

    protected NormalAnnotation addMemberValuePair(MarkerAnnotation annotation, MemberValuePair pair) {
        NormalAnnotation normalAnnotation = this.replaceMarkerAnnotation(annotation);
        return this.addMemberValuePair(normalAnnotation, pair);
    }

    protected void setMemberValuePair(ModifiedDeclaration declaration, String annotationName, String value) {
        this.setMemberValuePair(declaration, annotationName, "value", value);
    }

    protected void setMemberValuePair(ModifiedDeclaration declaration, String annotationName, String elementName, String value) {
        Annotation annotation = declaration.getAnnotationNamed(annotationName);
        if (annotation == null) {
            annotation = this.addNormalAnnotation(declaration.getDeclaration(), annotationName);
        } else if (annotation instanceof MarkerAnnotation) {
            annotation = this.replaceMarkerAnnotation((MarkerAnnotation)annotation);
        }
        this.setMemberValuePair((NormalAnnotation)annotation, elementName, value);
    }

    protected void setMemberValuePair(NormalAnnotation annotation, String elementName, String value) {
        MemberValuePair memberValuePair = this.memberValuePair(annotation, elementName);
        if (memberValuePair == null) {
            this.addMemberValuePair(annotation, elementName, value);
        } else {
            memberValuePair.setValue((Expression)this.newStringLiteral(annotation.getAST(), value));
        }
    }

    protected void removeMemberValuePair(ModifiedDeclaration declaration, String annotationName) {
        this.removeMemberValuePair(declaration, annotationName, "value");
    }

    protected void removeMemberValuePair(ModifiedDeclaration declaration, String annotationName, String elementName) {
        NormalAnnotation annotation = (NormalAnnotation)declaration.getAnnotationNamed(annotationName);
        this.values(annotation).remove(this.memberValuePair(annotation, elementName));
    }

    protected void setEnumMemberValuePair(ModifiedDeclaration declaration, String annotationName, String enumValue) {
        NormalAnnotation annotation = (NormalAnnotation)declaration.getAnnotationNamed(annotationName);
        if (annotation == null) {
            annotation = this.addNormalAnnotation(declaration.getDeclaration(), annotationName);
        }
        this.setEnumMemberValuePair(annotation, "value", enumValue);
    }

    protected void setEnumMemberValuePair(NormalAnnotation annotation, String elementName, String enumValue) {
        MemberValuePair memberValuePair = this.memberValuePair(annotation, elementName);
        if (memberValuePair == null) {
            this.addEnumMemberValuePair(annotation, elementName, enumValue);
        } else {
            memberValuePair.setValue((Expression)annotation.getAST().newName(enumValue));
        }
    }

    protected void addEnumMemberValuePair(MarkerAnnotation markerAnnotation, String elementName, String value) {
        this.addEnumMemberValuePair(this.replaceMarkerAnnotation(markerAnnotation), elementName, value);
    }

    protected void addEnumMemberValuePair(NormalAnnotation annotation, String elementName, String value) {
        this.addMemberValuePair(annotation, elementName, (Expression)annotation.getAST().newName(value));
    }

    protected void addMemberValuePair(NormalAnnotation annotation, String elementName, Expression value) {
        MemberValuePair memberValuePair = this.newMemberValuePair(annotation.getAST(), elementName, value);
        this.addMemberValuePair(annotation, memberValuePair);
    }

    protected void addMemberValuePair(MarkerAnnotation annotation, String elementName, Expression value) {
        MemberValuePair memberValuePair = this.newMemberValuePair(annotation.getAST(), elementName, value);
        this.addMemberValuePair(annotation, memberValuePair);
    }

    protected void addEnumConstant(EnumDeclaration enumDeclaration, String enumConstantName) {
        EnumConstantDeclaration enumConstantDeclaration = this.newEnumConstantDeclaration(enumDeclaration.getAST(), enumConstantName);
        this.enumConstants(enumDeclaration).add(enumConstantDeclaration);
    }

    protected void removeEnumConstant(EnumDeclaration enumDeclaration, String enumConstantName) {
        List<EnumConstantDeclaration> enumConstantsList = this.enumConstants(enumDeclaration);
        for (EnumConstantDeclaration constant : enumConstantsList) {
            if (!constant.getName().getFullyQualifiedName().equals(enumConstantName)) continue;
            enumConstantsList.remove(constant);
            break;
        }
    }

    protected void changeEnumConstantName(EnumDeclaration enumDeclaration, String oldEnumConstantName, String newEnumConstantName) {
        List<EnumConstantDeclaration> enumConstantsList = this.enumConstants(enumDeclaration);
        for (EnumConstantDeclaration constant : enumConstantsList) {
            if (!constant.getName().getFullyQualifiedName().equals(oldEnumConstantName)) continue;
            this.changeEnumConstantName(constant, newEnumConstantName);
            break;
        }
    }

    protected void changeEnumConstantName(EnumConstantDeclaration enumConstantDeclaration, String newEnumConstantName) {
        enumConstantDeclaration.setName(enumConstantDeclaration.getAST().newSimpleName(newEnumConstantName));
    }

    protected void addArrayElement(ModifiedDeclaration declaration, String annotationName, int index, String elementName, Expression arrayElement) {
        Annotation annotation = declaration.getAnnotationNamed(annotationName);
        NormalAnnotation normalAnnotation = annotation == null ? this.addNormalAnnotation(declaration.getDeclaration(), annotationName) : (annotation.getNodeType() == 78 ? this.replaceMarkerAnnotation((MarkerAnnotation)annotation) : (NormalAnnotation)annotation);
        this.addArrayElement(normalAnnotation, index, elementName, arrayElement);
    }

    protected void addArrayElement(NormalAnnotation annotation, int index, String elementName, Expression arrayElement) {
        MemberValuePair pair = this.memberValuePair(annotation, elementName);
        if (pair == null) {
            pair = this.newMemberValuePair(annotation.getAST(), elementName, arrayElement);
            this.addMemberValuePair(annotation, pair);
        } else {
            Expression value = pair.getValue();
            if (value.getNodeType() == 4) {
                this.expressions((ArrayInitializer)value).add(index, arrayElement);
            } else {
                ArrayInitializer arrayInitializer = annotation.getAST().newArrayInitializer();
                pair.setValue((Expression)arrayInitializer);
                this.expressions(arrayInitializer).add(value);
                this.expressions(arrayInitializer).add(index, arrayElement);
            }
        }
    }

    protected void moveArrayElement(NormalAnnotation annotation, String elementName, int targetIndex, int sourceIndex) {
        MemberValuePair pair = this.memberValuePair(annotation, elementName);
        ArrayInitializer array = (ArrayInitializer)pair.getValue();
        ListTools.move(this.expressions(array), (int)targetIndex, (int)sourceIndex);
    }

    protected void removeArrayElement(NormalAnnotation annotation, String elementName, int index) {
        MemberValuePair pair = this.memberValuePair(annotation, elementName);
        if (pair.getValue().getNodeType() == 4) {
            ArrayInitializer array = (ArrayInitializer)pair.getValue();
            this.expressions(array).remove(index);
            if (this.expressions(array).size() == 1) {
                pair.setValue(this.expressions(array).remove(0));
            }
        } else {
            this.values(annotation).remove(pair);
        }
    }

    protected NormalAnnotation replaceMarkerAnnotation(MarkerAnnotation annotation) {
        List<IExtendedModifier> annotations = this.annotations(annotation.getParent());
        int index = annotations.indexOf(annotation);
        NormalAnnotation normalAnnotation = this.newNormalAnnotation(annotation.getAST(), annotation.getTypeName().getFullyQualifiedName());
        annotations.set(index, (IExtendedModifier)normalAnnotation);
        return normalAnnotation;
    }

    protected NormalAnnotation newNormalAnnotation(AST ast, String name) {
        NormalAnnotation annotation = ast.newNormalAnnotation();
        annotation.setTypeName(ast.newName(name));
        return annotation;
    }

    protected NormalAnnotation addNormalAnnotation(ASTNode astNode, String name) {
        NormalAnnotation annotation = this.newNormalAnnotation(astNode.getAST(), name);
        this.addAnnotation(astNode, (Annotation)annotation);
        return annotation;
    }

    protected void addAnnotation(ASTNode astNode, Annotation annotation) {
        this.annotations(astNode).add((IExtendedModifier)annotation);
    }

    protected MarkerAnnotation newMarkerAnnotation(AST ast, String name) {
        MarkerAnnotation annotation = ast.newMarkerAnnotation();
        annotation.setTypeName(ast.newName(name));
        return annotation;
    }

    protected MarkerAnnotation addMarkerAnnotation(ASTNode astNode, String name) {
        MarkerAnnotation annotation = this.newMarkerAnnotation(astNode.getAST(), name);
        this.addAnnotation(astNode, (Annotation)annotation);
        return annotation;
    }

    protected void removeAnnotation(ModifiedDeclaration declaration, String name) {
        this.removeAnnotation(declaration.getDeclaration(), declaration.getAnnotationNamed(name));
    }

    protected void removeAnnotation(ASTNode astNode, Annotation annotation) {
        this.annotations(astNode).remove(annotation);
    }

    protected List<IExtendedModifier> annotations(ASTNode astNode) {
        if (astNode instanceof BodyDeclaration) {
            return ((BodyDeclaration)astNode).modifiers();
        }
        if (astNode instanceof PackageDeclaration) {
            return ((PackageDeclaration)astNode).annotations();
        }
        return Collections.emptyList();
    }

    protected List<Expression> expressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    public class AnnotatedSourceWriter
    implements JavaProjectTestHarness.SourceWriter {
        private AnnotationWriter annotationWriter;
        private String packageName;
        private String typeName;

        public AnnotatedSourceWriter(AnnotationWriter annotationWriter) {
            this(annotationWriter, AnnotationTestCase.TYPE_NAME);
        }

        public AnnotatedSourceWriter(AnnotationWriter annotationWriter, String typeName) {
            this(annotationWriter, AnnotationTestCase.PACKAGE_NAME, typeName);
        }

        public AnnotatedSourceWriter(AnnotationWriter annotationWriter, String packageName, String typeName) {
            this.annotationWriter = annotationWriter;
            this.packageName = packageName;
            this.typeName = typeName;
        }

        public void appendSourceTo(StringBuilder sb) {
            if (this.typeName != null) {
                AnnotationTestCase.this.appendSourceTo(sb, this.annotationWriter, this.packageName, this.typeName);
            } else {
                AnnotationTestCase.this.appendSourceTo(sb, this.annotationWriter, this.packageName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AnnotationWriter {
        public Iterator<String> imports();

        public void appendPackageAnnotationTo(StringBuilder var1);

        public void appendTypeAnnotationTo(StringBuilder var1);

        public void appendExtendsImplementsTo(StringBuilder var1);

        public void appendIdFieldAnnotationTo(StringBuilder var1);

        public void appendNameFieldAnnotationTo(StringBuilder var1);

        public void appendGetIdMethodAnnotationTo(StringBuilder var1);

        public void appendSetIdMethodAnnotationTo(StringBuilder var1);

        public void appendGetNameMethodAnnotationTo(StringBuilder var1);

        public void appendSetNameMethodAnnotationTo(StringBuilder var1);

        public void appendMemberTypeTo(StringBuilder var1);

        public void appendTopLevelTypesTo(StringBuilder var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationWriterWrapper
    implements AnnotationWriter {
        private final AnnotationWriter aw;

        public AnnotationWriterWrapper(AnnotationWriter aw) {
            this.aw = aw;
        }

        @Override
        public Iterator<String> imports() {
            return this.aw.imports();
        }

        @Override
        public void appendPackageAnnotationTo(StringBuilder sb) {
            this.aw.appendPackageAnnotationTo(sb);
        }

        @Override
        public void appendTypeAnnotationTo(StringBuilder sb) {
            this.aw.appendTypeAnnotationTo(sb);
        }

        @Override
        public void appendExtendsImplementsTo(StringBuilder sb) {
            this.aw.appendExtendsImplementsTo(sb);
        }

        @Override
        public void appendIdFieldAnnotationTo(StringBuilder sb) {
            this.aw.appendIdFieldAnnotationTo(sb);
        }

        @Override
        public void appendNameFieldAnnotationTo(StringBuilder sb) {
            this.aw.appendNameFieldAnnotationTo(sb);
        }

        @Override
        public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
            this.aw.appendGetIdMethodAnnotationTo(sb);
        }

        @Override
        public void appendSetIdMethodAnnotationTo(StringBuilder sb) {
            this.aw.appendSetIdMethodAnnotationTo(sb);
        }

        @Override
        public void appendGetNameMethodAnnotationTo(StringBuilder sb) {
            this.aw.appendGetNameMethodAnnotationTo(sb);
        }

        @Override
        public void appendSetNameMethodAnnotationTo(StringBuilder sb) {
            this.aw.appendSetNameMethodAnnotationTo(sb);
        }

        @Override
        public void appendMemberTypeTo(StringBuilder sb) {
            this.aw.appendMemberTypeTo(sb);
        }

        @Override
        public void appendTopLevelTypesTo(StringBuilder sb) {
            this.aw.appendTopLevelTypesTo(sb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultAnnotationWriter
    implements AnnotationWriter {
        @Override
        public Iterator<String> imports() {
            return EmptyIterator.instance();
        }

        @Override
        public void appendPackageAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendTypeAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendExtendsImplementsTo(StringBuilder sb) {
        }

        @Override
        public void appendIdFieldAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendNameFieldAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendSetIdMethodAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendGetNameMethodAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendSetNameMethodAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendMemberTypeTo(StringBuilder sb) {
        }

        @Override
        public void appendTopLevelTypesTo(StringBuilder sb) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultEnumAnnotationWriter
    implements EnumAnnotationWriter {
        @Override
        public Iterator<String> imports() {
            return EmptyIterator.instance();
        }

        @Override
        public void appendPackageAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendEnumAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendSundayEnumConstantAnnotationTo(StringBuilder sb) {
        }

        @Override
        public void appendMondayEnumConstantAnnotationTo(StringBuilder sb) {
        }
    }

    public class EnumAnnotatedSourceWriter
    implements JavaProjectTestHarness.SourceWriter {
        private EnumAnnotationWriter annotationWriter;
        private String packageName;
        private String enumName;

        public EnumAnnotatedSourceWriter(EnumAnnotationWriter annotationWriter) {
            this(annotationWriter, AnnotationTestCase.TYPE_NAME);
        }

        public EnumAnnotatedSourceWriter(EnumAnnotationWriter annotationWriter, String enumName) {
            this(annotationWriter, AnnotationTestCase.PACKAGE_NAME, enumName);
        }

        public EnumAnnotatedSourceWriter(EnumAnnotationWriter annotationWriter, String packageName, String enumName) {
            this.annotationWriter = annotationWriter;
            this.packageName = packageName;
            this.enumName = enumName;
        }

        public void appendSourceTo(StringBuilder sb) {
            AnnotationTestCase.this.appendEnumSourceTo(sb, this.annotationWriter, this.packageName, this.enumName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EnumAnnotationWriter {
        public Iterator<String> imports();

        public void appendPackageAnnotationTo(StringBuilder var1);

        public void appendEnumAnnotationTo(StringBuilder var1);

        public void appendSundayEnumConstantAnnotationTo(StringBuilder var1);

        public void appendMondayEnumConstantAnnotationTo(StringBuilder var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringTypeLiteralTransformer
    extends TransformerAdapter<String, TypeLiteral> {
        protected final AST ast;

        public StringTypeLiteralTransformer(AST ast) {
            this.ast = ast;
        }

        public TypeLiteral transform(String string) {
            return AnnotationTestCase.this.newTypeLiteral(this.ast, string);
        }
    }
}

