/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.tests.internal.projects.JpaProjectTestHarness;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EclipseLinkPersistenceUnitTests
extends EclipseLinkContextModelTestCase {
    public static final String ORM2_XML_FILE_NAME = "orm2.xml";
    public static final String ORM3_XML_FILE_NAME = "orm3.xml";

    public EclipseLinkPersistenceUnitTests(String name) {
        super(name);
    }

    protected boolean createOrmXml() {
        return true;
    }

    protected void createOrmXmlFile(String fileName) throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)fileName);
        config.getDefaultOperation().execute(null, null);
        this.addXmlMappingFileRef("META-INF/" + fileName);
        this.getPersistenceXmlResource().save(null);
    }

    protected IDataModel buildEclipseLinkOrmConfig(JpaProjectTestHarness harness) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        dataModel.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)harness.getProject().getFolder("src/META-INF").getFullPath());
        dataModel.setProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", (Object)Boolean.FALSE);
        return dataModel;
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef1() throws Exception {
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JptXmlResource eclipseLinkOrmResource = this.getOrmXmlResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        this.deleteResource((Resource)eclipseLinkOrmResource);
        EclipseLinkPersistenceUnitTests.assertFalse((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JptXmlResource eclipseLinkOrmResource = this.getOrmXmlResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("META-INF/eclipselink-orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        EclipseLinkPersistenceUnitTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getSpecifiedMappingFileRefs()));
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }

    public void testUpdateEclipseLinkImpliedMappingFileRef3() {
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JptXmlResource eclipseLinkOrmResource = this.getOrmXmlResource();
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
        persistenceUnit.getGeneralProperties().setExcludeEclipselinkOrm(Boolean.TRUE);
        EclipseLinkPersistenceUnitTests.assertTrue((boolean)eclipseLinkOrmResource.fileExists());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        EclipseLinkPersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef());
    }

    public void testMappingFileRefs() {
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        ListIterator mappingFileRefs = persistenceUnit.getMappingFileRefs().iterator();
        EclipseLinkPersistenceUnitTests.assertEquals((Object)persistenceUnit.getImpliedEclipseLinkMappingFileRef(), (Object)((MappingFileRef)mappingFileRefs.next()).getMappingFile().getParent());
        EclipseLinkPersistenceUnitTests.assertEquals((Object)persistenceUnit.getImpliedMappingFileRef(), (Object)((MappingFileRef)mappingFileRefs.next()).getMappingFile().getParent());
    }

    public void testMappingFileRefsSize() {
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkPersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.getMappingFileRefsSize());
    }

    public void testPersistentType() throws Exception {
        this.getJpaProject().setDiscoversAnnotatedClasses(false);
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.createTestEntity();
        EclipseLinkPersistenceUnitTests.assertFalse((boolean)this.getJpaProject().discoversAnnotatedClasses());
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.getJpaProject().setDiscoversAnnotatedClasses(false);
        XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        classRef.setJavaClass("test.AnnotationTestType");
        this.getXmlPersistenceUnit().getClasses().add((Object)classRef);
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("model.Foo"));
        EclipseLinkPersistenceUnitTests.assertEquals((Object)ormPersistentType, (Object)persistenceUnit.getPersistentType("model.Foo"));
        this.getXmlPersistenceUnit().getMappingFiles().remove(0);
        EclipseLinkPersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("model.Foo"));
    }

    public void testGetMappingFileRefsContaining() throws Exception {
        this.createOrmXmlFile(ORM2_XML_FILE_NAME);
        this.createOrmXmlFile(ORM3_XML_FILE_NAME);
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        Iterable mappingFileRefs = persistenceUnit.getMappingFileRefsContaining("test.AnnotationTestType");
        EclipseLinkPersistenceUnitTests.assertEquals((boolean)true, (boolean)IterableTools.isEmpty((Iterable)mappingFileRefs));
        OrmXml eclipselinkOrmXml = (OrmXml)((MappingFileRef)IterableTools.get((Iterable)persistenceUnit.getMappingFileRefs(), (int)0)).getMappingFile();
        OrmXml orm2Xml = (OrmXml)((MappingFileRef)IterableTools.get((Iterable)persistenceUnit.getMappingFileRefs(), (int)1)).getMappingFile();
        OrmXml orm3Xml = (OrmXml)((MappingFileRef)IterableTools.get((Iterable)persistenceUnit.getMappingFileRefs(), (int)2)).getMappingFile();
        OrmXml orm4Xml = (OrmXml)((MappingFileRef)IterableTools.get((Iterable)persistenceUnit.getMappingFileRefs(), (int)3)).getMappingFile();
        eclipselinkOrmXml.getRoot().addPersistentType("entity", "test.AnnotationTestType");
        mappingFileRefs = persistenceUnit.getMappingFileRefsContaining("test.AnnotationTestType");
        EclipseLinkPersistenceUnitTests.assertEquals((int)1, (int)IterableTools.size((Iterable)mappingFileRefs));
        EclipseLinkPersistenceUnitTests.assertEquals((Object)eclipselinkOrmXml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)0)).getMappingFile());
        orm2Xml.getRoot().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        mappingFileRefs = persistenceUnit.getMappingFileRefsContaining("test.AnnotationTestType");
        EclipseLinkPersistenceUnitTests.assertEquals((int)2, (int)IterableTools.size((Iterable)mappingFileRefs));
        EclipseLinkPersistenceUnitTests.assertEquals((Object)eclipselinkOrmXml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)0)).getMappingFile());
        EclipseLinkPersistenceUnitTests.assertEquals((Object)orm2Xml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)1)).getMappingFile());
        orm3Xml.getRoot().addPersistentType("embeddable", "test.AnnotationTestType");
        mappingFileRefs = persistenceUnit.getMappingFileRefsContaining("test.AnnotationTestType");
        EclipseLinkPersistenceUnitTests.assertEquals((int)3, (int)IterableTools.size((Iterable)mappingFileRefs));
        EclipseLinkPersistenceUnitTests.assertEquals((Object)eclipselinkOrmXml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)0)).getMappingFile());
        EclipseLinkPersistenceUnitTests.assertEquals((Object)orm2Xml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)1)).getMappingFile());
        EclipseLinkPersistenceUnitTests.assertEquals((Object)orm3Xml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)2)).getMappingFile());
        orm4Xml.getRoot().addPersistentType("entity", "test.AnnotationTestType");
        mappingFileRefs = persistenceUnit.getMappingFileRefsContaining("test.AnnotationTestType");
        EclipseLinkPersistenceUnitTests.assertEquals((int)4, (int)IterableTools.size((Iterable)mappingFileRefs));
        EclipseLinkPersistenceUnitTests.assertEquals((Object)eclipselinkOrmXml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)0)).getMappingFile());
        EclipseLinkPersistenceUnitTests.assertEquals((Object)orm2Xml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)1)).getMappingFile());
        EclipseLinkPersistenceUnitTests.assertEquals((Object)orm3Xml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)2)).getMappingFile());
        EclipseLinkPersistenceUnitTests.assertEquals((Object)orm4Xml, (Object)((MappingFileRef)IterableTools.get((Iterable)mappingFileRefs, (int)3)).getMappingFile());
    }
}

