/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaAttributeOverrideTests
extends ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "MY_ATTRIBUTE_OVERRIDE_NAME";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "MY_ATTRIBUTE_OVERRIDE_COLUMN_NAME";

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }
        });
    }

    private ICompilationUnit createTestEntityWithAttributeOverride() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@AttributeOverride(name=\"MY_ATTRIBUTE_OVERRIDE_NAME\", column=@Column(name=\"MY_ATTRIBUTE_OVERRIDE_COLUMN_NAME\"))");
            }
        });
    }

    private void createTestSubType() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public JavaAttributeOverrideTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithAttributeOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        SpecifiedAttributeOverride specifiedAttributeOverride = (SpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaAttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)specifiedAttributeOverride.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverride = (SpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)specifiedAttributeOverride.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithAttributeOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        SpecifiedAttributeOverride specifiedAttributeOverride = (SpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaAttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)specifiedAttributeOverride.getName());
        specifiedAttributeOverride.setName("FOO");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride");
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)attributeOverrideResource.getName());
    }

    public void testColumnGetName() throws Exception {
        this.createTestEntityWithAttributeOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        SpecifiedAttributeOverride specifiedAttributeOverride = (SpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        SpecifiedColumn column = specifiedAttributeOverride.getColumn();
        JavaAttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)column.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride");
        ColumnAnnotation columnResource = attributeOverrideResource.getColumn();
        columnResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        column = ((SpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).getColumn();
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)column.getName());
    }

    public void testColumnSetName() throws Exception {
        this.createTestEntityWithAttributeOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        SpecifiedAttributeOverride specifiedAttributeOverride = (SpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        SpecifiedColumn column = specifiedAttributeOverride.getColumn();
        JavaAttributeOverrideTests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)column.getName());
        column.setSpecifiedName("FOO");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride");
        ColumnAnnotation columnResource = attributeOverrideResource.getColumn();
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)columnResource.getName());
        column.setSpecifiedName(null);
        attributeOverrideResource = (AttributeOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride");
        JavaAttributeOverrideTests.assertNull((Object)attributeOverrideResource.getColumn());
        JavaAttributeOverrideTests.assertNotNull((Object)specifiedAttributeOverride.getColumn());
    }

    public void testColumnDefaultName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAttributeOverrideTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaAttributeOverrideTests.assertEquals((String)"id", (String)attributeOverride.getColumn().getDefaultName());
        JavaPersistentType mappedSuperclass = ((ClassRef)ListTools.list((Iterable)this.getPersistenceUnit().getSpecifiedClassRefs()).get(1)).getJavaPersistentType();
        BasicMapping basicMapping = (BasicMapping)mappedSuperclass.getAttributeNamed("id").getMapping();
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeOverride = (AttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)attributeOverride.getColumn().getDefaultName());
    }

    public void testColumnDefaultTableName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAttributeOverrideTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)attributeOverride.getColumn().getDefaultTableName());
        JavaPersistentType mappedSuperclass = ((ClassRef)ListTools.list((Iterable)this.getPersistenceUnit().getSpecifiedClassRefs()).get(1)).getJavaPersistentType();
        BasicMapping basicMapping = (BasicMapping)mappedSuperclass.getAttributeNamed("id").getMapping();
        basicMapping.getColumn().setSpecifiedTableName("BAR");
        attributeOverride = (AttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaAttributeOverrideTests.assertEquals((String)"BAR", (String)attributeOverride.getColumn().getDefaultTableName());
    }

    public void testDefaultName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAttributeOverrideTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaAttributeOverrideTests.assertEquals((String)"id", (String)attributeOverride.getName());
    }

    public void testIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        JavaAttributeOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAttributeOverrideTests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        AttributeOverride attributeOverride = (AttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaAttributeOverrideTests.assertTrue((boolean)attributeOverride.isVirtual());
    }

    public void testSetColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaVirtualAttributeOverride attributeOverride = (JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        attributeOverride.convertToSpecified().getColumn().setSpecifiedName("FOO");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride");
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)attributeOverrideResource.getColumn().getName());
        JavaAttributeOverrideTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).getColumn().getSpecifiedName());
    }
}

