/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.LobConverter;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.EnumType;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmBasicMappingTests
extends ContextModelTestCase {
    public OrmBasicMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.FetchType", "javax.persistence.Column", "javax.persistence.Lob", "javax.persistence.Temporal", "javax.persistence.TemporalType", "javax.persistence.Enumerated", "javax.persistence.EnumType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(fetch=FetchType.LAZY, optional=false)");
                sb.append(CR);
                sb.append("    @Column(name=\"MY_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\", length=5, precision=6, scale=7)");
                sb.append(CR);
                sb.append("    @Lob");
                sb.append(CR);
                sb.append("    @Temporal(TemporalType.TIMESTAMP)");
                sb.append(CR);
                sb.append("    @Enumerated(EnumType.STRING)");
            }
        });
    }

    public void testUpdateName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertEquals((String)"id", (String)basicResource.getName());
        basicResource.setName("newName");
        OrmBasicMappingTests.assertEquals((String)"newName", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertEquals((String)"newName", (String)basicResource.getName());
        basicResource.setName(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)basicResource.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertEquals((String)"id", (String)basicResource.getName());
        ormBasicMapping.setName("newName");
        OrmBasicMappingTests.assertEquals((String)"newName", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertEquals((String)"newName", (String)basicResource.getName());
        ormBasicMapping.setName(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)basicResource.getName());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)basicResource.getFetch());
        basicResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER);
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)basicResource.getFetch());
        basicResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY);
        OrmBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)basicResource.getFetch());
        basicResource.setFetch(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)basicResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)basicResource.getFetch());
        ormBasicMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)basicResource.getFetch());
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormBasicMapping.getSpecifiedFetch());
        ormBasicMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)basicResource.getFetch());
        OrmBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormBasicMapping.getSpecifiedFetch());
        ormBasicMapping.setSpecifiedFetch(null);
        OrmBasicMappingTests.assertNull((Object)basicResource.getFetch());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
    }

    public void testUpdateSpecifiedEnumerated() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getEnumerated());
        basicResource.setEnumerated(EnumType.ORDINAL);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormBasicMapping.getConverter()).getSpecifiedEnumType());
        OrmBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)basicResource.getEnumerated());
        basicResource.setEnumerated(EnumType.STRING);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((BaseEnumeratedConverter)ormBasicMapping.getConverter()).getSpecifiedEnumType());
        OrmBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)basicResource.getEnumerated());
        basicResource.setEnumerated(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getEnumerated());
    }

    public void testModifySpecifiedEnumerated() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getEnumerated());
        ormBasicMapping.setConverter(BaseEnumeratedConverter.class);
        ((BaseEnumeratedConverter)ormBasicMapping.getConverter()).setSpecifiedEnumType(org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL);
        OrmBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)basicResource.getEnumerated());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormBasicMapping.getConverter()).getSpecifiedEnumType());
        ((BaseEnumeratedConverter)ormBasicMapping.getConverter()).setSpecifiedEnumType(org.eclipse.jpt.jpa.core.context.EnumType.STRING);
        OrmBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)basicResource.getEnumerated());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((BaseEnumeratedConverter)ormBasicMapping.getConverter()).getSpecifiedEnumType());
        ormBasicMapping.setConverter(null);
        OrmBasicMappingTests.assertNull((Object)basicResource.getEnumerated());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertNull((Object)basicResource.getOptional());
        basicResource.setOptional(Boolean.TRUE);
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicResource.getOptional());
        basicResource.setOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicResource.getOptional());
        basicResource.setOptional(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertNull((Object)basicResource.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertNull((Object)basicResource.getOptional());
        ormBasicMapping.setSpecifiedOptional(Boolean.TRUE);
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicResource.getOptional());
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormBasicMapping.getSpecifiedOptional());
        ormBasicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicResource.getOptional());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormBasicMapping.getSpecifiedOptional());
        ormBasicMapping.setSpecifiedOptional(null);
        OrmBasicMappingTests.assertNull((Object)basicResource.getOptional());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
    }

    public void testUpdateSpecifiedLob() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertFalse((boolean)basicResource.isLob());
        basicResource.setLob(true);
        OrmBasicMappingTests.assertEquals(LobConverter.class, (Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertTrue((boolean)basicResource.isLob());
        basicResource.setLob(false);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertFalse((boolean)basicResource.isLob());
    }

    public void testModifySpecifiedLob() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertFalse((boolean)basicResource.isLob());
        ormBasicMapping.setConverter(LobConverter.class);
        OrmBasicMappingTests.assertTrue((boolean)basicResource.isLob());
        OrmBasicMappingTests.assertEquals(LobConverter.class, (Object)ormBasicMapping.getConverter().getConverterType());
        ormBasicMapping.setConverter(null);
        OrmBasicMappingTests.assertFalse((boolean)basicResource.isLob());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
    }

    public void testUpdateTemporal() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getTemporal());
        basicResource.setTemporal(TemporalType.DATE);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        OrmBasicMappingTests.assertEquals((Object)TemporalType.DATE, (Object)basicResource.getTemporal());
        basicResource.setTemporal(TemporalType.TIME);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        OrmBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)basicResource.getTemporal());
        basicResource.setTemporal(TemporalType.TIMESTAMP);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        OrmBasicMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)basicResource.getTemporal());
        basicResource.setTemporal(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getTemporal());
    }

    public void testModifyTemporal() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getTemporal());
        ormBasicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)ormBasicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        OrmBasicMappingTests.assertEquals((Object)TemporalType.DATE, (Object)basicResource.getTemporal());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        ((BaseTemporalConverter)ormBasicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)basicResource.getTemporal());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        ((BaseTemporalConverter)ormBasicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP);
        OrmBasicMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)basicResource.getTemporal());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        ormBasicMapping.setConverter(null);
        OrmBasicMappingTests.assertNull((Object)basicResource.getTemporal());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
    }

    public void testBasicMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setName("foo");
        OrmBasicMappingTests.assertEquals((String)"foo", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormBasicMapping.getFetch());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormBasicMapping.isOptional());
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmBasicMappingTests.assertEquals((String)"foo", (String)ormColumn.getDefaultName());
        OrmBasicMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmBasicMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmBasicMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTableName());
        OrmBasicMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmBasicMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmBasicMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmBasicMappingTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getName());
        OrmBasicMappingTests.assertEquals(BaseEnumeratedConverter.class, (Object)basicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((BaseEnumeratedConverter)basicMapping.getConverter()).getEnumType());
        OrmBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
        SpecifiedColumn column = basicMapping.getColumn();
        OrmBasicMappingTests.assertEquals((String)"MY_COLUMN", (String)column.getSpecifiedName());
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)column.getSpecifiedUnique());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedNullable());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedInsertable());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedUpdatable());
        OrmBasicMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)column.getColumnDefinition());
        OrmBasicMappingTests.assertEquals((String)"MY_TABLE", (String)column.getSpecifiedTableName());
        OrmBasicMappingTests.assertEquals((Object)5, (Object)column.getSpecifiedLength());
        OrmBasicMappingTests.assertEquals((Object)6, (Object)column.getSpecifiedPrecision());
        OrmBasicMappingTests.assertEquals((Object)7, (Object)column.getSpecifiedScale());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmBasicMappingTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)basicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)basicMapping.getFetch());
        OrmBasicMappingTests.assertTrue((boolean)basicMapping.isOptional());
        SpecifiedColumn column = basicMapping.getColumn();
        OrmBasicMappingTests.assertEquals((String)"id", (String)column.getName());
        OrmBasicMappingTests.assertFalse((boolean)column.isUnique());
        OrmBasicMappingTests.assertTrue((boolean)column.isNullable());
        OrmBasicMappingTests.assertTrue((boolean)column.isInsertable());
        OrmBasicMappingTests.assertTrue((boolean)column.isUpdatable());
        OrmBasicMappingTests.assertNull((Object)column.getColumnDefinition());
        OrmBasicMappingTests.assertEquals((String)"AnnotationTestType", (String)column.getTableName());
        OrmBasicMappingTests.assertEquals((int)255, (int)column.getLength());
        OrmBasicMappingTests.assertEquals((int)0, (int)column.getPrecision());
        OrmBasicMappingTests.assertEquals((int)0, (int)column.getScale());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getConverterType());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormBasicMapping.getDefaultFetch());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormBasicMapping.isDefaultOptional());
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormColumn.getDefaultName());
        OrmBasicMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmBasicMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmBasicMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTableName());
        OrmBasicMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmBasicMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmBasicMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
    }

    public void testBasicMorphToIdMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmBasicMappingTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testBasicMorphToVersionMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmBasicMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testBasicMorphToTransientMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToOneToOneMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToOneToManyMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToManyToOneMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToManyToManyMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }
}

