/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceIdAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceOneToOneAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.IdAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class JavaResourceAttributeTests
extends JpaJavaResourceModelTestCase {
    public JavaResourceAttributeTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonResolvingField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private Foo foo;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityMultipleVariableDeclarationsPerLine() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    ");
                sb.append("@Id");
                sb.append(CR);
                sb.append("    ");
                sb.append("@Column(name = \"baz\")");
                sb.append("    private String foo, bar;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdAndBasic() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append(CR);
                sb.append("@Basic");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append(CR);
                sb.append("    ");
                sb.append("@Column");
            }
        });
    }

    private ICompilationUnit createTestEntityWithColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(name = \"FOO\", table = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdColumnGeneratedValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Column", "javax.persistence.Id", "javax.persistence.GeneratedValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append(CR);
                sb.append("@Column");
                sb.append(CR);
                sb.append("@GeneratedValue");
            }
        });
    }

    private ICompilationUnit createTestEntityMultipleColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Column(name = \"FOO\")");
                sb.append(CR);
                sb.append("@Column(name = \"BAR\")");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWithAttributeOverride() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverride"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverride(name = \"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWithAttributeOverrides() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverrides(@AttributeOverride(name = \"FOO\"))");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWithAttributeOverridesEmpty() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverrides"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverrides()");
            }
        });
    }

    private ICompilationUnit createTestEmbeddedWith2AttributeOverrides() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded");
                sb.append(CR);
                sb.append("@AttributeOverrides({@AttributeOverride(name = \"FOO\"), @AttributeOverride(name = \"BAR\")})");
            }
        });
    }

    private ICompilationUnit createTestTypePublicAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("   public String foo;");
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypePackageAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("   String foo;");
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestTypeFinalAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("   public final String foo;");
                sb.append(CR);
            }
        });
    }

    public void testJavaAttributeAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertEquals((int)1, (int)resourceAttribute.getAnnotationsSize());
    }

    public void testJavaAttributeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Column"));
    }

    public void testJavaAttributeAnnotationNull() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Table"));
    }

    public void testDuplicateAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityMultipleColumns();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        ColumnAnnotation columnResource = (ColumnAnnotation)resourceAttribute.getAnnotation("javax.persistence.Column");
        JavaResourceAttributeTests.assertEquals((String)"FOO", (String)columnResource.getName());
    }

    public void testRemoveColumn() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        resourceAttribute.removeAnnotation("javax.persistence.Column");
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testRemoveColumnName() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        ColumnAnnotation columnResource = (ColumnAnnotation)resourceAttribute.getAnnotation("javax.persistence.Column");
        columnResource.setTable(null);
        this.assertSourceContains("@Column(name = \"FOO\")", cu);
        columnResource.setName(null);
        this.assertSourceDoesNotContain("(name", cu);
        this.assertSourceDoesNotContain("@Column(", cu);
    }

    public void testMultipleAttributeMappings() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithIdAndBasic();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertEquals((int)2, (int)resourceAttribute.getAnnotationsSize());
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Basic"));
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        Annotation javaAttributeMappingAnnotation = resourceAttribute.getAnnotation("javax.persistence.Basic");
        JavaResourceAttributeTests.assertTrue((boolean)(javaAttributeMappingAnnotation instanceof BasicAnnotation));
        this.assertSourceContains("@Basic", cu);
        this.assertSourceContains("@Id", cu);
        resourceAttribute.setPrimaryAnnotation("javax.persistence.OneToMany", EmptyIterable.instance());
        JavaResourceAttributeTests.assertEquals((int)1, (int)resourceAttribute.getAnnotationsSize());
        javaAttributeMappingAnnotation = resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        JavaResourceAttributeTests.assertTrue((boolean)(javaAttributeMappingAnnotation instanceof OneToManyAnnotation));
        this.assertSourceDoesNotContain("@Id", cu);
        this.assertSourceContains("@OneToMany", cu);
        this.assertSourceDoesNotContain("@Basic", cu);
    }

    public void testSetJavaAttributeMappingAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize());
        resourceAttribute.setPrimaryAnnotation("javax.persistence.Id", EmptyIterable.instance());
        JavaResourceAttributeTests.assertTrue((boolean)(resourceAttribute.getAnnotation("javax.persistence.Id") instanceof IdAnnotation));
        this.assertSourceContains("@Id", cu);
    }

    public void testSetJavaAttributeMappingAnnotation2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithColumn();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertEquals((int)1, (int)resourceAttribute.getAnnotationsSize());
        resourceAttribute.setPrimaryAnnotation("javax.persistence.Id", Collections.singleton("javax.persistence.Column"));
        JavaResourceAttributeTests.assertTrue((boolean)(resourceAttribute.getAnnotation("javax.persistence.Id") instanceof IdAnnotation));
        this.assertSourceContains("@Id", cu);
        this.assertSourceContains("@Column", cu);
    }

    public void testSetJavaAttributeMappingAnnotation3() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithIdColumnGeneratedValue();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertTrue((boolean)(resourceAttribute.getAnnotation("javax.persistence.Id") instanceof IdAnnotation));
        resourceAttribute.setPrimaryAnnotation("javax.persistence.Basic", Arrays.asList("javax.persistence.Column", "javax.persistence.GeneratedValue"));
        JavaResourceAttributeTests.assertTrue((boolean)(resourceAttribute.getAnnotation("javax.persistence.Basic") instanceof BasicAnnotation));
        this.assertSourceDoesNotContain("@Id", cu);
        this.assertSourceContains("@GeneratedValue", cu);
        this.assertSourceContains("@Column", cu);
    }

    public void testSetJavaAttributeMappingAnnotationNull() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithIdColumnGeneratedValue();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertTrue((boolean)(resourceAttribute.getAnnotation("javax.persistence.Id") instanceof IdAnnotation));
        resourceAttribute.setPrimaryAnnotation(null, Arrays.asList("javax.persistence.Column", "javax.persistence.GeneratedValue"));
        JavaResourceAttributeTests.assertEquals((int)2, (int)resourceAttribute.getAnnotationsSize());
        this.assertSourceDoesNotContain("@Id", cu);
        this.assertSourceContains("@GeneratedValue", cu);
        this.assertSourceContains("@Column", cu);
    }

    public void testAddJavaAttributeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        this.assertSourceDoesNotContain("@Column", cu);
        resourceAttribute.addAnnotation("javax.persistence.Column");
        this.assertSourceContains("@Column", cu);
    }

    public void testRemoveJavaAttributeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedField();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        this.assertSourceContains("@Column", cu);
        resourceAttribute.removeAnnotation("javax.persistence.Column");
        this.assertSourceDoesNotContain("@Column", cu);
    }

    public void testChangeAttributeMappingInSource() throws Exception {
        ICompilationUnit cu = this.createTestEntityAnnotatedField();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        this.idField(cu).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SourceIdAnnotation.DECLARATION_ANNOTATION_ADAPTER.removeAnnotation(declaration);
            }
        });
        cu.createImport("javax.persistence.OneToOne", null, (IProgressMonitor)new NullProgressMonitor());
        this.idField(cu).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SourceOneToOneAnnotation.DECLARATION_ANNOTATION_ADAPTER.newMarkerAnnotation(declaration);
            }
        });
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Column"));
        JavaResourceAttributeTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.OneToOne"));
        this.assertSourceContains("@Column", cu);
    }

    public void testJavaAttributeAnnotationsNestable() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverride();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertEquals((int)1, (int)resourceAttribute.getAnnotationsSize("javax.persistence.AttributeOverride"));
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceAttribute.getAnnotations("javax.persistence.AttributeOverride").iterator().next();
        JavaResourceAttributeTests.assertEquals((String)"FOO", (String)attributeOverride.getName());
    }

    public void testJavaAttributeAnnotationsNoNestable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testJavaAttributeAnnotationsContainerNoNestable() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverridesEmpty();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testAddJavaAttributeAnnotationNestableContainer() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceAttribute.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.assertSourceContains("@AttributeOverride(name = \"FOO\")", cu);
    }

    public void testAddJavaAttributeAnnotationNestableContainer2() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverride();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceAttribute.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({ @AttributeOverride(name = \"FOO\"), @AttributeOverride(name = \"BAR\") })", cu);
        JavaResourceAttributeTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getContainerAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.persistence.AttributeOverride"));
        JavaResourceAttributeTests.assertEquals((int)2, (int)resourceAttribute.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testAddJavaAttributeAnnotationNestableContainer3() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverrides();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceAttribute.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"FOO\"),@AttributeOverride(name = \"BAR\")})", cu);
        JavaResourceAttributeTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getContainerAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.persistence.AttributeOverride"));
        JavaResourceAttributeTests.assertEquals((int)2, (int)resourceAttribute.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testAddJavaAttributeAnnotationNestableContainer5() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverrides();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceAttribute.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"BAR\"),@AttributeOverride(name = \"FOO\")})", cu);
        JavaResourceAttributeTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.AttributeOverride"));
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getContainerAnnotation("javax.persistence.AttributeOverrides"));
        JavaResourceAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.persistence.AttributeOverride"));
        JavaResourceAttributeTests.assertEquals((int)2, (int)resourceAttribute.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testRemoveJavaAttributeAnnotationNestableContainer() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverride();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        resourceAttribute.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.assertSourceDoesNotContain("@AttributeOverride", cu);
    }

    public void testRemoveJavaAttributeAnnotationNestableContainer2() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWithAttributeOverrides();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        resourceAttribute.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.assertSourceDoesNotContain("@AttributeOverride(name = \"FOO\")", cu);
        this.assertSourceDoesNotContain("@AttributeOverrides", cu);
    }

    public void testRemoveJavaAttributeAnnotationIndex() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWith2AttributeOverrides();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        resourceAttribute.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.assertSourceDoesNotContain("@AttributeOverride(name = \"FOO\"", cu);
        this.assertSourceContains("@AttributeOverride(name = \"BAR\"", cu);
        this.assertSourceDoesNotContain("@AttributeOverrides", cu);
    }

    public void testRemoveJavaAttributeAnnotationIndex2() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWith2AttributeOverrides();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        AttributeOverrideAnnotation newAnnotation = (AttributeOverrideAnnotation)resourceAttribute.addAnnotation(2, "javax.persistence.AttributeOverride");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"FOO\"), @AttributeOverride(name = \"BAR\"),", cu);
        this.assertSourceContains("@AttributeOverride(name = \"BAZ\")})", cu);
        resourceAttribute.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"FOO\"), @AttributeOverride(name = \"BAZ\")})", cu);
    }

    public void testMoveJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWith2AttributeOverrides();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        AttributeOverrideAnnotation newAnnotation = (AttributeOverrideAnnotation)resourceAttribute.addAnnotation(2, "javax.persistence.AttributeOverride");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"FOO\"), @AttributeOverride(name = \"BAR\"),", cu);
        this.assertSourceContains("@AttributeOverride(name = \"BAZ\")})", cu);
        resourceAttribute.moveAnnotation(0, 2, "javax.persistence.AttributeOverride");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"BAZ\"), @AttributeOverride(name = \"FOO\"),", cu);
        this.assertSourceContains("@AttributeOverride(name = \"BAR\")})", cu);
    }

    public void testMoveJavaTypeAnnotation2() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddedWith2AttributeOverrides();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation newAnnotation = (AttributeOverrideAnnotation)resourceAttribute.addAnnotation(2, "javax.persistence.AttributeOverride");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"FOO\"), @AttributeOverride(name = \"BAR\"),", cu);
        this.assertSourceContains("@AttributeOverride(name = \"BAZ\")})", cu);
        resourceAttribute.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.assertSourceContains("@AttributeOverrides({@AttributeOverride(name = \"BAR\"), @AttributeOverride(name = \"FOO\"),", cu);
        this.assertSourceContains("@AttributeOverride(name = \"BAZ\")})", cu);
    }

    public void testGetTypeName() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithNonResolvingField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)resourceType.getFields().iterator().next();
        JavaResourceAttributeTests.assertEquals((String)"foo", (String)resourceAttribute.getName());
        JavaResourceAttributeTests.assertEquals((String)"test.Foo", (String)resourceAttribute.getTypeBinding().getQualifiedName());
        this.javaProjectTestHarness.createCompilationUnit("test", "Foo.java", "public class Foo {}");
        JavaResourceAttributeTests.assertEquals((String)"test.Foo", (String)resourceAttribute.getTypeBinding().getQualifiedName());
    }

    public void testMultipleVariableDeclarationsPerLine() throws Exception {
        ICompilationUnit cu = this.createTestEntityMultipleVariableDeclarationsPerLine();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttributeTests.assertEquals((int)4, (int)IterableTools.size((Iterable)typeResource.getFields()));
        Iterator fields = typeResource.getFields().iterator();
        JavaResourceField resourceField = (JavaResourceField)fields.next();
        ColumnAnnotation column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        JavaResourceAttributeTests.assertEquals((String)"baz", (String)column.getName());
        resourceField = (JavaResourceField)fields.next();
        column = (ColumnAnnotation)resourceField.getAnnotation("javax.persistence.Column");
        JavaResourceAttributeTests.assertEquals((String)"baz", (String)column.getName());
    }

    public void testIsPublic() throws Exception {
        ICompilationUnit cu = this.createTestTypePublicAttribute();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute attribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertTrue((boolean)Modifier.isPublic(attribute.getModifiers()));
    }

    public void testIsPublicFalse() throws Exception {
        ICompilationUnit cu = this.createTestTypePackageAttribute();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute attribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertFalse((boolean)Modifier.isPublic(attribute.getModifiers()));
    }

    public void testIsFinal() throws Exception {
        ICompilationUnit cu = this.createTestTypeFinalAttribute();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute attribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertTrue((boolean)Modifier.isFinal(attribute.getModifiers()));
    }

    public void testIsFinalFalse() throws Exception {
        ICompilationUnit cu = this.createTestTypePackageAttribute();
        JavaResourceType typeResource = this.buildJavaResourceType(cu);
        JavaResourceAttribute attribute = (JavaResourceAttribute)typeResource.getFields().iterator().next();
        JavaResourceAttributeTests.assertFalse((boolean)Modifier.isFinal(attribute.getModifiers()));
    }
}

