/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.batch.Main;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ModifyingResourceTests
extends AbstractJavaModelTests {
    public ModifyingResourceTests(String name) {
        super(name);
    }

    protected void assertElementDescendants(String message, String expected, IJavaScriptElement element) throws CoreException {
        String actual = this.expandAll(element);
        if (!expected.equals(actual)) {
            System.out.println(Util.displayString((String)actual, (int)4));
        }
        ModifyingResourceTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertStatus(String expected, IStatus status) {
        String actual = status.getMessage();
        if (!expected.equals(actual)) {
            System.out.print(Util.displayString((String)actual, (int)2));
            System.out.println(",");
        }
        ModifyingResourceTests.assertEquals((String)expected, (String)actual);
    }

    protected void assertStatus(String message, String expected, IStatus status) {
        String actual = status.getMessage();
        if (!expected.equals(actual)) {
            System.out.print(Util.displayString((String)actual, (int)2));
            System.out.println(",");
        }
        ModifyingResourceTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    public static void generateClassFile(String className, String javaSource) throws IOException {
        String cu = "d:/temp/" + className + ".js";
        Util.createFile((String)cu, (String)javaSource);
        Main.compile((String)(String.valueOf(cu) + " -d d:/temp -classpath " + System.getProperty("java.home") + "/lib/rt.jar"));
        FileInputStream input = new FileInputStream("d:/temp/" + className + ".class");
        try {
            System.out.println("{");
            byte[] buffer = new byte[80];
            int read = 0;
            while (read != -1) {
                read = input.read(buffer);
                if (read != -1) {
                    System.out.print("\t");
                }
                int i = 0;
                while (i < read) {
                    System.out.print(buffer[i]);
                    System.out.print(", ");
                    ++i;
                }
                if (read == -1) continue;
                System.out.println();
            }
            System.out.print("}");
        }
        finally {
            input.close();
        }
    }

    protected IFile createFile(String path, InputStream content) throws CoreException {
        IFile file = this.getFile(path);
        file.create(content, true, null);
        try {
            content.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    protected IFile createFile(String path, byte[] content) throws CoreException {
        return this.createFile(path, new ByteArrayInputStream(content));
    }

    protected IFile createFile(String path, String content) throws CoreException {
        return this.createFile(path, content.getBytes());
    }

    protected IFile createFile(String path, String content, String charsetName) throws CoreException, UnsupportedEncodingException {
        return this.createFile(path, content.getBytes(charsetName));
    }

    protected IFolder createFolder(String path) throws CoreException {
        return this.createFolder((IPath)new Path(path));
    }

    protected void deleteFile(String filePath) throws CoreException {
        this.deleteResource((IResource)this.getFile(filePath));
    }

    protected void deleteFolder(String folderPath) throws CoreException {
        this.deleteFolder((IPath)new Path(folderPath));
    }

    protected IFile editFile(String path, String content) throws CoreException {
        IFile file = this.getFile(path);
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes());
        file.setContents((InputStream)input, 1, null);
        return file;
    }

    protected String expandAll(IJavaScriptElement element) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        this.expandAll(element, 0, buffer);
        return buffer.toString();
    }

    private void expandAll(IJavaScriptElement element, int tab, StringBuffer buffer) throws CoreException {
        IJavaScriptElement[] children = null;
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            children = parent.getChildren();
        }
        ((JavaElement)element).toStringInfo(tab, buffer);
        if (children != null) {
            int i = 0;
            int length = children.length;
            while (i < length) {
                buffer.append("\n");
                this.expandAll(children[i], tab + 1, buffer);
                ++i;
            }
        }
    }

    protected void renameProject(String project, String newName) throws CoreException {
        this.getProject(project).move((IPath)new Path(newName), true, null);
    }

    protected IClassFile getClassFile(String path) {
        return (IClassFile)JavaScriptCore.create((IFile)this.getFile(path));
    }

    protected IFolder getFolder(String path) {
        return this.getFolder((IPath)new Path(path));
    }

    protected IPackageFragment getPackage(String path) {
        if (path.indexOf(47, 1) != -1) {
            IJavaScriptElement element = JavaScriptCore.create((IFolder)this.getFolder(path));
            if (element instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)element).getPackageFragment("");
            }
            return (IPackageFragment)element;
        }
        IProject project = this.getProject(path);
        return JavaScriptCore.create((IProject)project).getPackageFragmentRoot((IResource)project).getPackageFragment("");
    }

    protected IPackageFragmentRoot getPackageFragmentRoot(String path) {
        if (path.indexOf(47, 1) != -1) {
            if (path.endsWith(".jar")) {
                return (IPackageFragmentRoot)JavaScriptCore.create((IFile)this.getFile(path));
            }
            return (IPackageFragmentRoot)JavaScriptCore.create((IFolder)this.getFolder(path));
        }
        IProject project = this.getProject(path);
        return JavaScriptCore.create((IProject)project).getPackageFragmentRoot((IResource)project);
    }

    protected String getSortedByProjectDeltas() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = this.deltaListener.deltas.length;
        while (i < length) {
            IJavaScriptElementDelta[] projects = this.deltaListener.deltas[i].getAffectedChildren();
            int projectsLength = projects.length;
            Object[] sorted = new IJavaScriptElementDelta[projectsLength];
            System.arraycopy(projects, 0, sorted, 0, projectsLength);
            org.eclipse.wst.jsdt.internal.core.util.Util.sort((Object[])sorted, (Util.Comparer)new Util.Comparer(){

                public int compare(Object a, Object b) {
                    return a.toString().compareTo(b.toString());
                }
            });
            int j = 0;
            while (j < projectsLength) {
                buffer.append(sorted[j]);
                if (j != projectsLength - 1) {
                    buffer.append("\n");
                }
                ++j;
            }
            if (i != length - 1) {
                buffer.append("\n\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    protected void moveFile(String sourcePath, String destPath) throws CoreException {
        this.getFile(sourcePath).move(this.getFile(destPath).getFullPath(), false, null);
    }

    protected void moveFolder(String sourcePath, String destPath) throws CoreException {
        this.getFolder(sourcePath).move(this.getFolder(destPath).getFullPath(), false, null);
    }

    protected void swapFiles(String firstPath, String secondPath) throws CoreException {
        final IFile first = this.getFile(firstPath);
        final IFile second = this.getFile(secondPath);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IPath tempPath = first.getParent().getFullPath().append("swappingFile.temp");
                first.move(tempPath, false, monitor);
                second.move(first.getFullPath(), false, monitor);
                ModifyingResourceTests.this.getWorkspaceRoot().getFile(tempPath).move(second.getFullPath(), false, monitor);
            }
        };
        this.getWorkspace().run(runnable, null);
    }

    protected IClassFile createClassFile(String libPath, String classFileRelativePath, String contents) throws CoreException {
        IClassFile classFile = this.getClassFile(String.valueOf(libPath) + "/" + classFileRelativePath);
        Util.delete((IResource)classFile.getResource());
        IJavaScriptProject javaProject = classFile.getJavaScriptProject();
        IProject project = javaProject.getProject();
        String sourcePath = String.valueOf(project.getLocation().toOSString()) + File.separatorChar + classFile.getType().getElementName() + ".js";
        String libOSPath = new Path(libPath).segmentCount() > 1 ? this.getFolder(libPath).getLocation().toOSString() : this.getProject(libPath).getLocation().toOSString();
        Util.compile((String[])new String[]{sourcePath, contents}, (Map)javaProject.getOptions(true), (String)libOSPath);
        project.refreshLocal(2, null);
        return classFile;
    }

    protected IIncludePathEntry[] createClasspath(String[] foldersAndPatterns, boolean hasInclusionPatterns, boolean hasExclusionPatterns) {
        int length = foldersAndPatterns.length;
        int increment = 1;
        if (hasInclusionPatterns) {
            ++increment;
        }
        if (hasExclusionPatterns) {
            ++increment;
        }
        IIncludePathEntry[] classpath = new IIncludePathEntry[length / increment];
        int i = 0;
        while (i < length) {
            String src = foldersAndPatterns[i];
            IPath[] accessibleFiles = new IPath[]{};
            if (hasInclusionPatterns) {
                String patterns = foldersAndPatterns[i + 1];
                StringTokenizer tokenizer = new StringTokenizer(patterns, "|");
                int patternsCount = tokenizer.countTokens();
                accessibleFiles = new IPath[patternsCount];
                int j = 0;
                while (j < patternsCount) {
                    accessibleFiles[j] = new Path(tokenizer.nextToken());
                    ++j;
                }
            }
            IPath[] nonAccessibleFiles = new IPath[]{};
            if (hasExclusionPatterns) {
                String patterns = foldersAndPatterns[i + increment - 1];
                StringTokenizer tokenizer = new StringTokenizer(patterns, "|");
                int patternsCount = tokenizer.countTokens();
                nonAccessibleFiles = new IPath[patternsCount];
                int j = 0;
                while (j < patternsCount) {
                    nonAccessibleFiles[j] = new Path(tokenizer.nextToken());
                    ++j;
                }
            }
            Path folderPath = new Path(src);
            classpath[i / increment] = JavaScriptCore.newSourceEntry((IPath)folderPath, (IPath[])accessibleFiles, (IPath[])nonAccessibleFiles, null);
            i += increment;
        }
        return classpath;
    }

    protected IIncludePathEntry[] createClasspath(String projectName, String[] foldersAndPatterns) {
        int length = foldersAndPatterns.length;
        IIncludePathEntry[] classpath = new IIncludePathEntry[length / 2];
        int i = 0;
        while (i < length) {
            String src = foldersAndPatterns[i];
            String patterns = foldersAndPatterns[i + 1];
            classpath[i / 2] = this.createSourceEntry(projectName, src, patterns);
            i += 2;
        }
        return classpath;
    }

    public IIncludePathEntry createSourceEntry(String referingProjectName, String src, String patterns) {
        StringTokenizer tokenizer = new StringTokenizer(patterns, "|");
        int ruleCount = tokenizer.countTokens();
        IAccessRule[] accessRules = new IAccessRule[ruleCount];
        int nonAccessibleRules = 0;
        int j = 0;
        while (j < ruleCount) {
            int kind;
            String rule = tokenizer.nextToken();
            boolean ignoreIfBetter = false;
            switch (rule.charAt(0)) {
                case '+': {
                    kind = 0;
                    break;
                }
                case '~': {
                    kind = 2;
                    break;
                }
                case '?': {
                    kind = 1;
                    ignoreIfBetter = true;
                    break;
                }
                default: {
                    kind = 1;
                }
            }
            ++nonAccessibleRules;
            accessRules[j] = JavaScriptCore.newAccessRule((IPath)new Path(rule.substring(1)), (int)(ignoreIfBetter ? kind | 0x100 : kind));
            ++j;
        }
        Path folderPath = new Path(src);
        if (referingProjectName != null && folderPath.segmentCount() == 1 && !referingProjectName.equals(folderPath.lastSegment())) {
            return JavaScriptCore.newProjectEntry((IPath)folderPath, (IAccessRule[])accessRules, (boolean)true, (IIncludePathAttribute[])new IIncludePathAttribute[0], (boolean)false);
        }
        IPath[] accessibleFiles = new IPath[ruleCount - nonAccessibleRules];
        int accessibleIndex = 0;
        IPath[] nonAccessibleFiles = new IPath[nonAccessibleRules];
        int nonAccessibleIndex = 0;
        int j2 = 0;
        while (j2 < ruleCount) {
            IAccessRule accessRule = accessRules[j2];
            if (accessRule.getKind() == 0) {
                accessibleFiles[accessibleIndex++] = accessRule.getPattern();
            } else {
                nonAccessibleFiles[nonAccessibleIndex++] = accessRule.getPattern();
            }
            ++j2;
        }
        return JavaScriptCore.newSourceEntry((IPath)folderPath, (IPath[])accessibleFiles, (IPath[])nonAccessibleFiles, null);
    }
}

