/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class ProposalInfoTest
extends TestCase {
    private static final String TEST_NAME = "Test JavaScript Content Assist Proposal Info";
    private static TestProjectSetup fTestProjectSetup;

    public ProposalInfoTest() {
        super(TEST_NAME);
    }

    public ProposalInfoTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(ProposalInfoTest.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false);
        return fTestProjectSetup;
    }

    public void testProposalInfo_OtherFile_BeforeOpen_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello World", "State"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 0, 0, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_OtherFile_BeforeOpen_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City)  - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello World", "State"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 2, 3, expectedProposals, expectedInfo);
    }

    public void _testProposalInfo_OtherFile_BeforeOpen_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"nodeOne : String - Global"}};
        String[][] expectedInfo = new String[][]{{"nodeOne = test"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 4, 3, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_ThisFile_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello World", "State"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_0.js", 0, 0, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_ThisFile_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello World", "State"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_0.js", 15, 3, expectedProposals, expectedInfo);
    }

    public void _testProposalInfo_ThisFile_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"nodeOne : String - Global"}};
        String[][] expectedInfo = new String[][]{{"nodeOne = test"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_0.js", 22, 3, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_OtherFile_AfterOpen_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello World", "City"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 0, 0, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_OtherFile_AfterOpen_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello World", "State"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 2, 3, expectedProposals, expectedInfo);
    }

    public void _testProposalInfo_OtherFile_AfterOpen_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"nodeOne : String - Global"}};
        String[][] expectedInfo = new String[][]{{"nodeOne = test"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 4, 3, expectedProposals, expectedInfo);
    }
}

