/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.projects;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.internal.utility.CallbackSynchronousSynchronizer;
import org.eclipse.jpt.jaxb.core.internal.utility.SynchronousSynchronizer;
import org.eclipse.jpt.jaxb.core.utility.CallbackSynchronizer;
import org.eclipse.jpt.jaxb.core.utility.Synchronizer;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JaxbProjectTestHarness
extends JavaProjectTestHarness {
    private final JaxbProject jaxbProject;
    public static final String JAXB_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.jaxb.jar";
    public static final String ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.eclipselink.jar";

    public static String jaxbJarName() {
        return JaxbProjectTestHarness.getSystemProperty(JAXB_JAR_NAME_SYSTEM_PROPERTY);
    }

    public static String eclipseLinkJarName() {
        return JaxbProjectTestHarness.getSystemProperty(ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY);
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public static JaxbProjectTestHarness buildJaxbProjectTestHarness(String baseProjectName, boolean autoBuild, IDataModel config) throws CoreException {
        return new JaxbProjectTestHarness(baseProjectName, autoBuild, config);
    }

    public JaxbProjectTestHarness(String projectName) throws CoreException {
        this(projectName, false);
    }

    public JaxbProjectTestHarness(String projectName, boolean autoBuild) throws CoreException {
        this(projectName, autoBuild, null);
    }

    public JaxbProjectTestHarness(String projectName, boolean autoBuild, IDataModel config) throws CoreException {
        super(projectName, autoBuild);
        String jaxbFacetVersion = ((IProjectFacetVersion)config.getProperty("IFacetDataModelPropeties.FACET_VERSION")).getVersionString();
        this.installFacet("jpt.jaxb", jaxbFacetVersion, config);
        String jaxbJarName = JaxbProjectTestHarness.jaxbJarName();
        this.addJar(jaxbJarName);
        String eclipseLinkJarName = JaxbProjectTestHarness.eclipseLinkJarName();
        if (eclipseLinkJarName != null && !eclipseLinkJarName.equals(jaxbJarName)) {
            this.addJar(eclipseLinkJarName);
        }
        this.jaxbProject = this.getJaxbProjectManager().getJaxbProject(this.getProject());
        this.jaxbProject.setContextModelSynchronizer(this.buildSynchronousContextModelSynchronizer());
        this.jaxbProject.setUpdateSynchronizer(this.buildSynchronousUpdateSynchronizer());
    }

    private JaxbProjectManager getJaxbProjectManager() {
        return this.getJaxbWorkspace().getJaxbProjectManager();
    }

    private JaxbWorkspace getJaxbWorkspace() {
        return (JaxbWorkspace)ResourcesPlugin.getWorkspace().getAdapter(JaxbWorkspace.class);
    }

    protected Synchronizer buildSynchronousContextModelSynchronizer() {
        return new SynchronousSynchronizer(this.buildSynchronousContextModelSynchronizerCommand());
    }

    protected Command buildSynchronousContextModelSynchronizerCommand() {
        return new SynchronousContextModelSynchronizerCommand();
    }

    protected CallbackSynchronizer buildSynchronousUpdateSynchronizer() {
        return new CallbackSynchronousSynchronizer(this.buildSynchronousUpdateSynchronizerCommand());
    }

    protected Command buildSynchronousUpdateSynchronizerCommand() {
        return new SynchronousUpdateSynchronizerCommand();
    }

    public JaxbProject getJaxbProject() {
        return this.jaxbProject;
    }

    protected class SynchronousContextModelSynchronizerCommand
    implements Command {
        protected SynchronousContextModelSynchronizerCommand() {
        }

        public void execute() {
            JaxbProjectTestHarness.this.jaxbProject.synchronizeContextModel((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected class SynchronousUpdateSynchronizerCommand
    implements Command {
        protected SynchronousUpdateSynchronizerCommand() {
        }

        public void execute() {
            JaxbProjectTestHarness.this.jaxbProject.update((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

