/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.WorkbenchMessages;

public final class TextTransferHandler {
    private MenuItem copyMenuItem;
    private MenuItem cutMenuItem;
    private MenuItem deleteMenuItem;
    private MenuItem pasteMenuItem;
    private Menu popup;
    private MenuItem selectAllMenuItem;
    private StyledText styledText;
    private IUndoManager undoManager;
    private MenuItem undoMenuItem;

    private TextTransferHandler(StyledText styledText, IUndoManager undoManager) {
        this.styledText = styledText;
        this.undoManager = undoManager;
    }

    public static void installContextMenu(StyledText styledText, IUndoManager undoManager) {
        TextTransferHandler handler = new TextTransferHandler(styledText, undoManager);
        handler.installPopup();
    }

    private SelectionAdapter buildCopySelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTransferHandler.this.styledText.copy();
            }
        };
    }

    private SelectionListener buildCutSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTransferHandler.this.styledText.cut();
            }
        };
    }

    private SelectionListener buildDeleteSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point selection = TextTransferHandler.this.styledText.getSelection();
                TextTransferHandler.this.styledText.replaceTextRange(selection.x, selection.y - selection.x, "");
            }
        };
    }

    private MenuListener buildMenuListener() {
        return new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                TextTransferHandler.this.update();
            }
        };
    }

    private SelectionListener buildPasteSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTransferHandler.this.styledText.paste();
            }
        };
    }

    private SelectionListener buildSelectAllSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTransferHandler.this.styledText.selectAll();
            }
        };
    }

    private SelectionListener buildUndoSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTransferHandler.this.undoManager.undo();
            }
        };
    }

    private boolean canCopy() {
        Point selection = this.styledText.getSelection();
        return selection.x != selection.y;
    }

    private boolean canCut() {
        Point selection = this.styledText.getSelection();
        return selection.x != selection.y;
    }

    private boolean canDelete() {
        Point selection = this.styledText.getSelection();
        return selection.x != selection.y;
    }

    private boolean canPaste() {
        Clipboard clipboard = new Clipboard(this.styledText.getDisplay());
        boolean canPaste = false;
        TransferData[] transferDataArray = clipboard.getAvailableTypes();
        int n = transferDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData data = transferDataArray[n2];
            if (TextTransfer.getInstance().isSupportedType(data)) {
                canPaste = true;
                break;
            }
            ++n2;
        }
        clipboard.dispose();
        return canPaste;
    }

    private boolean canSelectAll() {
        Point selection = this.styledText.getSelection();
        String text = this.styledText.getText();
        return selection.y - selection.x != text.length();
    }

    private void installPopup() {
        this.popup = new Menu((Decorations)this.styledText.getShell(), 8);
        this.popup.addMenuListener(this.buildMenuListener());
        this.styledText.setMenu(this.popup);
        this.populatePopup();
    }

    private void populatePopup() {
        this.undoMenuItem = new MenuItem(this.popup, 8);
        this.undoMenuItem.setText(WorkbenchMessages.Workbench_undo);
        this.undoMenuItem.addSelectionListener(this.buildUndoSelectionListener());
        new MenuItem(this.popup, 2);
        this.cutMenuItem = new MenuItem(this.popup, 8);
        this.cutMenuItem.setText(WorkbenchMessages.Workbench_cut);
        this.cutMenuItem.addSelectionListener(this.buildCutSelectionListener());
        this.copyMenuItem = new MenuItem(this.popup, 8);
        this.copyMenuItem.setText(WorkbenchMessages.Workbench_copy);
        this.copyMenuItem.addSelectionListener((SelectionListener)this.buildCopySelectionListener());
        this.pasteMenuItem = new MenuItem(this.popup, 8);
        this.pasteMenuItem.setText(WorkbenchMessages.Workbench_paste);
        this.pasteMenuItem.addSelectionListener(this.buildPasteSelectionListener());
        this.deleteMenuItem = new MenuItem(this.popup, 8);
        this.deleteMenuItem.setText(WorkbenchMessages.Workbench_delete);
        this.deleteMenuItem.addSelectionListener(this.buildDeleteSelectionListener());
        new MenuItem(this.popup, 2);
        this.selectAllMenuItem = new MenuItem(this.popup, 8);
        this.selectAllMenuItem.setText(WorkbenchMessages.Workbench_selectAll);
        this.selectAllMenuItem.addSelectionListener(this.buildSelectAllSelectionListener());
    }

    private void update() {
        this.deleteMenuItem.setEnabled(this.canDelete());
        this.copyMenuItem.setEnabled(this.canCopy());
        this.cutMenuItem.setEnabled(this.canCut());
        this.pasteMenuItem.setEnabled(this.canPaste());
        this.selectAllMenuItem.setEnabled(this.canSelectAll());
        this.undoMenuItem.setEnabled(this.undoManager.undoable());
    }
}

