/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.chromium.Browser;
import org.eclipse.wst.jsdt.chromium.debug.core.model.TabSelector;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WipTabSelector;
import org.eclipse.wst.jsdt.chromium.debug.ui.ChromiumTabSelectionDialog;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.eclipse.wst.jsdt.chromium.wip.WipBackend;
import org.eclipse.wst.jsdt.chromium.wip.WipBrowser;

public class DialogBasedTabSelector {
    public static TabSelector INSTANCE = new Impl();
    public static WipTabSelector WIP_INSTANCE = new Wip();

    private static abstract class Base<CONNECTOR, SOURCE> {
        private Base() {
        }

        public CONNECTOR selectTab(SOURCE tabFetcher) throws IOException {
            List<CONNECTOR> allTabs = this.getTabs(tabFetcher);
            ArrayList<CONNECTOR> filteredTabs = new ArrayList<CONNECTOR>(allTabs.size());
            for (CONNECTOR tab : allTabs) {
                if (this.isAttached(tab)) continue;
                filteredTabs.add(tab);
            }
            if (this.autoSelectSingleTab() && allTabs.size() == 1 && filteredTabs.size() == 1) {
                return allTabs.get(0);
            }
            final HashMap map = new HashMap();
            final ArrayList<String> urls = new ArrayList<String>(filteredTabs.size());
            int i = 0;
            while (i < filteredTabs.size()) {
                Object connector = filteredTabs.get(i);
                map.put(i, connector);
                urls.add(this.getUrl(connector));
                ++i;
            }
            final ArrayList result = new ArrayList(1);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ChromiumTabSelectionDialog dialog = new ChromiumTabSelectionDialog(shell, urls);
                    dialog.setBlockOnOpen(true);
                    int dialogResult = dialog.open();
                    if (dialogResult == 0) {
                        result.add(BasicUtil.getSafe((Map)map, (Object)dialog.getSelectedLine()));
                    }
                }
            });
            if (result.isEmpty()) {
                return null;
            }
            return (CONNECTOR)result.get(0);
        }

        protected abstract List<? extends CONNECTOR> getTabs(SOURCE var1) throws IOException;

        protected abstract boolean isAttached(CONNECTOR var1);

        protected abstract String getUrl(CONNECTOR var1);

        private boolean autoSelectSingleTab() {
            return true;
        }
    }

    private static class Impl
    extends Base<Browser.TabConnector, Browser.TabFetcher>
    implements TabSelector {
        private Impl() {
        }

        @Override
        protected List<? extends Browser.TabConnector> getTabs(Browser.TabFetcher tabFetcher) throws IOException {
            return tabFetcher.getTabs();
        }

        @Override
        protected boolean isAttached(Browser.TabConnector connector) {
            return connector.isAlreadyAttached();
        }

        @Override
        protected String getUrl(Browser.TabConnector connector) {
            return connector.getUrl();
        }
    }

    private static class Wip
    extends Base<WipBrowser.WipTabConnector, WipTabSelector.BrowserAndBackend>
    implements WipTabSelector {
        private Wip() {
        }

        @Override
        protected List<? extends WipBrowser.WipTabConnector> getTabs(WipTabSelector.BrowserAndBackend browserAndBackend) throws IOException {
            WipBrowser browser = browserAndBackend.getBrowser();
            WipBackend backend = browserAndBackend.getBackend();
            return browser.getTabs(backend);
        }

        @Override
        protected boolean isAttached(WipBrowser.WipTabConnector connector) {
            return connector.isAlreadyAttached();
        }

        @Override
        protected String getUrl(WipBrowser.WipTabConnector connector) {
            return connector.getUrl();
        }
    }
}

