/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.EnumValueCondition;
import org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator.JavaFileUpdater;
import org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator.WipMetamodel;

class Generator {
    private static final String ROOT_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.wip.protocol";
    private static final String OUTPUT_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output";
    private static final String INPUT_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input";
    private static final String COMMON_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.common";
    private static final String PARSER_INTERFACE_LIST_CLASS_NAME = "GeneratedParserInterfaceList";
    private static final String PARSER_ROOT_INTERFACE_NAME = "WipGeneratedParserRoot";
    private final List<String> jsonProtocolParserClassNames = new ArrayList<String>();
    private final List<ParserRootInterfaceItem> parserRootInterfaceItems = new ArrayList<ParserRootInterfaceItem>();
    private final TypeMap typeMap = new TypeMap();
    private final String originReference;
    private final FileSet fileSet;
    private static final String[] DOMAIN_WHITE_LIST = new String[]{"Debugger", "Runtime", "Page", "Network", "Console", "DOM", "Security"};
    private static final Set<String> BAD_METHOD_NAMES = new HashSet<String>(Arrays.asList("this"));

    Generator(String outputDir, String originReference) {
        this.originReference = originReference;
        this.fileSet = new FileSet(new File(outputDir));
    }

    void go(WipMetamodel.Root metamodel) throws IOException {
        List<WipMetamodel.Domain> domainList = metamodel.domains();
        Generator.initializeKnownTypes(this.typeMap);
        HashSet<String> domainTodoList = new HashSet<String>(Arrays.asList(DOMAIN_WHITE_LIST));
        HashMap<String, DomainGenerator> domainGeneratorMap = new HashMap<String, DomainGenerator>();
        for (WipMetamodel.Domain domain : domainList) {
            boolean found = domainTodoList.remove(domain.domain());
            if (!found) {
                System.out.println("Domain skipped: " + domain.domain());
                continue;
            }
            DomainGenerator domainGenerator = new DomainGenerator(domain);
            domainGeneratorMap.put(domain.domain(), domainGenerator);
            domainGenerator.registerTypes();
        }
        this.typeMap.setDomainGeneratorMap(domainGeneratorMap);
        if (!domainTodoList.isEmpty()) {
            throw new RuntimeException("Domains expected but not found: " + domainTodoList);
        }
        for (DomainGenerator domainGenerator : domainGeneratorMap.values()) {
            domainGenerator.generateCommandsAndEvents();
        }
        this.typeMap.generateRequestedTypes();
        this.generateParserInterfaceList();
        this.generateParserRoot(this.parserRootInterfaceItems);
        this.fileSet.deleteOtherFiles();
    }

    <T> QualifiedTypeData resolveType(final T typedObject, final TypedObjectAccess<T> access, final ResolveAndGenerateScope scope) {
        UnqualifiedTypeData unqualifiedType = Generator.switchByType(typedObject, access, new TypeVisitor<UnqualifiedTypeData>(){

            @Override
            public UnqualifiedTypeData visitRef(String refName) {
                BoxableType typeRef = Generator.this.resolveRefType(scope.getDomainName(), refName, scope.getTypeDirection());
                return new UnqualifiedTypeData(typeRef);
            }

            @Override
            public UnqualifiedTypeData visitBoolean() {
                return UnqualifiedTypeData.BOOLEAN;
            }

            @Override
            public UnqualifiedTypeData visitEnum(List<String> enumConstants) {
                BoxableType enumName = scope.generateEnum(this.getDescription(), enumConstants);
                return new UnqualifiedTypeData(enumName);
            }

            @Override
            public UnqualifiedTypeData visitString() {
                return UnqualifiedTypeData.STRING;
            }

            @Override
            public UnqualifiedTypeData visitInteger() {
                return UnqualifiedTypeData.LONG;
            }

            @Override
            public UnqualifiedTypeData visitNumber() {
                return UnqualifiedTypeData.NUMBER;
            }

            @Override
            public UnqualifiedTypeData visitArray(WipMetamodel.ArrayItemType items) {
                QualifiedTypeData itemQualifiedType = scope.resolveType(items, TypedObjectAccess.FOR_ARRAY_ITEM);
                return new UnqualifiedTypeData(BoxableType.createList(itemQualifiedType.getJavaType()));
            }

            @Override
            public UnqualifiedTypeData visitObject(List<WipMetamodel.ObjectProperty> properties) {
                BoxableType nestedObjectName;
                try {
                    nestedObjectName = scope.generateNestedObject(this.getDescription(), properties);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new UnqualifiedTypeData(nestedObjectName, false);
            }

            @Override
            public UnqualifiedTypeData visitUnknown() {
                return UnqualifiedTypeData.ANY;
            }

            private <S> String getDescription() {
                return access.getDescription(typedObject);
            }
        });
        return unqualifiedType.getQualifiedType(access.getOptional(typedObject) == Boolean.TRUE);
    }

    private void generateParserInterfaceList() throws IOException {
        JavaFileUpdater fileUpdater = this.startJavaFile(INPUT_PACKAGE, "GeneratedParserInterfaceList.java");
        Collections.sort(this.jsonProtocolParserClassNames);
        Writer writer = fileUpdater.getWriter();
        writer.write("public class GeneratedParserInterfaceList {\n");
        writer.write("  public static final Class<?>[] LIST = {\n");
        for (String name : this.jsonProtocolParserClassNames) {
            writer.write("    " + name + ".class" + ",\n");
        }
        writer.write("  };\n");
        writer.write("}\n");
        fileUpdater.update();
    }

    private void generateParserRoot(List<ParserRootInterfaceItem> parserRootInterfaceItems) throws IOException {
        JavaFileUpdater fileUpdater = this.startJavaFile(INPUT_PACKAGE, "WipGeneratedParserRoot.java");
        Collections.sort(parserRootInterfaceItems);
        Writer writer = fileUpdater.getWriter();
        writer.write("@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParserRoot\n");
        writer.write("public interface WipGeneratedParserRoot {\n");
        for (ParserRootInterfaceItem item : parserRootInterfaceItems) {
            item.writeCode(writer);
        }
        writer.write("}\n");
        fileUpdater.update();
    }

    private BoxableType resolveRefType(String scopeDomainName, String refName, TypeData.Direction direction) {
        String shortName;
        String domainName;
        int pos = refName.indexOf(46);
        if (pos == -1) {
            domainName = scopeDomainName;
            shortName = refName;
        } else {
            domainName = refName.substring(0, pos);
            shortName = refName.substring(pos + 1);
        }
        return this.typeMap.resolve(domainName, shortName, direction);
    }

    private String generateMethodNameSubstitute(String originalName, IndentWriter output) throws IOException {
        if (!BAD_METHOD_NAMES.contains(originalName)) {
            return originalName;
        }
        output.append("\t  @org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonField(jsonLiteralName=\"" + originalName + "\")\n");
        return "get" + Character.toUpperCase(originalName.charAt(0)) + originalName.substring(1);
    }

    private static String capitalizeFirstChar(String str) {
        if (Character.isLowerCase(str.charAt(0))) {
            str = String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
        }
        return str;
    }

    private JavaFileUpdater startJavaFile(ClassNameScheme nameScheme, WipMetamodel.Domain domain, String baseName) throws IOException {
        String packageName = nameScheme.getPackageNameVirtual(domain.domain());
        String fileName = String.valueOf(nameScheme.getShortName(baseName)) + ".java";
        return this.startJavaFile(packageName, fileName);
    }

    private JavaFileUpdater startJavaFile(String packageName, String filename) throws IOException {
        String filePath = packageName.replace('.', '/');
        JavaFileUpdater fileUpdater = this.fileSet.createFileUpdater(String.valueOf(filePath) + "/" + filename);
        Writer writer = fileUpdater.getWriter();
        writer.write("// Generated source.\n");
        writer.write("// Generator: " + this.getClass().getCanonicalName() + "\n");
        writer.write("// Origin: " + this.originReference + "\n\n");
        writer.write("package " + packageName + ";\n\n");
        return fileUpdater;
    }

    private static <R, T> R switchByType(T typedObject, TypedObjectAccess<T> access, TypeVisitor<R> visitor) {
        String refName = access.getRef(typedObject);
        if (refName != null) {
            return visitor.visitRef(refName);
        }
        String typeName = access.getType(typedObject);
        if ("boolean".equals(typeName)) {
            return visitor.visitBoolean();
        }
        if ("string".equals(typeName)) {
            if (access.getEnum(typedObject) != null) {
                return visitor.visitEnum(access.getEnum(typedObject));
            }
            return visitor.visitString();
        }
        if ("integer".equals(typeName)) {
            return visitor.visitInteger();
        }
        if ("number".equals(typeName)) {
            return visitor.visitNumber();
        }
        if ("array".equals(typeName)) {
            return visitor.visitArray(access.getItems(typedObject));
        }
        if ("object".equals(typeName)) {
            return visitor.visitObject(access.getProperties(typedObject));
        }
        if ("any".equals(typeName)) {
            return visitor.visitUnknown();
        }
        if ("unknown".equals(typeName)) {
            return visitor.visitUnknown();
        }
        throw new RuntimeException("Unrecognized type " + typeName);
    }

    private static void initializeKnownTypes(TypeMap typeMap) {
    }

    private static abstract class BoxableType {
        static final BoxableType STRING = BoxableType.createReference(new NamePath("String"));
        static final BoxableType OBJECT = BoxableType.createReference(new NamePath("Object"));
        static final BoxableType NUMBER = BoxableType.createReference(new NamePath("Number"));
        static final BoxableType LONG = BoxableType.create("Long", "long");
        static final BoxableType BOOLEAN = BoxableType.create("Boolean", "boolean");

        private BoxableType() {
        }

        public static BoxableType create(String boxed, String unboxed) {
            return new Base(boxed, unboxed);
        }

        public static BoxableType createReference(NamePath namePath) {
            return new Reference(namePath);
        }

        public static BoxableType createList(BoxableType itemType) {
            return new ListType(itemType.convertToPureReference());
        }

        abstract String getFullText();

        abstract String getShortText(NamePath var1);

        abstract BoxableType convertToPureReference();

        private static class Base
        extends BoxableType {
            private final NamePath boxed;
            private final String unboxed;

            private Base(String boxed, String unboxed) {
                this.boxed = new NamePath(boxed);
                this.unboxed = unboxed;
            }

            @Override
            String getFullText() {
                return this.unboxed;
            }

            @Override
            String getShortText(NamePath contextNamespace) {
                return this.getFullText();
            }

            @Override
            BoxableType convertToPureReference() {
                return new Reference(this.boxed);
            }
        }

        private static class ListType
        extends BoxableType {
            private final BoxableType itemType;

            public ListType(BoxableType itemType) {
                this.itemType = itemType;
            }

            @Override
            String getFullText() {
                return "java.util.List<" + this.itemType.getFullText() + ">";
            }

            @Override
            String getShortText(NamePath contextNamespace) {
                return "java.util.List<" + this.itemType.getShortText(contextNamespace) + ">";
            }

            @Override
            BoxableType convertToPureReference() {
                return this;
            }
        }

        private static class Reference
        extends BoxableType {
            private final NamePath namePath;

            private Reference(NamePath namePath) {
                this.namePath = namePath;
            }

            @Override
            String getFullText() {
                return this.namePath.getFullText();
            }

            @Override
            String getShortText(NamePath contextNamespace) {
                StringBuilder builder;
                int contextLength;
                int nameLength = this.namePath.getLength();
                if (nameLength > (contextLength = contextNamespace.getLength()) && (builder = this.subtractContextRecursively(this.namePath, nameLength - contextLength, contextNamespace)) != null) {
                    return builder.toString();
                }
                return this.namePath.getFullText();
            }

            private StringBuilder subtractContextRecursively(NamePath namePos, int count, NamePath prefix) {
                if (count > 1) {
                    StringBuilder result = this.subtractContextRecursively(namePos.getParent(), count - 1, prefix);
                    if (result == null) {
                        return null;
                    }
                    result.append('.');
                    result.append(namePos.getLastComponent());
                    return result;
                }
                String nameComponent = namePos.getLastComponent();
                namePos = namePos.getParent();
                do {
                    if (!namePos.getLastComponent().equals(prefix.getLastComponent())) {
                        return null;
                    }
                    namePos = namePos.getParent();
                    prefix = prefix.getParent();
                } while (namePos != null);
                StringBuilder result = new StringBuilder();
                result.append(nameComponent);
                return result;
            }

            @Override
            BoxableType convertToPureReference() {
                return this;
            }
        }
    }

    private static abstract class ClassNameScheme {
        private final String suffix;

        ClassNameScheme(String suffix) {
            this.suffix = suffix;
        }

        NamePath getFullName(String domainName, String baseName) {
            return new NamePath(this.getShortName(baseName), new NamePath(this.getPackageNameVirtual(domainName)));
        }

        String getShortName(String baseName) {
            return String.valueOf(Generator.capitalizeFirstChar(baseName)) + this.suffix;
        }

        protected abstract String getPackageNameVirtual(String var1);

        static class Common
        extends ClassNameScheme {
            Common(String suffix) {
                super(suffix);
            }

            @Override
            protected String getPackageNameVirtual(String domainName) {
                return Common.getPackageName(domainName);
            }

            static String getPackageName(String domainName) {
                return "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.common." + domainName.toLowerCase();
            }
        }

        static class Input
        extends ClassNameScheme {
            Input(String suffix) {
                super(suffix);
            }

            @Override
            protected String getPackageNameVirtual(String domainName) {
                return Input.getPackageName(domainName);
            }

            String getParseMethodName(String domain, String name) {
                return "parse" + Generator.capitalizeFirstChar(domain) + this.getShortName(name);
            }

            static String getPackageName(String domainName) {
                return "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input." + domainName.toLowerCase();
            }
        }

        static class Output
        extends ClassNameScheme {
            Output(String suffix) {
                super(suffix);
            }

            @Override
            protected String getPackageNameVirtual(String domainName) {
                return Output.getPackageName(domainName);
            }

            static String getPackageName(String domainName) {
                return "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output." + domainName.toLowerCase();
            }
        }
    }

    private static class DeferredWriter
    implements IndentWriter {
        private final String indent;
        private final StringBuilder builder;

        DeferredWriter() {
            this("", new StringBuilder());
        }

        DeferredWriter(String indent, StringBuilder builder) {
            this.indent = indent;
            this.builder = builder;
        }

        @Override
        public void append(String text) {
            text = text.replaceAll("\t", "\t" + this.indent);
            this.builder.append(text);
        }

        @Override
        public IndentWriter createInner() {
            return new DeferredWriter(String.valueOf(this.indent) + "  ", this.builder);
        }

        void writeContent(IndentWriter output) {
            output.append(this.builder.toString());
        }
    }

    private class DomainGenerator {
        private final WipMetamodel.Domain domain;

        DomainGenerator(WipMetamodel.Domain domain) {
            this.domain = domain;
        }

        void registerTypes() {
            if (this.domain.types() != null) {
                for (WipMetamodel.StandaloneType type : this.domain.types()) {
                    Generator.this.typeMap.getTypeData(this.domain.domain(), type.id()).setType(type);
                }
            }
        }

        void generateCommandsAndEvents() throws IOException {
            for (WipMetamodel.Command command : this.domain.commands()) {
                boolean hasResponse = command.returns() != null;
                this.generateCommandParams(command, hasResponse);
                if (!hasResponse) continue;
                this.generateCommandData(command);
                String dataFullName = Naming.COMMAND_DATA.getFullName(this.domain.domain(), command.name()).getFullText();
                Generator.this.jsonProtocolParserClassNames.add(dataFullName);
                Generator.this.parserRootInterfaceItems.add(new ParserRootInterfaceItem(this.domain.domain(), command.name(), Naming.COMMAND_DATA));
            }
            if (this.domain.events() != null) {
                for (WipMetamodel.Event event : this.domain.events()) {
                    this.generateEvenData(event);
                    Generator.this.jsonProtocolParserClassNames.add(Naming.EVENT_DATA.getFullName(this.domain.domain(), event.name()).getFullText());
                    Generator.this.parserRootInterfaceItems.add(new ParserRootInterfaceItem(this.domain.domain(), event.name(), Naming.EVENT_DATA));
                }
            }
        }

        private void generateCommandParams(WipMetamodel.Command command, boolean hasResponse) throws IOException {
            StringBuilder baseTypeBuilder = new StringBuilder();
            baseTypeBuilder.append("org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.");
            if (hasResponse) {
                baseTypeBuilder.append("WipParamsWithResponse<" + Naming.COMMAND_DATA.getFullName(this.domain.domain(), command.name()).getFullText() + ">");
            } else {
                baseTypeBuilder.append("WipParams");
            }
            DeferredWriter additionalMemberBuilder = new DeferredWriter();
            additionalMemberBuilder.append("\t  public static final String METHOD_NAME = org.eclipse.wst.jsdt.chromium.internal.wip.protocol.BasicConstants.Domain." + this.domain.domain().toUpperCase() + " + \"." + command.name() + "\";\n");
            additionalMemberBuilder.append("\n");
            additionalMemberBuilder.append("\t  @Override protected String getRequestName() {\n");
            additionalMemberBuilder.append("\t    return METHOD_NAME;\n");
            additionalMemberBuilder.append("\t  }\n");
            additionalMemberBuilder.append("\t\n");
            if (hasResponse) {
                String dataInterfaceFullname = Naming.COMMAND_DATA.getFullName(this.domain.domain(), command.name()).getFullText();
                additionalMemberBuilder.append("\t  @Override public " + dataInterfaceFullname + " parseResponse(" + "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipCommandResponse.Data data, " + "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input." + Generator.PARSER_ROOT_INTERFACE_NAME + " parser) " + "throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n");
                additionalMemberBuilder.append("\t    return parser." + Naming.COMMAND_DATA.getParseMethodName(this.domain.domain(), command.name()) + "(data.getUnderlyingObject());\n");
                additionalMemberBuilder.append("\t  }\n");
                additionalMemberBuilder.append("\t\n");
            }
            this.generateTopLevelOutputClass(Naming.PARAMS, command.name(), command.description(), baseTypeBuilder.toString(), additionalMemberBuilder, command.parameters(), PropertyLikeAccess.PARAMETER);
        }

        private void generateCommandAdditionalParam(WipMetamodel.StandaloneType type) throws IOException {
            this.generateTopLevelOutputClass(Naming.ADDITIONAL_PARAM, type.id(), type.description(), "org.json.simple.JSONObject", null, type.properties(), PropertyLikeAccess.PROPERTY);
        }

        private <P> void generateTopLevelOutputClass(ClassNameScheme nameScheme, String baseName, String description, String baseType, DeferredWriter additionalMemberText, List<P> properties, PropertyLikeAccess<P> propertyAccess) throws IOException {
            JavaFileUpdater fileUpdater = Generator.this.startJavaFile(nameScheme, this.domain, baseName);
            Writer writer = fileUpdater.getWriter();
            IndentWriterImpl indentWriter = new IndentWriterImpl(writer, "");
            NamePath classNamePath = nameScheme.getFullName(this.domain.domain(), baseName);
            this.generateOutputClass(indentWriter, classNamePath, description, baseType, additionalMemberText, properties, propertyAccess);
            writer.close();
            fileUpdater.update();
        }

        private <P> void generateOutputClass(IndentWriter writer, NamePath classNamePath, String description, String baseType, DeferredWriter additionalMemberText, List<P> properties, PropertyLikeAccess<P> propertyAccess) throws IOException {
            if (description != null) {
                writer.append("\t/**\n" + description + "\n */\n");
            }
            writer.append("\tpublic class " + classNamePath.getLastComponent() + " extends " + baseType + " {\n");
            OutputClassScope classScope = new OutputClassScope(classNamePath);
            if (additionalMemberText != null) {
                classScope.addMember("param-specific", additionalMemberText);
            }
            classScope.generateCommandParamsBody(writer, properties, propertyAccess, classNamePath.getLastComponent());
            classScope.writeAdditionalMembers(writer);
            writer.append("\t}\n");
        }

        StandaloneTypeBinding createStandaloneOutputTypeBinding(WipMetamodel.StandaloneType type, final String name) {
            return (StandaloneTypeBinding)Generator.switchByType(type, TypedObjectAccess.FOR_STANDALONE, new CreateStandalonTypeBindingVisitorBase(this, type){

                @Override
                public StandaloneTypeBinding visitObject(List<WipMetamodel.ObjectProperty> properties) {
                    return new StandaloneTypeBinding(){

                        @Override
                        public BoxableType getJavaType() {
                            return BoxableType.createReference(Naming.ADDITIONAL_PARAM.getFullName(domain.domain(), name));
                        }

                        @Override
                        public void generate() throws IOException {
                            this.generateCommandAdditionalParam(this.getType());
                        }

                        @Override
                        public TypeData.Direction getDirection() {
                            return TypeData.Direction.OUTPUT;
                        }
                    };
                }

                @Override
                public StandaloneTypeBinding visitEnum(List<String> enumConstants) {
                    return this.createStandaloneEnumInputTypeBinding(this.getType(), enumConstants, TypeData.Direction.OUTPUT);
                }

                @Override
                public StandaloneTypeBinding visitArray(final WipMetamodel.ArrayItemType items) {
                    StandaloneTypeBinding.Target target = new StandaloneTypeBinding.Target(){

                        @Override
                        public BoxableType resolve(final StandaloneTypeBinding.Target.ResolveContext context) {
                            ResolveAndGenerateScope resolveAndGenerateScope = new ResolveAndGenerateScope(){

                                @Override
                                public String getDomainName() {
                                    return domain.domain();
                                }

                                @Override
                                public TypeData.Direction getTypeDirection() {
                                    return TypeData.Direction.OUTPUT;
                                }

                                @Override
                                public BoxableType generateEnum(String description, List<String> enumConstants) {
                                    throw new UnsupportedOperationException();
                                }

                                @Override
                                public <T> QualifiedTypeData resolveType(T typedObject, TypedObjectAccess<T> access) {
                                    throw new UnsupportedOperationException();
                                }

                                @Override
                                public BoxableType generateNestedObject(String description, List<WipMetamodel.ObjectProperty> properties) throws IOException {
                                    return context.generateNestedObject("Item", description, properties);
                                }
                            };
                            QualifiedTypeData itemTypeData = Generator.this.resolveType(items, TypedObjectAccess.FOR_ARRAY_ITEM, resolveAndGenerateScope);
                            BoxableType itemBoxableType = itemTypeData.getJavaType();
                            BoxableType arrayType = BoxableType.createList(itemBoxableType);
                            return arrayType;
                        }
                    };
                    return this.createTypedefTypeBinding(this.getType(), target, Naming.OUTPUT_TYPEDEF, TypeData.Direction.OUTPUT);
                }
            });
        }

        StandaloneTypeBinding createStandaloneInputTypeBinding(WipMetamodel.StandaloneType type) {
            return (StandaloneTypeBinding)Generator.switchByType(type, TypedObjectAccess.FOR_STANDALONE, new CreateStandalonTypeBindingVisitorBase(this, type){

                @Override
                public StandaloneTypeBinding visitObject(List<WipMetamodel.ObjectProperty> properties) {
                    return this.createStandaloneObjectInputTypeBinding(this.getType(), properties);
                }

                @Override
                public StandaloneTypeBinding visitEnum(List<String> enumConstants) {
                    return this.createStandaloneEnumInputTypeBinding(this.getType(), enumConstants, TypeData.Direction.INPUT);
                }

                @Override
                public StandaloneTypeBinding visitArray(WipMetamodel.ArrayItemType items) {
                    ResolveAndGenerateScope resolveAndGenerateScope = new ResolveAndGenerateScope(){

                        @Override
                        public String getDomainName() {
                            return domain.domain();
                        }

                        @Override
                        public TypeData.Direction getTypeDirection() {
                            return TypeData.Direction.INPUT;
                        }

                        @Override
                        public BoxableType generateEnum(String description, List<String> enumConstants) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public <T> QualifiedTypeData resolveType(T typedObject, TypedObjectAccess<T> access) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public BoxableType generateNestedObject(String description, List<WipMetamodel.ObjectProperty> properties) throws IOException {
                            throw new UnsupportedOperationException();
                        }
                    };
                    QualifiedTypeData itemTypeData = Generator.this.resolveType(items, TypedObjectAccess.FOR_ARRAY_ITEM, resolveAndGenerateScope);
                    BoxableType itemBoxableType = itemTypeData.getJavaType();
                    final BoxableType arrayType = BoxableType.createList(itemBoxableType);
                    StandaloneTypeBinding.Target target = new StandaloneTypeBinding.Target(){

                        @Override
                        public BoxableType resolve(StandaloneTypeBinding.Target.ResolveContext context) {
                            return arrayType;
                        }
                    };
                    return this.createTypedefTypeBinding(this.getType(), target, Naming.INPUT_TYPEDEF, TypeData.Direction.INPUT);
                }
            });
        }

        StandaloneTypeBinding createStandaloneObjectInputTypeBinding(final WipMetamodel.StandaloneType type, final List<WipMetamodel.ObjectProperty> properties) {
            final String name = type.id();
            final NamePath fullTypeName = Naming.INPUT_VALUE.getFullName(this.domain.domain(), name);
            Generator.this.jsonProtocolParserClassNames.add(fullTypeName.getFullText());
            return new StandaloneTypeBinding(){

                @Override
                public BoxableType getJavaType() {
                    return BoxableType.createReference(fullTypeName);
                }

                @Override
                public void generate() throws IOException {
                    String description = type.description();
                    NamePath className = Naming.INPUT_VALUE.getFullName(DomainGenerator.this.domain.domain(), name);
                    JavaFileUpdater fileUpdater = Generator.this.startJavaFile(Naming.INPUT_VALUE, DomainGenerator.this.domain, name);
                    IndentWriterImpl writer = new IndentWriterImpl(fileUpdater.getWriter(), "");
                    if (description != null) {
                        writer.append("\t/**\n " + description + "\n */\n");
                    }
                    writer.append("\t@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType");
                    if (properties == null) {
                        writer.append("(allowsOtherProperties=true)");
                    }
                    writer.append("\n");
                    writer.append("\tpublic interface " + className.getLastComponent());
                    if (properties == null) {
                        writer.append(" extends org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonObjectBased");
                    }
                    writer.append(" {\n");
                    InputClassScope classScope = new InputClassScope(className);
                    classScope.generateStandaloneTypeBody(writer, properties);
                    classScope.writeAdditionalMembers(writer);
                    writer.append("\t}\n");
                    fileUpdater.update();
                }

                @Override
                public TypeData.Direction getDirection() {
                    return TypeData.Direction.INPUT;
                }
            };
        }

        StandaloneTypeBinding createStandaloneEnumInputTypeBinding(final WipMetamodel.StandaloneType type, final List<String> enumConstants, final TypeData.Direction direction) {
            final String name = type.id();
            return new StandaloneTypeBinding(){

                @Override
                public BoxableType getJavaType() {
                    return BoxableType.createReference(Naming.INPUT_ENUM.getFullName(DomainGenerator.this.domain.domain(), name));
                }

                @Override
                public void generate() throws IOException {
                    String description = type.description();
                    String className = Naming.INPUT_ENUM.getShortName(name);
                    JavaFileUpdater fileUpdater = Generator.this.startJavaFile(Naming.INPUT_ENUM, DomainGenerator.this.domain, name);
                    Writer writer = fileUpdater.getWriter();
                    if (description != null) {
                        writer.write("/**\n " + description + "\n */\n");
                    }
                    writer.write("public enum " + className + " {\n");
                    boolean first = true;
                    for (String constName : enumConstants) {
                        if (first) {
                            writer.write("\n  ");
                        } else {
                            writer.write(",\n  ");
                        }
                        writer.write(EnumValueCondition.decorateEnumConstantName((String)constName));
                        first = false;
                    }
                    writer.write("\n");
                    writer.write("}\n");
                    fileUpdater.update();
                }

                @Override
                public TypeData.Direction getDirection() {
                    return direction;
                }
            };
        }

        StandaloneTypeBinding createTypedefTypeBinding(final WipMetamodel.StandaloneType type, StandaloneTypeBinding.Target target, final ClassNameScheme nameScheme, final TypeData.Direction direction) {
            final String name = type.id();
            final NamePath typedefJavaName = nameScheme.getFullName(this.domain.domain(), name);
            final BoxableType typedefJavaType = BoxableType.createReference(typedefJavaName);
            final ArrayList deferredWriters = new ArrayList(0);
            class ResolveContextImpl
            implements StandaloneTypeBinding.Target.ResolveContext {
                private final /* synthetic */ NamePath val$typedefJavaName;
                private final /* synthetic */ TypeData.Direction val$direction;
                private final /* synthetic */ List val$deferredWriters;

                ResolveContextImpl(NamePath namePath, TypeData.Direction direction, List list) {
                    this.val$typedefJavaName = namePath;
                    this.val$direction = direction;
                    this.val$deferredWriters = list;
                }

                @Override
                public BoxableType generateNestedObject(String shortName, String description, List<WipMetamodel.ObjectProperty> properties) throws IOException {
                    DeferredWriter writer = new DeferredWriter();
                    NamePath classNamePath = new NamePath(shortName, this.val$typedefJavaName);
                    if (this.val$direction == null) {
                        throw new RuntimeException("Unsupported");
                    }
                    switch (this.val$direction) {
                        case INPUT: {
                            throw new RuntimeException("TODO");
                        }
                        case OUTPUT: {
                            DomainGenerator.this.generateOutputClass(writer, classNamePath, description, "org.json.simple.JSONObject", null, properties, PropertyLikeAccess.PROPERTY);
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    this.val$deferredWriters.add(writer);
                    return BoxableType.createReference(new NamePath(shortName, this.val$typedefJavaName));
                }
            }
            ResolveContextImpl resolveContext = new ResolveContextImpl(typedefJavaName, direction, deferredWriters);
            final BoxableType actualJavaType = target.resolve(resolveContext);
            return new StandaloneTypeBinding(){

                @Override
                public BoxableType getJavaType() {
                    return new DecoratedBoxableType(actualJavaType, typedefJavaType);
                }

                @Override
                public void generate() throws IOException {
                    String description = type.description();
                    String className = nameScheme.getShortName(name);
                    JavaFileUpdater fileUpdater = Generator.this.startJavaFile(nameScheme, DomainGenerator.this.domain, name);
                    NamePath contextNamespace = typedefJavaName;
                    IndentWriterImpl writer = new IndentWriterImpl(fileUpdater.getWriter(), "");
                    if (description != null) {
                        writer.append("\t/**\n " + description + "\n */\n");
                    }
                    writer.append("\tpublic class " + className + " {\n");
                    writer.append("\t  /*\n   The class is 'typedef'.\n\t   It merely holds a type javadoc and its only field refers to an actual type.\n\t   */\n");
                    writer.append("\t  " + actualJavaType.getShortText(contextNamespace) + " actualType;\n");
                    IndentWriter innerWriter = writer.createInner();
                    for (DeferredWriter memberWriter : deferredWriters) {
                        memberWriter.writeContent(innerWriter);
                    }
                    writer.append("\t}\n");
                    fileUpdater.update();
                }

                @Override
                public TypeData.Direction getDirection() {
                    return direction;
                }

                class DecoratedBoxableType
                extends BoxableType {
                    private final BoxableType original;
                    private final /* synthetic */ BoxableType val$typedefJavaType;

                    DecoratedBoxableType(BoxableType original, BoxableType boxableType) {
                        this.val$typedefJavaType = boxableType;
                        this.original = original;
                    }

                    @Override
                    String getFullText() {
                        return this.decorateTypeName(this.original.getFullText(), this.val$typedefJavaType.getFullText());
                    }

                    @Override
                    String getShortText(NamePath contextNamespace) {
                        return this.decorateTypeName(this.original.getShortText(contextNamespace), this.val$typedefJavaType.getShortText(contextNamespace));
                    }

                    @Override
                    BoxableType convertToPureReference() {
                        BoxableType pureReference = this.original.convertToPureReference();
                        if (pureReference == this.original) {
                            return this;
                        }
                        return new DecoratedBoxableType(pureReference, this.val$typedefJavaType);
                    }

                    private String decorateTypeName(String actualTypeName, String innerTypeName) {
                        return String.valueOf(actualTypeName) + "/*See " + innerTypeName + "*/";
                    }
                }
            };
        }

        private void generateCommandData(WipMetamodel.Command command) throws IOException {
            String className = Naming.COMMAND_DATA.getShortName(command.name());
            JavaFileUpdater fileUpdater = Generator.this.startJavaFile(Naming.COMMAND_DATA, this.domain, command.name());
            IndentWriterImpl writer = new IndentWriterImpl(fileUpdater.getWriter(), "");
            this.generateJsonProtocolInterface(writer, className, command.description(), command.returns(), null);
            fileUpdater.update();
        }

        private void generateEvenData(WipMetamodel.Event event) throws IOException {
            String className = Naming.EVENT_DATA.getShortName(event.name());
            JavaFileUpdater fileUpdater = Generator.this.startJavaFile(Naming.EVENT_DATA, this.domain, event.name());
            String domainName = this.domain.domain();
            String fullName = Naming.EVENT_DATA.getFullName(domainName, event.name()).getFullText();
            DeferredWriter eventTypeMemberText = new DeferredWriter();
            eventTypeMemberText.append("\t  public static final org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipEventType<" + fullName + "> TYPE\n\t      = new org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipEventType<" + fullName + ">(\"" + domainName + "." + event.name() + "\", " + fullName + ".class) {\n" + "\t    @Override public " + fullName + " parse(" + Generator.INPUT_PACKAGE + "." + Generator.PARSER_ROOT_INTERFACE_NAME + " parser, org.json.simple.JSONObject obj)" + " throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n" + "\t      return parser." + Naming.EVENT_DATA.getParseMethodName(domainName, event.name()) + "(obj);\n" + "\t    }\n" + "\t  };\n");
            IndentWriterImpl writer = new IndentWriterImpl(fileUpdater.getWriter(), "");
            this.generateJsonProtocolInterface(writer, className, event.description(), event.parameters(), eventTypeMemberText);
            fileUpdater.update();
        }

        private void generateJsonProtocolInterface(IndentWriter writer, String className, String description, List<WipMetamodel.Parameter> parameters, DeferredWriter additionalMembersText) throws IOException {
            if (description != null) {
                writer.append("\t/**\n " + description + "\n */\n");
            }
            writer.append("\t@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType");
            if (parameters == null) {
                writer.append("(allowsOtherProperties=true)");
            }
            writer.append("\n");
            writer.append("\tpublic interface " + className);
            if (parameters == null) {
                writer.append(" extends org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonObjectBased");
            }
            writer.append(" {\n");
            InputClassScope classScope = new InputClassScope(new NamePath(className, new NamePath(ClassNameScheme.Input.getPackageName(this.domain.domain()))));
            if (additionalMembersText != null) {
                classScope.addMember("extra", additionalMembersText);
            }
            classScope.generateMainJsonProtocolInterfaceBody(writer, parameters);
            classScope.writeAdditionalMembers(writer);
            writer.append("\t}\n");
        }

        private abstract class ClassScope {
            private final List<DeferredWriter> additionalMemberTexts = new ArrayList<DeferredWriter>(2);
            private final NamePath contextNamespace;

            ClassScope(NamePath classNamespace) {
                this.contextNamespace = classNamespace;
            }

            protected String getShortClassName() {
                return this.contextNamespace.getLastComponent();
            }

            String getFullName() {
                return this.contextNamespace.getFullText();
            }

            NamePath getClassContextNamespace() {
                return this.contextNamespace;
            }

            void addMember(String key, DeferredWriter deferredWriter) {
                this.additionalMemberTexts.add(deferredWriter);
            }

            void writeAdditionalMembers(IndentWriter writer) throws IOException {
                for (DeferredWriter deferredWriter : this.additionalMemberTexts) {
                    deferredWriter.writeContent(writer);
                }
            }

            protected abstract MemberScope newMemberScope(String var1);

            protected abstract TypeData.Direction getTypeDirection();

            protected abstract class MemberScope
            implements ResolveAndGenerateScope {
                private final String memberName;

                protected MemberScope(String memberName) {
                    this.memberName = memberName;
                }

                private QualifiedTypeData resolveType(WipMetamodel.ObjectProperty objectProperty) {
                    return this.resolveType(objectProperty, TypedObjectAccess.FOR_OBJECT_PROPERTY);
                }

                private QualifiedTypeData resolveType(WipMetamodel.Parameter parameter) {
                    return this.resolveType(parameter, TypedObjectAccess.FOR_PARAMETER);
                }

                @Override
                public <T> QualifiedTypeData resolveType(T typedObject, TypedObjectAccess<T> access) {
                    return Generator.this.resolveType(typedObject, access, this);
                }

                protected String getMemberName() {
                    return this.memberName;
                }

                @Override
                public abstract BoxableType generateEnum(String var1, List<String> var2);

                @Override
                public abstract BoxableType generateNestedObject(String var1, List<WipMetamodel.ObjectProperty> var2) throws IOException;

                @Override
                public String getDomainName() {
                    return DomainGenerator.this.domain.domain();
                }

                @Override
                public TypeData.Direction getTypeDirection() {
                    return ClassScope.this.getTypeDirection();
                }
            }
        }

        abstract class CreateStandalonTypeBindingVisitorBase
        implements TypeVisitor<StandaloneTypeBinding> {
            private final WipMetamodel.StandaloneType type;

            CreateStandalonTypeBindingVisitorBase(WipMetamodel.StandaloneType type) {
                this.type = type;
            }

            protected WipMetamodel.StandaloneType getType() {
                return this.type;
            }

            @Override
            public StandaloneTypeBinding visitString() {
                return DomainGenerator.this.createTypedefTypeBinding(this.type, StandaloneTypeBinding.PredefinedTarget.STRING, Naming.COMMON_TYPEDEF, null);
            }

            @Override
            public StandaloneTypeBinding visitInteger() {
                return DomainGenerator.this.createTypedefTypeBinding(this.type, StandaloneTypeBinding.PredefinedTarget.LONG, Naming.COMMON_TYPEDEF, null);
            }

            @Override
            public StandaloneTypeBinding visitRef(String refName) {
                throw new RuntimeException();
            }

            @Override
            public StandaloneTypeBinding visitBoolean() {
                throw new RuntimeException();
            }

            @Override
            public StandaloneTypeBinding visitNumber() {
                return DomainGenerator.this.createTypedefTypeBinding(this.type, StandaloneTypeBinding.PredefinedTarget.NUMBER, Naming.COMMON_TYPEDEF, null);
            }

            @Override
            public StandaloneTypeBinding visitUnknown() {
                throw new RuntimeException();
            }
        }

        class InputClassScope
        extends ClassScope {
            InputClassScope(NamePath namePath) {
                super(namePath);
            }

            public void generateMainJsonProtocolInterfaceBody(IndentWriter writer, List<WipMetamodel.Parameter> parameters) throws IOException {
                if (parameters != null) {
                    for (WipMetamodel.Parameter param : parameters) {
                        if (param.description() != null) {
                            writer.append("\t  /**\n   " + param.description() + "\n   */\n");
                        }
                        String methodName = Generator.this.generateMethodNameSubstitute(param.name(), writer);
                        ClassScope.MemberScope memberScope = this.newMemberScope(param.name());
                        QualifiedTypeData paramTypeData = memberScope.resolveType(param);
                        paramTypeData.writeAnnotations(writer, "  ");
                        writer.append("\t  " + paramTypeData.getJavaType().getShortText(this.getClassContextNamespace()) + " " + methodName + "();\n");
                        writer.append("\t\n");
                    }
                }
            }

            void generateStandaloneTypeBody(IndentWriter writer, List<WipMetamodel.ObjectProperty> properties) throws IOException {
                if (properties != null) {
                    for (WipMetamodel.ObjectProperty objectProperty : properties) {
                        String propertyName = objectProperty.name();
                        if (objectProperty.description() != null) {
                            writer.append("\t  /**\n   " + objectProperty.description() + "\n   */\n");
                        }
                        String methodName = Generator.this.generateMethodNameSubstitute(propertyName, writer);
                        ClassScope.MemberScope memberScope = this.newMemberScope(propertyName);
                        QualifiedTypeData propertyTypeData = memberScope.resolveType(objectProperty);
                        propertyTypeData.writeAnnotations(writer, "  ");
                        writer.append("\t  " + propertyTypeData.getJavaType().getShortText(this.getClassContextNamespace()) + " " + methodName + "();\n");
                        writer.append("\t\n");
                    }
                }
            }

            @Override
            protected TypeData.Direction getTypeDirection() {
                return TypeData.Direction.INPUT;
            }

            @Override
            protected ClassScope.MemberScope newMemberScope(String memberName) {
                return new InputMemberScope(memberName);
            }

            class InputMemberScope
            extends ClassScope.MemberScope {
                InputMemberScope(String memberName) {
                    super(memberName);
                }

                @Override
                public BoxableType generateEnum(String description, List<String> enumConstants) {
                    DeferredWriter builder = new DeferredWriter();
                    if (description != null) {
                        builder.append("\t  /**\n   " + description + "\n   */\n");
                    }
                    String enumName = Generator.capitalizeFirstChar(this.getMemberName());
                    builder.append("\t  public enum " + enumName + " {\n");
                    for (String constant : enumConstants) {
                        builder.append("\t    " + EnumValueCondition.decorateEnumConstantName((String)constant) + ",\n");
                    }
                    builder.append("\t  }\n");
                    InputClassScope.this.addMember(enumName, builder);
                    return BoxableType.createReference(new NamePath(enumName, InputClassScope.this.getClassContextNamespace()));
                }

                @Override
                public BoxableType generateNestedObject(String description, List<WipMetamodel.ObjectProperty> propertyList) throws IOException {
                    DeferredWriter builder = new DeferredWriter();
                    if (description != null) {
                        builder.append("\t  /**\n   " + description + "\n   */\n");
                    }
                    String objectName = Generator.capitalizeFirstChar(this.getMemberName());
                    if (propertyList == null) {
                        builder.append("\t  @org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType(allowsOtherProperties=true)\n");
                        builder.append("\t  public interface " + objectName + " extends org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonObjectBased {\n");
                        builder.append("\t  }\n");
                    } else {
                        builder.append("\t  @org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType\n");
                        builder.append("\t  public interface " + objectName + " {\n");
                        for (WipMetamodel.ObjectProperty property : propertyList) {
                            if (property.description() != null) {
                                builder.append("\t    /**\n     " + property.description() + "\n     */\n");
                            }
                            String methodName = Generator.this.generateMethodNameSubstitute(property.name(), builder);
                            ClassScope.MemberScope memberScope = InputClassScope.this.newMemberScope(property.name());
                            QualifiedTypeData propertyTypeData = memberScope.resolveType(property);
                            propertyTypeData.writeAnnotations(builder, "    ");
                            builder.append("\t    " + propertyTypeData.getJavaType().getShortText(InputClassScope.this.getClassContextNamespace()) + " " + methodName + "();\n");
                            builder.append("\t\n");
                        }
                        builder.append("\t  }\n");
                    }
                    InputClassScope.this.addMember(objectName, builder);
                    Generator.this.jsonProtocolParserClassNames.add(String.valueOf(InputClassScope.this.getFullName()) + "." + objectName);
                    return BoxableType.createReference(new NamePath(objectName, InputClassScope.this.getClassContextNamespace()));
                }
            }
        }

        class OutputClassScope
        extends ClassScope {
            OutputClassScope(NamePath classNamePath) {
                super(classNamePath);
            }

            <P> void generateCommandParamsBody(IndentWriter writer, List<P> parameters, PropertyLikeAccess<P> access, String commandName) throws IOException {
                abstract class ParamData {
                    final String name;
                    final String description;

                    ParamData(String name, String description) {
                        this.name = name;
                        this.description = description;
                    }

                    abstract String getJavaTypeText();

                    abstract void writeSetCode(IndentWriter var1);
                }
                List<ParamData> physicalParameters;
                if (parameters == null) {
                    physicalParameters = Collections.emptyList();
                } else {
                    physicalParameters = new ArrayList<ParamData>(parameters.size());
                    for (P param : parameters) {
                        class OptionalLogicalParamData
                        extends LogicalParamData {
                            final String condition;

                            OptionalLogicalParamData(String name, String description, QualifiedTypeData qualifiedTypeData, String logicalName, String condition) {
                                class LogicalParamData
                                extends ParamData {
                                    final QualifiedTypeData qualifiedTypeData;
                                    final String logicalName;

                                    LogicalParamData(String name, String description, QualifiedTypeData qualifiedTypeData, String logicalName) {
                                        super(name, description);
                                        this.qualifiedTypeData = qualifiedTypeData;
                                        this.logicalName = logicalName;
                                    }

                                    @Override
                                    String getJavaTypeText() {
                                        return this.qualifiedTypeData.getJavaType().getShortText(OutputClassScope.this.getClassContextNamespace());
                                    }

                                    @Override
                                    void writeSetCode(IndentWriter writer) {
                                        writer.append("\t    this.put(\"" + this.logicalName + "\", " + this.name + ");\n");
                                    }
                                }
                                super(name, description, qualifiedTypeData, logicalName);
                                this.condition = condition;
                            }

                            @Override
                            void writeSetCode(IndentWriter writer) {
                                writer.append("\t    if (" + this.condition + ") {\n  ");
                                super.writeSetCode(writer);
                                writer.append("\t    }\n");
                            }
                        }
                        LogicalParamData data;
                        String logicalName = access.getName(param);
                        String description = access.forTypedObject().getDescription(param);
                        ClassScope.MemberScope memberScope = this.newMemberScope(logicalName);
                        QualifiedTypeData paramTypeData = memberScope.resolveType(param, access.forTypedObject());
                        if (paramTypeData.isNullable() && paramTypeData.isOptional()) {
                            String paramName = logicalName;
                            String helperParamName = "has" + Generator.capitalizeFirstChar(paramName);
                            OptionalLogicalParamData mainParamData = new OptionalLogicalParamData(paramName, description, paramTypeData, logicalName, helperParamName);
                            String helperDescription = "whether '" + (String)paramName + "' actually contains value (possibly null)";
                            ParamData helperParamData = new ParamData(this, helperParamName, helperDescription){
                                {
                                    super($anonymous0, $anonymous1);
                                }

                                @Override
                                String getJavaTypeText() {
                                    return "boolean";
                                }

                                @Override
                                void writeSetCode(IndentWriter writer) {
                                }
                            };
                            physicalParameters.add(helperParamData);
                            physicalParameters.add(mainParamData);
                            continue;
                        }
                        if (paramTypeData.isOptional()) {
                            String paramName = String.valueOf(logicalName) + "Opt";
                            data = new OptionalLogicalParamData(paramName, description, paramTypeData, logicalName, String.valueOf(paramName) + " != null");
                        } else {
                            data = new LogicalParamData(logicalName, description, paramTypeData, logicalName);
                        }
                        physicalParameters.add(data);
                    }
                }
                boolean hasDoc = false;
                for (ParamData paramData : physicalParameters) {
                    if (paramData.description == null) continue;
                    hasDoc = true;
                    break;
                }
                if (hasDoc) {
                    writer.append("\t  /**\n");
                    for (ParamData paramData : physicalParameters) {
                        if (paramData.description == null) continue;
                        writer.append("\t   @param " + paramData.name + " " + paramData.description + "\n");
                    }
                    writer.append("\t   */\n");
                }
                writer.append("\t  public " + this.getShortClassName() + "(");
                boolean needComa = false;
                for (ParamData paramData : physicalParameters) {
                    if (needComa) {
                        writer.append(", ");
                    }
                    writer.append(String.valueOf(paramData.getJavaTypeText()) + " " + paramData.name);
                    needComa = true;
                }
                writer.append(") {\n");
                for (ParamData paramData : physicalParameters) {
                    paramData.writeSetCode(writer);
                }
                writer.append("\t  }\n");
                writer.append("\n");
            }

            @Override
            protected TypeData.Direction getTypeDirection() {
                return TypeData.Direction.OUTPUT;
            }

            @Override
            protected ClassScope.MemberScope newMemberScope(String memberName) {
                return new OutputMemberScope(memberName);
            }

            class OutputMemberScope
            extends ClassScope.MemberScope {
                protected OutputMemberScope(String memberName) {
                    super(memberName);
                }

                @Override
                public BoxableType generateEnum(String description, List<String> enumConstants) {
                    DeferredWriter builder = new DeferredWriter();
                    if (description != null) {
                        builder.append("\t  /**\n   " + description + "\n   */\n");
                    }
                    String enumName = Generator.capitalizeFirstChar(this.getMemberName());
                    builder.append("\t  public enum " + enumName + " implements org.json.simple.JSONAware{\n");
                    for (String constant : enumConstants) {
                        builder.append("\t    " + EnumValueCondition.decorateEnumConstantName((String)constant) + "(\"" + constant + "\"),\n");
                    }
                    builder.append("\t    ;\n");
                    builder.append("\t    private final String protocolValue;\n");
                    builder.append("\t\n");
                    builder.append("\t    " + enumName + "(String protocolValue) {\n");
                    builder.append("\t      this.protocolValue = protocolValue;\n");
                    builder.append("\t    }\n");
                    builder.append("\t\n");
                    builder.append("\t    @Override public String toJSONString() {\n");
                    builder.append("\t      return '\"' + protocolValue + '\"';\n");
                    builder.append("\t    }\n");
                    builder.append("\t  }\n");
                    OutputClassScope.this.addMember(enumName, builder);
                    return BoxableType.createReference(new NamePath(enumName, OutputClassScope.this.getClassContextNamespace()));
                }

                @Override
                public BoxableType generateNestedObject(String description, List<WipMetamodel.ObjectProperty> propertyList) throws IOException {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private static class FileSet {
        private final File rootDir;
        private final Set<File> unusedFiles;

        FileSet(File rootDir) {
            this.rootDir = rootDir;
            ArrayList<File> files = new ArrayList<File>();
            FileSet.collectFilesRecursive(rootDir, files);
            this.unusedFiles = new HashSet<File>(files);
        }

        JavaFileUpdater createFileUpdater(String filePath) {
            File file = new File(this.rootDir, filePath);
            this.unusedFiles.remove(file);
            return new JavaFileUpdater(file);
        }

        void deleteOtherFiles() {
            for (File file : this.unusedFiles) {
                file.delete();
            }
        }

        private static void collectFilesRecursive(File file, Collection<File> list) {
            if (file.isFile()) {
                list.add(file);
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File inner = fileArray[n2];
                    FileSet.collectFilesRecursive(inner, list);
                    ++n2;
                }
            }
        }
    }

    private static interface IndentWriter {
        public static final String INDENT = "  ";

        public void append(String var1);

        public IndentWriter createInner();
    }

    private static class IndentWriterImpl
    implements IndentWriter {
        private final String indent;
        private final Appendable output;

        IndentWriterImpl(Appendable output, String indent) {
            this.output = output;
            this.indent = indent;
        }

        @Override
        public void append(String text) {
            text = text.replaceAll("\t", this.indent);
            try {
                this.output.append(text);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public IndentWriter createInner() {
            return new IndentWriterImpl(this.output, String.valueOf(this.indent) + "  ");
        }
    }

    private static class NamePath {
        private final String lastComponent;
        private final NamePath parent;

        NamePath(String component) {
            this(component, null);
        }

        NamePath(String component, NamePath parent) {
            this.lastComponent = component;
            this.parent = parent;
        }

        NamePath getParent() {
            return this.parent;
        }

        String getLastComponent() {
            return this.lastComponent;
        }

        int getLength() {
            int res = 1;
            NamePath current = this;
            while (current != null) {
                ++res;
                current = current.getParent();
            }
            return res;
        }

        String getFullText() {
            StringBuilder result = new StringBuilder();
            this.fillFullPath(result);
            return result.toString();
        }

        private void fillFullPath(StringBuilder result) {
            if (this.parent != null) {
                this.parent.fillFullPath(result);
                result.append('.');
            }
            result.append(this.lastComponent);
        }
    }

    static interface Naming {
        public static final ClassNameScheme PARAMS = new ClassNameScheme.Output("Params");
        public static final ClassNameScheme ADDITIONAL_PARAM = new ClassNameScheme.Output("Param");
        public static final ClassNameScheme OUTPUT_TYPEDEF = new ClassNameScheme.Output("Typedef");
        public static final ClassNameScheme.Input COMMAND_DATA = new ClassNameScheme.Input("Data");
        public static final ClassNameScheme.Input EVENT_DATA = new ClassNameScheme.Input("EventData");
        public static final ClassNameScheme INPUT_VALUE = new ClassNameScheme.Input("Value");
        public static final ClassNameScheme INPUT_ENUM = new ClassNameScheme.Input("Enum");
        public static final ClassNameScheme INPUT_TYPEDEF = new ClassNameScheme.Input("Typedef");
        public static final ClassNameScheme COMMON_TYPEDEF = new ClassNameScheme.Common("Typedef");
    }

    private static class ParserRootInterfaceItem
    implements Comparable<ParserRootInterfaceItem> {
        private final String domain;
        private final String name;
        private final ClassNameScheme.Input nameScheme;
        private final String fullName;

        public ParserRootInterfaceItem(String domain, String name, ClassNameScheme.Input nameScheme) {
            this.domain = domain;
            this.name = name;
            this.nameScheme = nameScheme;
            this.fullName = nameScheme.getFullName(domain, name).getFullText();
        }

        void writeCode(Writer writer) throws IOException {
            writer.write("  @org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParseMethod\n");
            writer.write("  " + this.fullName + " " + this.nameScheme.getParseMethodName(this.domain, this.name) + "(org.json.simple.JSONObject obj)" + " throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;\n");
            writer.write("\n");
        }

        @Override
        public int compareTo(ParserRootInterfaceItem o) {
            return this.fullName.compareTo(o.fullName);
        }
    }

    private static abstract class PropertyLikeAccess<T> {
        static final PropertyLikeAccess<WipMetamodel.Parameter> PARAMETER = new PropertyLikeAccess<WipMetamodel.Parameter>(){

            @Override
            TypedObjectAccess<WipMetamodel.Parameter> forTypedObject() {
                return TypedObjectAccess.FOR_PARAMETER;
            }

            @Override
            String getName(WipMetamodel.Parameter obj) {
                return obj.name();
            }
        };
        static final PropertyLikeAccess<WipMetamodel.ObjectProperty> PROPERTY = new PropertyLikeAccess<WipMetamodel.ObjectProperty>(){

            @Override
            TypedObjectAccess<WipMetamodel.ObjectProperty> forTypedObject() {
                return TypedObjectAccess.FOR_OBJECT_PROPERTY;
            }

            @Override
            String getName(WipMetamodel.ObjectProperty obj) {
                return obj.name();
            }
        };

        private PropertyLikeAccess() {
        }

        abstract TypedObjectAccess<T> forTypedObject();

        abstract String getName(T var1);
    }

    private static class QualifiedTypeData {
        private final BoxableType typeRef;
        private final boolean optional;
        private final boolean nullable;

        QualifiedTypeData(BoxableType typeRef, boolean optional, boolean nullable) {
            this.typeRef = typeRef;
            this.optional = optional;
            this.nullable = nullable;
        }

        boolean isOptional() {
            return this.optional;
        }

        boolean isNullable() {
            return this.nullable;
        }

        BoxableType getJavaType() {
            return this.typeRef;
        }

        void writeAnnotations(IndentWriter appendable, String indent) throws IOException {
            if (this.isOptional()) {
                appendable.append("\t" + indent + "@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonOptionalField\n");
            }
            if (this.isNullable()) {
                appendable.append("\t" + indent + "@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonNullable\n");
            }
        }
    }

    private static interface ResolveAndGenerateScope {
        public String getDomainName();

        public TypeData.Direction getTypeDirection();

        public <T> QualifiedTypeData resolveType(T var1, TypedObjectAccess<T> var2);

        public BoxableType generateEnum(String var1, List<String> var2);

        public BoxableType generateNestedObject(String var1, List<WipMetamodel.ObjectProperty> var2) throws IOException;
    }

    private static interface StandaloneTypeBinding {
        public BoxableType getJavaType();

        public void generate() throws IOException;

        public TypeData.Direction getDirection();

        public static class PredefinedTarget
        implements Target {
            private final BoxableType resolvedType;
            public static final PredefinedTarget STRING = new PredefinedTarget(BoxableType.STRING);
            public static final PredefinedTarget LONG = new PredefinedTarget(BoxableType.LONG);
            public static final PredefinedTarget NUMBER = new PredefinedTarget(BoxableType.NUMBER);

            PredefinedTarget(BoxableType resolvedType) {
                this.resolvedType = resolvedType;
            }

            @Override
            public BoxableType resolve(Target.ResolveContext context) {
                return this.resolvedType;
            }
        }

        public static interface Target {
            public BoxableType resolve(ResolveContext var1);

            public static interface ResolveContext {
                public BoxableType generateNestedObject(String var1, String var2, List<WipMetamodel.ObjectProperty> var3) throws IOException;
            }
        }
    }

    private static class TypeData {
        private final String domain;
        private final String name;
        private Input input = null;
        private Output output = null;
        private WipMetamodel.StandaloneType type = null;
        private StandaloneTypeBinding commonBinding = null;

        TypeData(String domain, String name) {
            this.domain = domain;
            this.name = name;
        }

        void setType(WipMetamodel.StandaloneType type) {
            this.type = type;
        }

        Input getInput() {
            if (this.input == null) {
                this.input = new Input();
            }
            return this.input;
        }

        Output getOutput() {
            if (this.output == null) {
                this.output = new Output();
            }
            return this.output;
        }

        TypeRef get(Direction direction) {
            return direction.get(this);
        }

        void checkComplete() {
            if (this.input != null) {
                this.input.checkResolved();
            }
            if (this.output != null) {
                this.output.checkResolved();
            }
        }

        static enum Direction {
            INPUT{

                @Override
                TypeRef get(TypeData typeData) {
                    return typeData.getInput();
                }
            }
            ,
            OUTPUT{

                @Override
                TypeRef get(TypeData typeData) {
                    return typeData.getOutput();
                }
            };


            abstract TypeRef get(TypeData var1);
        }

        class Input
        extends TypeRef {
            Input() {
            }

            @Override
            StandaloneTypeBinding resolveImpl(DomainGenerator domainGenerator) {
                if (TypeData.this.type == null) {
                    throw new RuntimeException();
                }
                return domainGenerator.createStandaloneInputTypeBinding(TypeData.this.type);
            }
        }

        class Output
        extends TypeRef {
            Output() {
            }

            @Override
            StandaloneTypeBinding resolveImpl(DomainGenerator domainGenerator) {
                if (TypeData.this.type == null) {
                    throw new RuntimeException();
                }
                return domainGenerator.createStandaloneOutputTypeBinding(TypeData.this.type, TypeData.this.name);
            }
        }

        abstract class TypeRef {
            private StandaloneTypeBinding oneDirectionBinding = null;

            TypeRef() {
            }

            BoxableType resolve(TypeMap typeMap, DomainGenerator domainGenerator) {
                if (TypeData.this.commonBinding != null) {
                    return TypeData.this.commonBinding.getJavaType();
                }
                if (this.oneDirectionBinding != null) {
                    return this.oneDirectionBinding.getJavaType();
                }
                StandaloneTypeBinding binding = this.resolveImpl(domainGenerator);
                if (binding.getDirection() == null) {
                    TypeData.this.commonBinding = binding;
                } else {
                    this.oneDirectionBinding = binding;
                }
                typeMap.addTypeToGenerate(binding);
                return binding.getJavaType();
            }

            abstract StandaloneTypeBinding resolveImpl(DomainGenerator var1);

            void checkResolved() {
                if (TypeData.this.type == null) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private static class TypeMap {
        private final Map<List<String>, TypeData> map = new HashMap<List<String>, TypeData>();
        private Map<String, DomainGenerator> domainGeneratorMap = null;
        private List<StandaloneTypeBinding> typesToGenerate = new ArrayList<StandaloneTypeBinding>();

        private TypeMap() {
        }

        void setDomainGeneratorMap(Map<String, DomainGenerator> domainGeneratorMap) {
            this.domainGeneratorMap = domainGeneratorMap;
        }

        BoxableType resolve(String domainName, String typeName, TypeData.Direction direction) {
            DomainGenerator domainGenerator = this.domainGeneratorMap.get(domainName);
            if (domainGenerator == null) {
                throw new RuntimeException("Failed to find domain generator: " + domainName);
            }
            return this.getTypeData(domainName, typeName).get(direction).resolve(this, domainGenerator);
        }

        void addTypeToGenerate(StandaloneTypeBinding binding) {
            this.typesToGenerate.add(binding);
        }

        public void generateRequestedTypes() throws IOException {
            int i = 0;
            while (i < this.typesToGenerate.size()) {
                this.typesToGenerate.get(i).generate();
                ++i;
            }
            for (TypeData typeData : this.map.values()) {
                typeData.checkComplete();
            }
        }

        TypeData getTypeData(String domainName, String typeName) {
            List<String> key = this.createKey(domainName, typeName);
            TypeData result = this.map.get(key);
            if (result == null) {
                result = new TypeData(domainName, typeName);
                this.map.put(key, result);
            }
            return result;
        }

        private List<String> createKey(String domainName, String typeName) {
            return Arrays.asList(domainName, typeName);
        }
    }

    private static interface TypeVisitor<R> {
        public R visitRef(String var1);

        public R visitBoolean();

        public R visitEnum(List<String> var1);

        public R visitString();

        public R visitInteger();

        public R visitNumber();

        public R visitArray(WipMetamodel.ArrayItemType var1);

        public R visitObject(List<WipMetamodel.ObjectProperty> var1);

        public R visitUnknown();
    }

    private static abstract class TypedObjectAccess<T> {
        static final TypedObjectAccess<WipMetamodel.Parameter> FOR_PARAMETER = new TypedObjectAccess<WipMetamodel.Parameter>(){

            @Override
            String getDescription(WipMetamodel.Parameter obj) {
                return obj.description();
            }

            @Override
            Boolean getOptional(WipMetamodel.Parameter obj) {
                return obj.optional();
            }

            @Override
            String getRef(WipMetamodel.Parameter obj) {
                return obj.ref();
            }

            @Override
            List<String> getEnum(WipMetamodel.Parameter obj) {
                return obj.getEnum();
            }

            @Override
            String getType(WipMetamodel.Parameter obj) {
                return obj.type();
            }

            @Override
            WipMetamodel.ArrayItemType getItems(WipMetamodel.Parameter obj) {
                return obj.items();
            }

            @Override
            List<WipMetamodel.ObjectProperty> getProperties(WipMetamodel.Parameter obj) {
                return obj.properties();
            }
        };
        static final TypedObjectAccess<WipMetamodel.ObjectProperty> FOR_OBJECT_PROPERTY = new TypedObjectAccess<WipMetamodel.ObjectProperty>(){

            @Override
            String getDescription(WipMetamodel.ObjectProperty obj) {
                return obj.description();
            }

            @Override
            Boolean getOptional(WipMetamodel.ObjectProperty obj) {
                return obj.optional();
            }

            @Override
            String getRef(WipMetamodel.ObjectProperty obj) {
                return obj.ref();
            }

            @Override
            List<String> getEnum(WipMetamodel.ObjectProperty obj) {
                return obj.getEnum();
            }

            @Override
            String getType(WipMetamodel.ObjectProperty obj) {
                return obj.type();
            }

            @Override
            WipMetamodel.ArrayItemType getItems(WipMetamodel.ObjectProperty obj) {
                return obj.items();
            }

            @Override
            List<WipMetamodel.ObjectProperty> getProperties(WipMetamodel.ObjectProperty obj) {
                throw new RuntimeException();
            }
        };
        static final TypedObjectAccess<WipMetamodel.ArrayItemType> FOR_ARRAY_ITEM = new TypedObjectAccess<WipMetamodel.ArrayItemType>(){

            @Override
            String getDescription(WipMetamodel.ArrayItemType obj) {
                return obj.description();
            }

            @Override
            Boolean getOptional(WipMetamodel.ArrayItemType obj) {
                return obj.optional();
            }

            @Override
            String getRef(WipMetamodel.ArrayItemType obj) {
                return obj.ref();
            }

            @Override
            List<String> getEnum(WipMetamodel.ArrayItemType obj) {
                return obj.getEnum();
            }

            @Override
            String getType(WipMetamodel.ArrayItemType obj) {
                return obj.type();
            }

            @Override
            WipMetamodel.ArrayItemType getItems(WipMetamodel.ArrayItemType obj) {
                return obj.items();
            }

            @Override
            List<WipMetamodel.ObjectProperty> getProperties(WipMetamodel.ArrayItemType obj) {
                return obj.properties();
            }
        };
        static final TypedObjectAccess<WipMetamodel.StandaloneType> FOR_STANDALONE = new TypedObjectAccess<WipMetamodel.StandaloneType>(){

            @Override
            String getDescription(WipMetamodel.StandaloneType obj) {
                return obj.description();
            }

            @Override
            Boolean getOptional(WipMetamodel.StandaloneType obj) {
                return null;
            }

            @Override
            String getRef(WipMetamodel.StandaloneType obj) {
                return null;
            }

            @Override
            List<String> getEnum(WipMetamodel.StandaloneType obj) {
                return obj.getEnum();
            }

            @Override
            String getType(WipMetamodel.StandaloneType obj) {
                return obj.type();
            }

            @Override
            WipMetamodel.ArrayItemType getItems(WipMetamodel.StandaloneType obj) {
                return obj.items();
            }

            @Override
            List<WipMetamodel.ObjectProperty> getProperties(WipMetamodel.StandaloneType obj) {
                return obj.properties();
            }
        };

        private TypedObjectAccess() {
        }

        abstract String getDescription(T var1);

        abstract Boolean getOptional(T var1);

        abstract String getRef(T var1);

        abstract List<String> getEnum(T var1);

        abstract String getType(T var1);

        abstract WipMetamodel.ArrayItemType getItems(T var1);

        abstract List<WipMetamodel.ObjectProperty> getProperties(T var1);
    }

    private static class UnqualifiedTypeData {
        private final BoxableType typeRef;
        private final boolean nullable;
        static final UnqualifiedTypeData BOOLEAN = new UnqualifiedTypeData(BoxableType.BOOLEAN, false);
        static final UnqualifiedTypeData STRING = new UnqualifiedTypeData(BoxableType.STRING, false);
        static final UnqualifiedTypeData LONG = new UnqualifiedTypeData(BoxableType.LONG, false);
        static final UnqualifiedTypeData NUMBER = new UnqualifiedTypeData(BoxableType.NUMBER, false);
        static final UnqualifiedTypeData ANY = new UnqualifiedTypeData(BoxableType.OBJECT, true);

        UnqualifiedTypeData(BoxableType typeRef) {
            this(typeRef, false);
        }

        UnqualifiedTypeData(BoxableType typeRef, boolean nullable) {
            this.typeRef = typeRef;
            this.nullable = nullable;
        }

        QualifiedTypeData getQualifiedType(boolean optional) {
            BoxableType ref = optional ? this.typeRef.convertToPureReference() : this.typeRef;
            return new QualifiedTypeData(ref, optional, this.nullable);
        }
    }
}

