/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.gulp.internal.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.wst.jsdt.js.cli.core.CLI;
import org.eclipse.wst.jsdt.js.cli.core.CLICommand;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;
import org.eclipse.wst.jsdt.js.gulp.GulpPlugin;

public class GulpLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration conf, String arg1, ILaunch arg2, IProgressMonitor monitor) throws CoreException {
        String projectName = conf.getAttribute("org.eclipse.wst.jsdt.js.gulp.PROJECT", null);
        String dirPath = conf.getAttribute("org.eclipse.wst.jsdt.js.gulp.DIR", null);
        String commandName = conf.getAttribute("org.eclipse.wst.jsdt.js.gulp.COMMAND", null);
        IProject project = WorkbenchResourceUtil.getProject((String)projectName);
        if (project != null && project.exists()) {
            IPath dir = dirPath == null ? project.getLocation() : new Path(dirPath);
            CLICommand command = this.generateCLICommand(commandName);
            this.launchGulp(project, dir, command, monitor);
        }
    }

    private void launchGulp(IProject project, IPath dir, CLICommand command, IProgressMonitor monitor) {
        try {
            new CLI(project, dir, command).execute(monitor);
        }
        catch (CoreException e) {
            GulpPlugin.logError(e);
        }
    }

    protected CLICommand generateCLICommand(String commandName) {
        return new CLICommand("gulp", commandName, null, null);
    }
}

