/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.gulp.internal.ui;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.js.common.build.system.ITask;
import org.eclipse.wst.jsdt.js.common.build.system.util.ASTUtil;
import org.eclipse.wst.jsdt.js.gulp.GulpPlugin;
import org.eclipse.wst.jsdt.js.gulp.util.GulpVisitor;

public class GulpFileContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private Viewer viewer;
    private IResource resource;
    protected static final Object[] EMPTY_ARRAY = new Object[0];

    public void dispose() {
        if (this.resource != null) {
            this.resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.resource = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.resource != null) {
            this.resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.resource = (IResource)newInput;
        if (this.resource != null) {
            this.resource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.viewer = viewer;
    }

    public Object[] getChildren(Object parentNode) {
        Set<ITask> tasks = null;
        if (parentNode instanceof IFile) {
            try {
                IFile buildFile = (IFile)parentNode;
                JavaScriptUnit unit = ASTUtil.getJavaScriptUnit((IFile)buildFile);
                GulpVisitor visitor = new GulpVisitor(buildFile);
                unit.accept((ASTVisitor)visitor);
                tasks = visitor.getTasks();
            }
            catch (JavaScriptModelException e) {
                GulpPlugin.logError(e, e.getMessage());
            }
            return tasks.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return EMPTY_ARRAY;
    }

    public void resourceChanged(IResourceChangeEvent arg0) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                GulpFileContentProvider.this.viewer.refresh();
            }
        });
    }
}

