/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.launch.shortcut;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.js.node.NodePlugin;
import org.eclipse.wst.jsdt.js.node.common.json.objects.PackageJson;
import org.eclipse.wst.jsdt.js.node.common.util.PackageJsonUtil;
import org.eclipse.wst.jsdt.js.node.internal.util.LaunchConfigurationUtil;

public class NodeLaunch
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        try {
            Object objSelected = ((IStructuredSelection)selection).getFirstElement();
            if (objSelected instanceof IResource) {
                this.launchHelper((IResource)objSelected, mode);
            }
        }
        catch (CoreException e) {
            NodePlugin.logError(e.getLocalizedMessage());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        try {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)editorInput).getFile();
                this.launchHelper((IResource)file, mode);
            }
        }
        catch (CoreException e) {
            NodePlugin.logError(e.getLocalizedMessage());
        }
    }

    protected void launchHelper(IResource file, String mode) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.wst.jsdt.js.node.NodeLaunchConfigurationType");
        ILaunchConfiguration configuration = this.createLaunchConfiguration(type, file);
        String mainScript = null;
        try {
            mainScript = configuration.getAttribute("attr_app_path", "");
            if (mainScript != null && mainScript.equals("")) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                String groupId = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)mode).getIdentifier();
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)shell, (IStructuredSelection)new StructuredSelection((Object)configuration), (String)groupId);
            }
            if (mainScript != null && !mainScript.equals("")) {
                DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
            }
        }
        catch (CoreException e) {
            NodePlugin.logError(e.getLocalizedMessage());
        }
    }

    private ILaunchConfiguration createLaunchConfiguration(ILaunchConfigurationType type, IResource file) throws CoreException {
        ILaunchConfiguration config;
        String path = "";
        IFile configFile = null;
        if (file.getType() == 4 || file.getType() == 2) {
            IProject project;
            ILaunchConfiguration launch;
            IFile mainFile;
            PackageJson packageJson = PackageJsonUtil.readPackageJsonFromIResource((IResource)file);
            if (packageJson.getMain() != null && (mainFile = file.getProject().getFile(packageJson.getMain())) != null && mainFile.isAccessible()) {
                configFile = mainFile;
            }
            if (configFile == null && (launch = LaunchConfigurationUtil.getLaunchByName((project = file.getProject()).getName(), type)) != null) {
                return launch;
            }
        } else if (file.getType() == 1) {
            configFile = (IFile)file;
        }
        if ((config = LaunchConfigurationUtil.getExistingLaunchConfiguration(configFile, type, "attr_app_path")) != null) {
            return config;
        }
        String configName = "";
        if (configFile != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", configFile.getFullPath().toString());
            configName = configFile.getFullPath().toString();
            if (configName.startsWith("/")) {
                configName = configName.substring(1, configName.length());
            }
        } else {
            configName = file.getProject().getName();
        }
        configName = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(configName);
        IContainer container = null;
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(container, configName);
        workingCopy.setAttribute("attr_app_path", path);
        workingCopy.setAttribute("attr_app_project", file.getProject().getName());
        workingCopy.setAttribute("attr_app_project_relative_path", file.getProjectRelativePath().toOSString());
        workingCopy.setMappedResources(this.getResource(file.getProject().getName()));
        return workingCopy.doSave();
    }

    private IResource[] getResource(String projectName) {
        IStatus status;
        if (projectName.length() > 0 && (status = ResourcesPlugin.getWorkspace().validateName(projectName, 4)).isOK()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            return new IResource[]{project};
        }
        return null;
    }
}

