/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.propertytesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class NodePropertyTester
extends PropertyTester {
    private static final String IS_NODE_INIT = "isNodeInit";
    private static final String JS_EXT = "js";
    private static final String NODE_MODULES_FOLDER = "node_modules";
    private static final String BOWER_COMPONENTS_FOLDER = "bower_components";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_NODE_INIT.equals(property) && receiver instanceof IResource) {
            IResource resource = (IResource)receiver;
            if (resource instanceof IProject) {
                return this.hasPackageJson((IProject)receiver);
            }
            if (resource instanceof IFile) {
                return this.isValidFile((IFile)receiver);
            }
        }
        return false;
    }

    private boolean hasPackageJson(IProject project) {
        IFile packageJsonFile = project.getFile("package.json");
        return packageJsonFile != null && packageJsonFile.isAccessible();
    }

    private boolean isValidFile(IFile file) {
        String filePath;
        String fileExtension = file.getFileExtension();
        if (fileExtension == null || !fileExtension.equals(JS_EXT)) {
            return false;
        }
        return file.exists() && file.isAccessible() && (filePath = file.getFullPath().toOSString()) != null && !filePath.contains(NODE_MODULES_FOLDER) && !filePath.contains(BOWER_COMPONENTS_FOLDER);
    }
}

