/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.jsdt.js.node.NodePlugin;

public class LaunchConfigurationUtil {
    public static boolean isChromiumAvailable() {
        return Platform.getBundle((String)"org.eclipse.wst.jsdt.chromium.debug.core") != null;
    }

    public static String resolveValue(String expression) throws CoreException {
        String expanded = null;
        try {
            expanded = LaunchConfigurationUtil.getValue(expression);
        }
        catch (CoreException coreException) {
            LaunchConfigurationUtil.validateVariables(expression);
            return null;
        }
        return expanded;
    }

    public static ILaunchConfiguration getExistingLaunchConfiguration(IFile file, ILaunchConfigurationType launchConfigTypeId, String attributeName) {
        if (file == null) {
            return null;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] configurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations = launchManager.getLaunchConfigurations(launchConfigTypeId);
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                boolean match = false;
                IPath configPath = LaunchConfigurationUtil.getIPathFromLaunchConfig(config, attributeName);
                if (configPath != null && (path = LaunchConfigurationUtil.resolveValue(configPath.toOSString())) != null && path.equals(file.getRawLocation().toOSString())) {
                    match = true;
                }
                if (match) {
                    return config;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    public static ILaunchConfiguration getLaunchByName(String name, ILaunchConfigurationType type) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] configurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations = launchManager.getLaunchConfigurations(type);
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equals(name)) {
                    return config;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    private static IPath getIPathFromLaunchConfig(ILaunchConfiguration config, String attributeName) {
        Path configPath = null;
        try {
            configPath = new Path(config.getAttribute(attributeName, ""));
        }
        catch (CoreException e) {
            NodePlugin.logError(e.getLocalizedMessage());
        }
        return configPath;
    }

    private static String getValue(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(expression);
    }

    private static void validateVariables(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        manager.validateStringVariables(expression);
    }

    public static Map<String, String> getDefaultAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, "Node.js");
        return map;
    }
}

