/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.npm.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;
import org.eclipse.wst.jsdt.js.npm.PackageJson;

public final class NpmUtil {
    private NpmUtil() {
    }

    public static boolean isPackageJsonExist(IProject project) throws CoreException {
        IFile packageJson = null;
        if (project != null && project.isAccessible()) {
            packageJson = WorkbenchResourceUtil.findFileRecursively((IContainer)project, (String)"package.json");
        }
        return packageJson != null && packageJson.exists();
    }

    public static boolean hasPackageJson(IFolder folder) throws CoreException {
        IResource packageJson = folder.findMember("package.json");
        return packageJson != null && packageJson.exists();
    }

    public static boolean isPackageJson(IResource resource) {
        return resource != null && "package.json".equals(resource.getName()) && resource.exists();
    }

    public static String generateJson(PackageJson packageJson) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson((Object)packageJson);
    }

    public static IPath getNpmWorkingDir(IProject project, final String ... ignores) throws CoreException {
        IPath workingDir = null;
        final ArrayList foundFiles = new ArrayList();
        if (project != null && project.exists()) {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!foundFiles.isEmpty()) {
                        return false;
                    }
                    if (resource.getType() == 2 && ignores != null) {
                        String[] stringArray = ignores;
                        int n = ignores.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ignore = stringArray[n2];
                            if (resource.getName().equals(ignore)) {
                                return false;
                            }
                            ++n2;
                        }
                    } else if (resource.getType() == 1 && "package.json".equals(resource.getName())) {
                        foundFiles.add((IFile)resource);
                    }
                    return true;
                }
            });
        }
        if (!foundFiles.isEmpty()) {
            workingDir = ((IFile)foundFiles.get(0)).getParent().getLocation();
        }
        return workingDir;
    }
}

