/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.ui.internal.JSONUIMessages;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractValidationSettingsPage;

public class JSONValidatorPreferencePage
extends AbstractValidationSettingsPage {
    private static final String SETTINGS_SECTION_NAME = "JSONValidationSeverities";
    boolean fOriginalUseExtendedSyntaxValidation;
    private Combo fIndicateNoGrammar = null;
    private Combo fIndicateNoDocumentElement = null;
    private Button fExtendedSyntaxValidation;
    private Combo fMissingStartTag;
    private Combo fMissingEndTag;
    private Combo fMissingTagName;
    private Combo fEmptyElementTag;
    private Combo fEndTagWithAttributes;
    private Combo fInvalidWhitespaceBeforeTagname;
    private Combo fMissingClosingBracket;
    private Combo fMissingClosingQuote;
    private Combo fMissingQuotes;
    private Combo fInvalidNamespaceInPI;
    private Combo fInvalidWhitespaceAtStart;
    private Group fSyntaxValidationGroup;
    private ControlEnableState fSyntaxState;
    private static final int[] JSON_SEVERITIES = new int[]{2, 1, -1};
    private static final String[] SYNTAX_SEVERITIES = new String[]{JSONUIMessages.Severity_error, JSONUIMessages.Severity_warning, JSONUIMessages.Severity_ignore};

    private boolean getBooleanPreference(String key, boolean defaultValue, IScopeContext[] contexts) {
        return Platform.getPreferencesService().getBoolean(this.getPreferenceNodeQualifier(), key, defaultValue, contexts);
    }

    private void handleSyntaxSeveritySelection(boolean selection) {
        if (selection) {
            if (this.fSyntaxState != null) {
                this.fSyntaxState.restore();
                this.fSyntaxState = null;
            }
        } else if (this.fSyntaxState == null) {
            this.fSyntaxState = ControlEnableState.disable((Control)this.fSyntaxValidationGroup);
        }
    }

    protected void createContentsForSyntaxValidationGroup(Composite parent) {
        IScopeContext[] contexts = this.createPreferenceScopes();
        this.fOriginalUseExtendedSyntaxValidation = this.getBooleanPreference("syntaxValidation", false, contexts);
        this.fExtendedSyntaxValidation = this.createCheckBox(parent, JSONUIMessages.SyntaxValidation_files);
        ((GridData)this.fExtendedSyntaxValidation.getLayoutData()).horizontalSpan = 2;
        this.fExtendedSyntaxValidation.setSelection(this.fOriginalUseExtendedSyntaxValidation);
        this.fExtendedSyntaxValidation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSONValidatorPreferencePage.this.handleSyntaxSeveritySelection(JSONValidatorPreferencePage.this.fExtendedSyntaxValidation.getSelection());
            }
        });
        this.fSyntaxValidationGroup = this.createGroup(parent, 3);
        ((GridLayout)this.fSyntaxValidationGroup.getLayout()).makeColumnsEqualWidth = false;
        this.fSyntaxValidationGroup.setText(JSONUIMessages.SyntaxValidation_files_label);
        GridLayout layout = new GridLayout(3, false);
        this.fSyntaxValidationGroup.setLayout((Layout)layout);
        if (this.fMissingStartTag == null) {
            this.fMissingStartTag = this.addComboBox((Composite)this.fSyntaxValidationGroup, JSONUIMessages.Missing_start_object, "missingStartObject", JSON_SEVERITIES, SYNTAX_SEVERITIES, 0);
        }
        if (this.fMissingEndTag == null) {
            this.fMissingEndTag = this.addComboBox((Composite)this.fSyntaxValidationGroup, JSONUIMessages.Missing_end_object, "missingEndObject", JSON_SEVERITIES, SYNTAX_SEVERITIES, 0);
        }
        this.handleSyntaxSeveritySelection(this.fOriginalUseExtendedSyntaxValidation);
    }

    protected void performDefaultsForSyntaxValidationGroup() {
        IEclipsePreferences modelPreferences = new DefaultScope().getNode(this.getPreferenceNodeQualifier());
        boolean useExtendedSyntaxValidation = modelPreferences.getBoolean("syntaxValidation", false);
        if (this.fExtendedSyntaxValidation != null) {
            if (this.fExtendedSyntaxValidation.getSelection() != useExtendedSyntaxValidation) {
                this.handleSyntaxSeveritySelection(useExtendedSyntaxValidation);
            }
            this.fExtendedSyntaxValidation.setSelection(useExtendedSyntaxValidation);
        }
    }

    protected void storeValuesForSyntaxValidationGroup(IScopeContext[] contexts) {
        if (this.fExtendedSyntaxValidation != null) {
            boolean extendedSyntaxValidation = this.fExtendedSyntaxValidation.getSelection();
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean("syntaxValidation", extendedSyntaxValidation);
        }
    }

    protected void performDefaults() {
        this.resetSeverities();
        this.performDefaultsForSyntaxValidationGroup();
        super.performDefaults();
    }

    protected Preferences getModelPreferences() {
        return JSONCorePlugin.getDefault().getPluginPreferences();
    }

    protected void doSavePreferenceStore() {
        JSONCorePlugin.getDefault().savePluginPreferences();
    }

    protected void storeValues() {
        super.storeValues();
        IScopeContext[] contexts = this.createPreferenceScopes();
        this.storeValuesForSyntaxValidationGroup(contexts);
    }

    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        page.setLayout((Layout)layout);
        this.createContentsForSyntaxValidationGroup(page);
        return page;
    }

    protected String getPreferenceNodeQualifier() {
        return JSONCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferencePageID() {
        return "org.eclipse.wst.sse.ui.preferences.json.validation";
    }

    protected String getProjectSettingsKey() {
        return "use-project-settings";
    }

    protected String getPropertyPageID() {
        return "org.eclipse.wst.json.ui.propertyPage.project.validation";
    }

    public void init(IWorkbench workbench) {
    }

    private Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogSettings().addNewSection(SETTINGS_SECTION_NAME));
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        return JSONUIPlugin.getDefault().getDialogSettings();
    }

    protected boolean shouldRevalidateOnSettingsChange() {
        return this.fOriginalUseExtendedSyntaxValidation != this.fExtendedSyntaxValidation.getSelection() || super.shouldRevalidateOnSettingsChange();
    }
}

