/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.text.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.ui.internal.Logger;
import org.eclipse.wst.json.ui.internal.editor.JSONEditorPluginImageHelper;
import org.osgi.framework.Bundle;

public class HTMLJSONPrinter {
    private static String fgStyleSheet;

    public static String getAdditionalProposalInfo(IJSONPair pair) {
        StringBuffer buffer = new StringBuffer();
        ImageDescriptor descriptor = null;
        IJSONValue value = pair.getValue();
        if (value != null) {
            descriptor = JSONEditorPluginImageHelper.getInstance().getImageDescriptor(value.getNodeType());
        }
        HTMLJSONPrinter.startPage(buffer, HTMLJSONPrinter.getTitleKey(value), descriptor);
        HTMLJSONPrinter.startDefinitionList(buffer);
        HTMLJSONPrinter.addDefinitionListItem(buffer, "Key", pair.getName());
        HTMLJSONPrinter.addDefinitionListItem(buffer, "Type", HTMLJSONPrinter.getValueType(pair.getValue()));
        HTMLJSONPrinter.endDefinitionList(buffer);
        HTMLJSONPrinter.endPage(buffer);
        return buffer.toString();
    }

    private static String getTitleKey(IJSONValue value) {
        return "<b>JSON " + HTMLJSONPrinter.getValueType(value) + "</b>";
    }

    private static String getValueType(IJSONValue value) {
        if (value == null) {
            return "?";
        }
        switch (value.getNodeType()) {
            case 1: {
                return "Array";
            }
            case -1: {
                return "Document";
            }
            case 0: {
                return "Object";
            }
            case 5: {
                return "Boolean";
            }
            case 6: {
                return "Null";
            }
            case 4: {
                return "Number";
            }
            case 3: {
                return "String";
            }
        }
        return "?";
    }

    public static String getAdditionalProposalInfo(IJSONValue value) {
        StringBuffer buffer = new StringBuffer();
        ImageDescriptor descriptor = JSONEditorPluginImageHelper.getInstance().getImageDescriptor(value.getNodeType());
        HTMLJSONPrinter.startPage(buffer, "<b>JSON Value</b>", descriptor);
        HTMLJSONPrinter.startDefinitionList(buffer);
        HTMLJSONPrinter.addDefinitionListItem(buffer, "Value", value.getSimpleValue());
        HTMLJSONPrinter.addDefinitionListItem(buffer, "Type", HTMLJSONPrinter.getValueType(value));
        HTMLJSONPrinter.endDefinitionList(buffer);
        HTMLJSONPrinter.endPage(buffer);
        return buffer.toString();
    }

    private static String getTitle(IJSONValue value) {
        StringBuilder title = new StringBuilder("<b>");
        title.append(HTMLJSONPrinter.getValueType(value));
        title.append("</b>");
        return title.toString();
    }

    public static void startDefinitionList(StringBuffer buffer) {
        buffer.append("<dl>");
    }

    public static void endDefinitionList(StringBuffer buffer) {
        buffer.append("</dl>");
    }

    public static void addDefinitionListItem(StringBuffer buffer, String name, String value) {
        if (value != null) {
            buffer.append("<dt><b>");
            buffer.append(name);
            buffer.append(":</b></dt>");
            buffer.append("<dd>");
            buffer.append(value);
            buffer.append("</dd>");
        }
    }

    private static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = HTMLJSONPrinter.loadStyleSheet("/JSONHoverStyleSheet.css");
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet(String styleSheetName) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.json.ui");
        URL styleSheetURL = bundle.getEntry(styleSheetName);
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
        StringBuffer buffer = new StringBuffer(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                Logger.logException("Error while loading style sheets", ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return "";
        }
    }

    public static void startPage(StringBuffer buf, String title, ImageDescriptor descriptor) {
        int imageWidth = 16;
        int imageHeight = 16;
        int labelLeft = 20;
        int labelTop = 2;
        buf.append("<div style='word-wrap: break-word; position: relative; ");
        String imageSrcPath = HTMLJSONPrinter.getImageURL(descriptor);
        if (imageSrcPath != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("padding-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        if (imageSrcPath != null) {
            String uri = "";
            buf.append("<a href=\"");
            buf.append(uri);
            buf.append("\" >");
            StringBuffer imageStyle = new StringBuffer("border:none; position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            imageStyle.append("left: ").append(-labelLeft - 1).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            String tooltip = "alt='' ";
            buf.append("<span ").append(tooltip).append("style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageSrcPath).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<![endif]-->\n");
            buf.append("</a>");
        }
        buf.append(title);
        buf.append("</div>");
        buf.append("<hr />");
    }

    private static String getImageURL(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        String imageName = null;
        URL imageUrl = JSONEditorPluginImageHelper.getInstance().getImageURL(descriptor);
        if (imageUrl != null) {
            imageName = imageUrl.toExternalForm();
        }
        return imageName;
    }

    public static void endPage(StringBuffer buffer) {
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)HTMLJSONPrinter.getStyleSheet());
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
    }
}

