/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jpt.jpa.core.tests.internal.JptJpaCoreMiscTests;
import org.eclipse.jpt.jpa.core.tests.internal.context.JptJpaCoreContextModelTests;
import org.eclipse.jpt.jpa.core.tests.internal.model.JptJpaCoreModelTests;
import org.eclipse.jpt.jpa.core.tests.internal.resource.JptJpaCoreResourceModelTests;

public class JptJpaCoreTests {
    private static final String JPA_JAR_PROPERTY = "org.eclipse.jpt.jpa.jar";

    public static Test suite() {
        TestSuite suite = new TestSuite(JptJpaCoreTests.class.getPackage().getName());
        suite.addTest(JptJpaCoreModelTests.suite());
        suite.addTest(JptJpaCoreResourceModelTests.suite());
        suite.addTest(JptJpaCoreContextModelTests.suite());
        suite.addTest(JptJpaCoreMiscTests.suite());
        return suite;
    }

    public static boolean requiredJarsExists() {
        return JptJpaCoreTests.jpaJarPropertyExists() && JptJpaCoreTests.jpaJarFileExists();
    }

    public static boolean jpaJarPropertyExists() {
        return JptJpaCoreTests.getSystemProperty(JPA_JAR_PROPERTY) != null;
    }

    public static boolean jpaJarFileExists() {
        return new File(JptJpaCoreTests.getSystemProperty(JPA_JAR_PROPERTY)).exists();
    }

    public static String buildMissingJarErrorMessage() {
        if (!JptJpaCoreTests.jpaJarPropertyExists()) {
            return JptJpaCoreTests.errorMissingProperty(JPA_JAR_PROPERTY);
        }
        return JptJpaCoreTests.errorJarFileDoesNotExist(JptJpaCoreTests.getSystemProperty(JPA_JAR_PROPERTY));
    }

    private static String errorMissingProperty(String propertyName) {
        return "missing Java system property: \"" + propertyName + "\"";
    }

    private static String errorJarFileDoesNotExist(String propertyValue) {
        return "JAR file doesn't exist: \"" + propertyValue + "\"";
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    private JptJpaCoreTests() {
        throw new UnsupportedOperationException();
    }
}

