/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class SecondaryTableTests
extends JpaJavaResourceModelTestCase {
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String SCHEMA_NAME = "MY_SCHEMA";
    private static final String CATALOG_NAME = "MY_CATALOG";

    public SecondaryTableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestSecondaryTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SecondaryTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTable");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SecondaryTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTable(name = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithSchema() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SecondaryTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTable(schema = \"MY_SCHEMA\")");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithCatalog() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SecondaryTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTable(catalog = \"MY_CATALOG\")");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithUniqueConstraints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SecondaryTable", "javax.persistence.UniqueConstraint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithPkJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SecondaryTable", "javax.persistence.PrimaryKeyJoinColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"BAR\"), @PrimaryKeyJoinColumn(name = \"FOO\"), @PrimaryKeyJoinColumn(name = \"BAZ\")})");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertNotNull((Object)table);
        SecondaryTableTests.assertEquals((String)TABLE_NAME, (String)table.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertNotNull((Object)table);
        SecondaryTableTests.assertNull((Object)table.getName());
        SecondaryTableTests.assertNull((Object)table.getCatalog());
        SecondaryTableTests.assertNull((Object)table.getSchema());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertNotNull((Object)table);
        SecondaryTableTests.assertNull((Object)table.getName());
        table.setName("Foo");
        SecondaryTableTests.assertEquals((String)"Foo", (String)table.getName());
        this.assertSourceContains("@SecondaryTable(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((String)TABLE_NAME, (String)table.getName());
        table.setName(null);
        SecondaryTableTests.assertNull((Object)table.getName());
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertNotNull((Object)table);
        SecondaryTableTests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
    }

    public void testSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertNotNull((Object)table);
        SecondaryTableTests.assertNull((Object)table.getCatalog());
        table.setCatalog("Foo");
        SecondaryTableTests.assertEquals((String)"Foo", (String)table.getCatalog());
        this.assertSourceContains("@SecondaryTable(catalog = \"Foo\")", cu);
    }

    public void testSetCatalogNull() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
        table.setCatalog(null);
        SecondaryTableTests.assertNull((Object)table.getCatalog());
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertNotNull((Object)table);
        SecondaryTableTests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
    }

    public void testSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertNotNull((Object)table);
        SecondaryTableTests.assertNull((Object)table.getSchema());
        table.setSchema("Foo");
        SecondaryTableTests.assertEquals((String)"Foo", (String)table.getSchema());
        this.assertSourceContains("@SecondaryTable(schema = \"Foo\")", cu);
    }

    public void testSetSchemaNull() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
        table.setSchema(null);
        SecondaryTableTests.assertNull((Object)table.getSchema());
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testUniqueConstraints() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((int)0, (int)table.getUniqueConstraintsSize());
    }

    public void testUniqueConstraints2() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.addUniqueConstraint(0);
        table.addUniqueConstraint(1);
        SecondaryTableTests.assertEquals((int)2, (int)table.getUniqueConstraintsSize());
    }

    public void testUniqueConstraints3() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((int)3, (int)table.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(1);
        table.addUniqueConstraint(0).addColumnName("BAR");
        SecondaryTableTests.assertEquals((String)"BAR", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"FOO", (String)table.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTableTests.assertEquals((int)0, (int)table.uniqueConstraintAt(2).getColumnNamesSize());
        this.assertSourceContains("@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = \"BAR\"),@UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint})", cu);
    }

    public void testRemoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.removeUniqueConstraint(1);
        ListIterator uniqueConstraints = table.getUniqueConstraints().iterator();
        SecondaryTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        SecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        this.assertSourceContains("@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})", cu);
        table.removeUniqueConstraint(0);
        uniqueConstraints = table.getUniqueConstraints().iterator();
        SecondaryTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        SecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        this.assertSourceContains("@SecondaryTable(uniqueConstraints = @UniqueConstraint(columnNames = {\"BAZ\"}))", cu);
        table.removeUniqueConstraint(0);
        uniqueConstraints = table.getUniqueConstraints().iterator();
        SecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testMoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"BAZ", (String)secondaryTable.uniqueConstraintAt(2).columnNameAt(0));
        SecondaryTableTests.assertEquals((int)3, (int)secondaryTable.getUniqueConstraintsSize());
        secondaryTable.moveUniqueConstraint(2, 0);
        SecondaryTableTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"BAZ", (String)secondaryTable.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(2).columnNameAt(0));
        SecondaryTableTests.assertEquals((int)3, (int)secondaryTable.getUniqueConstraintsSize());
        this.assertSourceContains("@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"})})", cu);
    }

    public void testMoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"BAZ", (String)secondaryTable.uniqueConstraintAt(2).columnNameAt(0));
        SecondaryTableTests.assertEquals((int)3, (int)secondaryTable.getUniqueConstraintsSize());
        secondaryTable.moveUniqueConstraint(0, 2);
        SecondaryTableTests.assertEquals((String)"BAZ", (String)secondaryTable.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTableTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(2).columnNameAt(0));
        SecondaryTableTests.assertEquals((int)3, (int)secondaryTable.getUniqueConstraintsSize());
        this.assertSourceContains("@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"})})", cu);
    }

    public void testPkJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((int)0, (int)table.getPkJoinColumnsSize());
    }

    public void testPkJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.addPkJoinColumn(0);
        table.addPkJoinColumn(1);
        SecondaryTableTests.assertEquals((int)2, (int)table.getPkJoinColumnsSize());
    }

    public void testPkJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((int)3, (int)table.getPkJoinColumnsSize());
    }

    public void testAddPkJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.addPkJoinColumn(0).setName("FOO");
        table.addPkJoinColumn(0);
        table.addPkJoinColumn(0).setName("BAR");
        SecondaryTableTests.assertEquals((String)"BAR", (String)table.pkJoinColumnAt(0).getName());
        SecondaryTableTests.assertNull((Object)table.pkJoinColumnAt(1).getName());
        SecondaryTableTests.assertEquals((String)"FOO", (String)table.pkJoinColumnAt(2).getName());
        SecondaryTableTests.assertEquals((int)3, (int)table.getPkJoinColumnsSize());
        this.assertSourceContains("@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"BAR\"),@PrimaryKeyJoinColumn, @PrimaryKeyJoinColumn(name = \"FOO\")})", cu);
    }

    public void testRemovePkJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.removePkJoinColumn(1);
        this.assertSourceContains("@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"BAR\"), @PrimaryKeyJoinColumn(name = \"BAZ\")})", cu);
        table.removePkJoinColumn(0);
        this.assertSourceContains("@SecondaryTable(pkJoinColumns = @PrimaryKeyJoinColumn(name = \"BAZ\"))", cu);
        table.removePkJoinColumn(0);
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testMovePkJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        PrimaryKeyJoinColumnAnnotation joinColumn = table.pkJoinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        table.movePkJoinColumn(2, 0);
        this.assertSourceContains("@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"FOO\"), @PrimaryKeyJoinColumn(name = \"BAZ\"), @PrimaryKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", columnDefinition = \"COLUMN_DEF\")})", cu);
    }

    public void testMovePkJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        PrimaryKeyJoinColumnAnnotation joinColumn = table.pkJoinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        table.movePkJoinColumn(0, 2);
        this.assertSourceContains("@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"BAZ\"), @PrimaryKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", columnDefinition = \"COLUMN_DEF\"), @PrimaryKeyJoinColumn(name = \"FOO\")})", cu);
    }

    public void testSetPkJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTableTests.assertEquals((int)3, (int)table.getPkJoinColumnsSize());
        PrimaryKeyJoinColumnAnnotation joinColumn = table.pkJoinColumnAt(0);
        SecondaryTableTests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        SecondaryTableTests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"foo\"), @PrimaryKeyJoinColumn(name = \"FOO\"), @PrimaryKeyJoinColumn(name = \"BAZ\")})", cu);
    }
}

