/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaNullTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMappedSuperclass;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_2ContextModelTestCase;

public class EclipseLink2_2JavaMappedSuperclassTests
extends EclipseLink2_2ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
            }
        });
    }

    public EclipseLink2_2JavaMappedSuperclassTests(String name) {
        super(name);
    }

    public void testMorphToEntity() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        mappedSuperclass.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        mappedSuperclass.getConverterContainer().addCustomConverter("customConverter", 0);
        mappedSuperclass.getConverterContainer().addCustomConverter("customConverter2", 1);
        mappedSuperclass.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        mappedSuperclass.getConverterContainer().addObjectTypeConverter("objectTypeConverter2", 1);
        mappedSuperclass.getConverterContainer().addTypeConverter("typeConverter", 0);
        mappedSuperclass.getConverterContainer().addTypeConverter("typeConverter2", 1);
        mappedSuperclass.getConverterContainer().addStructConverter("structConverter", 0);
        mappedSuperclass.getConverterContainer().addStructConverter("structConverter2", 1);
        mappedSuperclass.getGeneratorContainer().addTableGenerator();
        mappedSuperclass.getGeneratorContainer().addSequenceGenerator();
        mappedSuperclass.getReadOnly().setSpecifiedReadOnly(Boolean.TRUE);
        this.getJavaPersistentType().setMappingKey("entity");
        EclipseLink2_2JavaMappedSuperclassTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Entity));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_2JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.MappedSuperclass"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
    }

    public void testMorphToEmbeddable() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        mappedSuperclass.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        mappedSuperclass.getConverterContainer().addCustomConverter("customConverter", 0);
        mappedSuperclass.getConverterContainer().addCustomConverter("customConverter2", 1);
        mappedSuperclass.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        mappedSuperclass.getConverterContainer().addObjectTypeConverter("objectTypeConverter2", 1);
        mappedSuperclass.getConverterContainer().addTypeConverter("typeConverter", 0);
        mappedSuperclass.getConverterContainer().addTypeConverter("typeConverter2", 1);
        mappedSuperclass.getConverterContainer().addStructConverter("structConverter", 0);
        mappedSuperclass.getConverterContainer().addStructConverter("structConverter2", 1);
        mappedSuperclass.getGeneratorContainer().addTableGenerator();
        mappedSuperclass.getGeneratorContainer().addSequenceGenerator();
        mappedSuperclass.getReadOnly().setSpecifiedReadOnly(Boolean.TRUE);
        this.getJavaPersistentType().setMappingKey("embeddable");
        EclipseLink2_2JavaMappedSuperclassTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Embeddable));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_2JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.MappedSuperclass"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation(1, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.TableGenerator"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.SequenceGenerator"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
    }

    public void testMorphToNull() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        mappedSuperclass.getIdClassReference().setSpecifiedIdClassName("myIdClass");
        mappedSuperclass.getConverterContainer().addCustomConverter("customConverter", 0);
        mappedSuperclass.getConverterContainer().addCustomConverter("customConverter2", 1);
        mappedSuperclass.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        mappedSuperclass.getConverterContainer().addObjectTypeConverter("objectTypeConverter2", 1);
        mappedSuperclass.getConverterContainer().addTypeConverter("typeConverter", 0);
        mappedSuperclass.getConverterContainer().addTypeConverter("typeConverter2", 1);
        mappedSuperclass.getConverterContainer().addStructConverter("structConverter", 0);
        mappedSuperclass.getConverterContainer().addStructConverter("structConverter2", 1);
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        EclipseLink2_2JavaMappedSuperclassTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof JavaNullTypeMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_2JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.MappedSuperclass"));
        EclipseLink2_2JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.IdClass"));
        EclipseLink2_2JavaMappedSuperclassTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("org.eclipse.persistence.annotations.Converter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("org.eclipse.persistence.annotations.TypeConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("org.eclipse.persistence.annotations.StructConverter"));
        EclipseLink2_2JavaMappedSuperclassTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("org.eclipse.persistence.annotations.ObjectTypeConverter"));
    }
}

