/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class ConverterAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public ConverterAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Converter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Converter");
            }
        });
    }

    private ICompilationUnit createTestConverterWithConverterClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Converter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Converter(converterClass=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestConverterWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.Converter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Converter(name=\"bar\")");
            }
        });
    }

    public void testConverterAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConverterAnnotationTests.assertNotNull((Object)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter"));
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("org.eclipse.persistence.annotations.Converter"));
        resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertNotNull((Object)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter"));
    }

    public void testGetConverterClass() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithConverterClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConverterAnnotation converter = (ConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
    }

    public void testSetConverterClass() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithConverterClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConverterAnnotation converter = (ConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        converter.setConverterClass("Bar");
        ConverterAnnotationTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        this.assertSourceContains("@Converter(converterClass=Bar.class)", cu);
    }

    public void testSetConverterClassNull() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithConverterClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConverterAnnotation converter = (ConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        converter.setConverterClass(null);
        ConverterAnnotationTests.assertNull((Object)converter.getConverterClass());
        this.assertSourceContains("@Converter", cu);
        this.assertSourceDoesNotContain("converterClass", cu);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConverterAnnotation converter = (ConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConverterAnnotation converter = (ConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName("foo");
        ConverterAnnotationTests.assertEquals((String)"foo", (String)converter.getName());
        this.assertSourceContains("@Converter(name=\"foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ConverterAnnotation converter = (ConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.Converter");
        ConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName(null);
        ConverterAnnotationTests.assertNull((Object)converter.getName());
        this.assertSourceContains("@Converter", cu);
        this.assertSourceDoesNotContain("name=", cu);
    }
}

