/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.html;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TableInsertHeaderFooterCommand
extends DesignerCommand {
    private Element _table;
    private Element _headerOrFooter;
    private boolean _isHeader;
    private TableUtil _tableUtil;

    public TableInsertHeaderFooterCommand(IHTMLGraphicalViewer viewer, Element table, boolean isHeader) {
        super(isHeader ? CommandResources.getString("TableInsertHeaderFooterCommand.Label.InsertHeader") : CommandResources.getString("TableInsertHeaderFooterCommand.Label.InsertFooter"), viewer);
        this._table = table;
        this._isHeader = isHeader;
        this._tableUtil = new TableUtil(this._table);
    }

    public boolean canExecute() {
        String sectionName = this._isHeader ? "thead" : "tfoot";
        int rows = TableUtil.countSectionRows(this._table, sectionName);
        if (rows > 0) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        String sectionName = this._isHeader ? "thead" : "tfoot";
        this._headerOrFooter = this._table.getOwnerDocument().createElement(sectionName);
        Element tr = this.createDefaultElement();
        this._headerOrFooter.appendChild(tr);
        if (this._isHeader) {
            Node child = this._table.getFirstChild();
            this._table.insertBefore(this._headerOrFooter, child);
        } else {
            int headRows = TableUtil.countSectionRows(this._table, "thead");
            Node refNode = null;
            if (headRows > 0) {
                List list = DOMUtil.getChildElementsByTagIgnoreCase(this._table, "thead");
                Node header = (Node)list.get(0);
                refNode = header.getNextSibling();
            } else {
                refNode = this._table.getFirstChild();
            }
            this._table.insertBefore(this._headerOrFooter, refNode);
        }
        this.formatNode(this._headerOrFooter);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._headerOrFooter);
    }

    private Element createDefaultElement() {
        String key = this._isHeader ? "TableInsertHeaderFooterCommand.ColumnHeader" : "TableInsertHeaderFooterCommand.ColumnFooter";
        String name = PDPlugin.getResourceString(key);
        Document doc = this._table.getOwnerDocument();
        Element ele = doc.createElement("tr");
        int columnCount = this._tableUtil.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Element td = null;
            td = this._isHeader ? doc.createElement("th") : doc.createElement("td");
            Text node = doc.createTextNode(name);
            td.appendChild(node);
            ele.appendChild(td);
            ++i;
        }
        return ele;
    }
}

