/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.web.ui.actions.JsElementActionProxy;
import org.eclipse.wst.jsdt.web.ui.actions.Messages;

public class ShowHistoryAction
extends JsElementActionProxy {
    private IResource getHostResource(IJavaScriptElement virtualElement) {
        IProject project = virtualElement.getJavaScriptProject().getProject();
        Path path = new Path(virtualElement.getHostPath().getPath());
        IResource host = project.getWorkspace().getRoot().findMember((IPath)path);
        return host;
    }

    public void run(IAction action) {
        IJavaScriptElement[] elements = JsElementActionProxy.getJsElementsFromSelection(this.getCurrentSelection());
        if (elements == null || elements.length == 0) {
            return;
        }
        IResource resource = null;
        resource = elements[0].isVirtual() ? this.getHostResource(elements[0]) : elements[0].getResource();
        if (resource == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.targetWorkbenchPart.getSite().getPage();
            IViewPart view = page.showView("org.eclipse.ui.views.ResourceNavigator");
            if (view instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection((Object)resource);
                ((ISetSelectionTarget)view).selectReveal((ISelection)selection);
            }
        }
        catch (PartInitException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.targetWorkbenchPart.getSite().getShell(), (String)Messages.getString("ShowHistoryAction.0"), (String)(String.valueOf(Messages.getString("ShowHistoryAction.1")) + (Object)((Object)e)));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
        IJavaScriptElement[] elements = JsElementActionProxy.getJsElementsFromSelection(this.getCurrentSelection());
        int i = 0;
        while (i < elements.length) {
            IResource resource;
            if (elements[i].isVirtual() && ((resource = this.getHostResource(elements[i])) == null || !resource.exists())) {
                action.setEnabled(false);
            }
            ++i;
        }
    }
}

